/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractPmdViolationCheckMojo
extends AbstractMojo {
    private static final Boolean FAILURES_KEY = Boolean.TRUE;
    private static final Boolean WARNINGS_KEY = Boolean.FALSE;
    private File targetDirectory;
    private boolean failOnViolation;
    private String language;
    protected boolean aggregate;
    private boolean verbose;
    protected MavenProject project;

    protected void executeCheck(String filename, String tagName, String key, int failurePriority) throws MojoFailureException, MojoExecutionException {
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return;
        }
        if ("java".equals(this.language) || this.aggregate) {
            File outputFile = new File(this.targetDirectory, filename);
            if (outputFile.exists()) {
                try {
                    MXParser xpp = new MXParser();
                    FileReader freader = new FileReader(outputFile);
                    BufferedReader breader = new BufferedReader(freader);
                    xpp.setInput((Reader)breader);
                    Map violations = this.getViolations((XmlPullParser)xpp, tagName, failurePriority);
                    List failures = (List)violations.get(FAILURES_KEY);
                    List warnings = (List)violations.get(WARNINGS_KEY);
                    if (this.verbose) {
                        this.printErrors(failures, warnings);
                    }
                    int failureCount = failures.size();
                    int warningCount = warnings.size();
                    String message = this.getMessage(failureCount, warningCount, key, outputFile);
                    if (failureCount > 0 && this.failOnViolation) {
                        throw new MojoFailureException(message);
                    }
                    this.getLog().info((CharSequence)message);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to read PMD results xml: " + outputFile.getAbsolutePath(), (Exception)e);
                }
                catch (XmlPullParserException e) {
                    throw new MojoExecutionException("Unable to read PMD results xml: " + outputFile.getAbsolutePath(), (Exception)((Object)e));
                }
            } else {
                throw new MojoFailureException("Unable to perform check, unable to find " + outputFile);
            }
        }
    }

    private Map getViolations(XmlPullParser xpp, String tagName, int failurePriority) throws XmlPullParserException, IOException {
        int eventType = xpp.getEventType();
        ArrayList<Map> failures = new ArrayList<Map>();
        ArrayList<Map> warnings = new ArrayList<Map>();
        while (eventType != 1) {
            if (eventType == 2 && tagName.equals(xpp.getName())) {
                Map details = this.getErrorDetails(xpp);
                try {
                    int priority = Integer.parseInt((String)details.get("priority"));
                    if (priority <= failurePriority) {
                        failures.add(details);
                    } else {
                        warnings.add(details);
                    }
                }
                catch (NumberFormatException e) {
                    failures.add(details);
                }
                catch (NullPointerException e) {
                    failures.add(details);
                }
            }
            eventType = xpp.next();
        }
        HashMap<Boolean, ArrayList<Map>> map = new HashMap<Boolean, ArrayList<Map>>(2);
        map.put(FAILURES_KEY, failures);
        map.put(WARNINGS_KEY, warnings);
        return map;
    }

    protected void printErrors(List failures, List warnings) {
        Iterator iter = warnings.iterator();
        while (iter.hasNext()) {
            this.printError((Map)iter.next(), "Warning");
        }
        iter = failures.iterator();
        while (iter.hasNext()) {
            this.printError((Map)iter.next(), "Failure");
        }
    }

    private String getMessage(int failureCount, int warningCount, String key, File outputFile) {
        StringBuffer message = new StringBuffer();
        if (failureCount > 0 || warningCount > 0) {
            if (failureCount > 0) {
                message.append("You have " + failureCount + " " + key + (failureCount > 1 ? "s" : ""));
            }
            if (warningCount > 0) {
                if (failureCount > 0) {
                    message.append(" and ");
                } else {
                    message.append("You have ");
                }
                message.append(warningCount + " warning" + (warningCount > 1 ? "s" : ""));
            }
            message.append(". For more details see:" + outputFile.getAbsolutePath());
        }
        return message.toString();
    }

    protected abstract void printError(Map var1, String var2);

    protected abstract Map getErrorDetails(XmlPullParser var1) throws XmlPullParserException, IOException;
}

