/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin.report;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.doxia.markup.Markup;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.plugin.report.RequirementsHistory;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.plugin.descriptor.EnhancedPluginDescriptorBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.ExtendedPluginDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.generator.PluginXdocGenerator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="report", threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class PluginReport
extends AbstractMavenReport {
    @Parameter(defaultValue="${project.build.directory}/generated-site")
    private File generatedSiteDirectory;
    @Parameter(defaultValue="false", property="maven.plugin.report.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="maven.plugin.report.hasExtensionsToLoad")
    private boolean hasExtensionsToLoad;
    @Parameter
    private List<RequirementsHistory> requirementsHistories = new ArrayList<RequirementsHistory>();
    @Component
    private RuntimeInformation rtInfo;
    @Component
    private I18N i18n;
    @Parameter(defaultValue="${project.build.directory}/plugin-enhanced.xml", required=true, readonly=true)
    private File enhancedPluginXmlFile;
    @Parameter(property="maven.plugin.report.disableInternalJavadocLinkValidation")
    private boolean disableInternalJavadocLinkValidation;

    protected String getOutputDirectory() {
        return this.project.getReporting().getOutputDirectory();
    }

    public boolean canGenerateReport() {
        return this.enhancedPluginXmlFile != null && this.enhancedPluginXmlFile.isFile() && this.enhancedPluginXmlFile.canRead();
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Maven Plugin Plugin Report generation skipped.");
            return;
        }
        PluginDescriptor pluginDescriptor = this.extractPluginDescriptor();
        this.generateMojosDocumentation(pluginDescriptor, locale);
        PluginOverviewRenderer r = new PluginOverviewRenderer(this.getSink(), this.i18n, locale, this.getProject(), this.requirementsHistories, pluginDescriptor, this.hasExtensionsToLoad);
        r.render();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginDescriptor extractPluginDescriptor() throws MavenReportException {
        EnhancedPluginDescriptorBuilder builder = new EnhancedPluginDescriptorBuilder(this.rtInfo);
        try (XmlStreamReader input = new XmlStreamReader(Files.newInputStream(this.enhancedPluginXmlFile.toPath(), new OpenOption[0]));){
            PluginDescriptor pluginDescriptor = builder.build((Reader)input);
            return pluginDescriptor;
        }
        catch (IOException | PlexusConfigurationException e) {
            throw new MavenReportException("Error extracting plugin descriptor from " + this.enhancedPluginXmlFile, (Exception)e);
        }
    }

    private String getI18nString(Locale locale, String key) {
        return this.i18n.getString("plugin-report", locale, "report.plugin." + key);
    }

    public String getName(Locale locale) {
        return this.getI18nString(locale, "name");
    }

    public String getDescription(Locale locale) {
        return this.getI18nString(locale, "description");
    }

    public String getOutputName() {
        return "plugin-info";
    }

    private void generateMojosDocumentation(PluginDescriptor pluginDescriptor, Locale locale) throws MavenReportException {
        try {
            File outputDir = !locale.equals(SiteTool.DEFAULT_LOCALE) ? new File(new File(this.generatedSiteDirectory, locale.toString()), "xdoc") : new File(this.generatedSiteDirectory, "xdoc");
            outputDir.mkdirs();
            PluginXdocGenerator generator = new PluginXdocGenerator(this.getProject(), locale, this.getReportOutputDirectory(), this.disableInternalJavadocLinkValidation);
            DefaultPluginToolsRequest pluginToolsRequest = new DefaultPluginToolsRequest(this.getProject(), pluginDescriptor);
            generator.execute(outputDir, (PluginToolsRequest)pluginToolsRequest);
        }
        catch (GeneratorException e) {
            throw new MavenReportException("Error writing plugin documentation", (Exception)((Object)e));
        }
    }

    static class PluginOverviewRenderer
    extends AbstractMavenReportRenderer {
        private final I18N i18n;
        private final Locale locale;
        private final MavenProject project;
        private final List<RequirementsHistory> requirementsHistories;
        private final PluginDescriptor pluginDescriptor;
        private final boolean hasExtensionsToLoad;

        PluginOverviewRenderer(Sink sink, I18N i18n, Locale locale, MavenProject project, List<RequirementsHistory> requirementsHistories, PluginDescriptor pluginDescriptor, boolean hasExtensionsToLoad) {
            super(sink);
            this.i18n = i18n;
            this.locale = locale;
            this.project = project;
            this.requirementsHistories = requirementsHistories;
            this.pluginDescriptor = pluginDescriptor;
            this.hasExtensionsToLoad = hasExtensionsToLoad;
        }

        public String getTitle() {
            return this.getI18nString("title");
        }

        protected String getI18nString(String key) {
            return this.i18n.getString("plugin-report", this.locale, "report.plugin." + key);
        }

        public void renderBody() {
            this.startSection(this.getTitle());
            if (this.pluginDescriptor.getMojos() == null || this.pluginDescriptor.getMojos().size() <= 0) {
                this.paragraph(this.getI18nString("goals.nogoal"));
                this.endSection();
                return;
            }
            this.paragraph(this.getI18nString("goals.intro"));
            boolean hasMavenReport = false;
            for (MojoDescriptor mojo : this.pluginDescriptor.getMojos()) {
                if (!GeneratorUtils.isMavenReport((String)mojo.getImplementation(), (MavenProject)this.project)) continue;
                hasMavenReport = true;
            }
            this.startTable();
            String goalColumnName = this.getI18nString("goals.column.goal");
            String isMavenReport = this.getI18nString("goals.column.isMavenReport");
            String descriptionColumnName = this.getI18nString("goals.column.description");
            if (hasMavenReport) {
                this.tableHeader(new String[]{goalColumnName, isMavenReport, descriptionColumnName});
            } else {
                this.tableHeader(new String[]{goalColumnName, descriptionColumnName});
            }
            ArrayList mojos = new ArrayList();
            mojos.addAll(this.pluginDescriptor.getMojos());
            PluginUtils.sortMojos(mojos);
            for (MojoDescriptor mojo : mojos) {
                String goalName = mojo.getFullGoalName();
                String goalDocumentationLink = "./" + mojo.getGoal() + "-mojo.html";
                String description = StringUtils.isNotEmpty((String)mojo.getDeprecated()) ? "<strong>" + this.getI18nString("goal.deprecated") + "</strong> " + mojo.getDeprecated() : (StringUtils.isNotEmpty((String)mojo.getDescription()) ? mojo.getDescription() : this.getI18nString("goal.nodescription"));
                this.sink.tableRow();
                this.tableCell(PluginOverviewRenderer.createLinkPatternedText((String)goalName, (String)goalDocumentationLink));
                if (hasMavenReport) {
                    if (GeneratorUtils.isMavenReport((String)mojo.getImplementation(), (MavenProject)this.project)) {
                        this.tableCell(this.getI18nString("isReport"));
                    } else {
                        this.tableCell(this.getI18nString("isNotReport"));
                    }
                }
                this.tableCell(description, true);
                this.sink.tableRow_();
            }
            this.endTable();
            this.startSection(this.getI18nString("systemrequirements"));
            this.paragraph(this.getI18nString("systemrequirements.intro"));
            this.startTable();
            String maven = PluginOverviewRenderer.discoverMavenRequirement(this.project, this.pluginDescriptor);
            this.sink.tableRow();
            this.tableCell(this.getI18nString("systemrequirements.maven"));
            this.tableCell(maven != null ? maven : this.getI18nString("systemrequirements.nominimum"));
            this.sink.tableRow_();
            String jdk = PluginOverviewRenderer.discoverJdkRequirement(this.project, this.pluginDescriptor);
            this.sink.tableRow();
            this.tableCell(this.getI18nString("systemrequirements.jdk"));
            this.tableCell(jdk != null ? jdk : this.getI18nString("systemrequirements.nominimum"));
            this.sink.tableRow_();
            this.endTable();
            this.endSection();
            this.renderRequirementsHistories();
            this.renderUsageSection(hasMavenReport);
            this.endSection();
        }

        private void renderRequirementsHistories() {
            if (this.requirementsHistories.isEmpty()) {
                return;
            }
            this.startSection(this.getI18nString("systemrequirements.history"));
            this.paragraph(this.getI18nString("systemrequirements.history.intro"));
            this.startTable();
            this.tableHeader(new String[]{this.getI18nString("systemrequirements.history.version"), this.getI18nString("systemrequirements.history.maven"), this.getI18nString("systemrequirements.history.jdk")});
            this.requirementsHistories.forEach(requirementsHistory -> {
                this.sink.tableRow();
                this.tableCell(requirementsHistory.getVersion());
                this.tableCell(requirementsHistory.getMaven());
                this.tableCell(requirementsHistory.getJdk());
                this.sink.tableRow_();
            });
            this.endTable();
            this.endSection();
        }

        private void renderUsageSection(boolean hasMavenReport) {
            this.startSection(this.getI18nString("usage"));
            this.paragraph(this.getI18nString("usage.intro"));
            StringBuilder sb = new StringBuilder();
            sb.append("<project>").append(Markup.EOL);
            sb.append("  ...").append(Markup.EOL);
            sb.append("  <build>").append(Markup.EOL);
            sb.append("    <!-- " + this.getI18nString("usage.pluginManagement") + " -->").append(Markup.EOL);
            sb.append("    <pluginManagement>").append(Markup.EOL);
            sb.append("      <plugins>").append(Markup.EOL);
            sb.append("        <plugin>").append(Markup.EOL);
            sb.append("          <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append(Markup.EOL);
            sb.append("          <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append(Markup.EOL);
            sb.append("          <version>").append(this.pluginDescriptor.getVersion()).append("</version>").append(Markup.EOL);
            if (this.hasExtensionsToLoad) {
                sb.append("          <extensions>true</extensions>").append(Markup.EOL);
            }
            sb.append("        </plugin>").append(Markup.EOL);
            sb.append("        ...").append(Markup.EOL);
            sb.append("      </plugins>").append(Markup.EOL);
            sb.append("    </pluginManagement>").append(Markup.EOL);
            sb.append("    <!-- " + this.getI18nString("usage.plugins") + " -->").append(Markup.EOL);
            sb.append("    <plugins>").append(Markup.EOL);
            sb.append("      <plugin>").append(Markup.EOL);
            sb.append("        <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append(Markup.EOL);
            sb.append("        <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append(Markup.EOL);
            sb.append("      </plugin>").append(Markup.EOL);
            sb.append("      ...").append(Markup.EOL);
            sb.append("    </plugins>").append(Markup.EOL);
            sb.append("  </build>").append(Markup.EOL);
            if (hasMavenReport) {
                sb.append("  ...").append(Markup.EOL);
                sb.append("  <!-- " + this.getI18nString("usage.reporting") + " -->").append(Markup.EOL);
                sb.append("  <reporting>").append(Markup.EOL);
                sb.append("    <plugins>").append(Markup.EOL);
                sb.append("      <plugin>").append(Markup.EOL);
                sb.append("        <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append(Markup.EOL);
                sb.append("        <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append(Markup.EOL);
                sb.append("        <version>").append(this.pluginDescriptor.getVersion()).append("</version>").append(Markup.EOL);
                sb.append("      </plugin>").append(Markup.EOL);
                sb.append("      ...").append(Markup.EOL);
                sb.append("    </plugins>").append(Markup.EOL);
                sb.append("  </reporting>").append(Markup.EOL);
            }
            sb.append("  ...").append(Markup.EOL);
            sb.append("</project>");
            this.verbatimText(sb.toString());
            this.sink.paragraph();
            this.linkPatternedText(this.getI18nString("configuration.end"));
            this.sink.paragraph_();
            this.endSection();
        }

        private static String discoverMavenRequirement(MavenProject project, PluginDescriptor pluginDescriptor) {
            if (StringUtils.isNotBlank((String)pluginDescriptor.getRequiredMavenVersion())) {
                return pluginDescriptor.getRequiredMavenVersion();
            }
            return Optional.ofNullable(project.getPrerequisites()).map(Prerequisites::getMaven).orElse(null);
        }

        private static String discoverJdkRequirement(MavenProject project, PluginDescriptor pluginDescriptor) {
            String version;
            String jdk = null;
            if (pluginDescriptor instanceof ExtendedPluginDescriptor) {
                ExtendedPluginDescriptor extPluginDescriptor = (ExtendedPluginDescriptor)pluginDescriptor;
                jdk = extPluginDescriptor.getRequiredJavaVersion();
            }
            if (jdk != null) {
                return jdk;
            }
            Plugin compiler = PluginOverviewRenderer.getCompilerPlugin(project.getBuild().getPluginsAsMap());
            if (compiler == null) {
                compiler = PluginOverviewRenderer.getCompilerPlugin(project.getPluginManagement().getPluginsAsMap());
            }
            if ((jdk = PluginOverviewRenderer.getPluginParameter(compiler, "release")) != null) {
                return jdk;
            }
            jdk = project.getProperties().getProperty("maven.compiler.release");
            if (jdk != null) {
                return jdk;
            }
            jdk = PluginOverviewRenderer.getPluginParameter(compiler, "target");
            if (jdk != null) {
                return jdk;
            }
            jdk = project.getProperties().getProperty("maven.compiler.target");
            if (jdk != null) {
                return jdk;
            }
            String string = version = compiler == null ? null : compiler.getVersion();
            if (version != null) {
                return "Default target for maven-compiler-plugin version " + version;
            }
            return null;
        }

        private static Plugin getCompilerPlugin(Map<String, Plugin> pluginsAsMap) {
            return pluginsAsMap.get("org.apache.maven.plugins:maven-compiler-plugin");
        }

        private static String getPluginParameter(Plugin plugin, String parameter) {
            Xpp3Dom target;
            Xpp3Dom pluginConf;
            if (plugin != null && (pluginConf = (Xpp3Dom)plugin.getConfiguration()) != null && (target = pluginConf.getChild(parameter)) != null) {
                return target.getValue();
            }
            return null;
        }
    }
}

