/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin.report;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.ExtendedPluginDescriptor;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class RequirementsHistory {
    private String version;
    private String maven;
    private String jdk;

    public String getVersion() {
        return this.version;
    }

    public String getMaven() {
        return this.maven;
    }

    public String getJdk() {
        return this.jdk;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RequirementsHistory{");
        sb.append("version='").append(this.version).append('\'');
        sb.append(", maven='").append(this.maven).append('\'');
        sb.append(", jdk='").append(this.jdk).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static RequirementsHistory discoverRequirements(MavenProject project) {
        RequirementsHistory req = new RequirementsHistory();
        req.version = project.getVersion();
        req.jdk = RequirementsHistory.discoverJdkRequirement(project, null);
        req.maven = RequirementsHistory.discoverMavenRequirement(project, null);
        return req;
    }

    public static String discoverMavenRequirement(MavenProject project, PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor != null && StringUtils.isNotBlank((CharSequence)pluginDescriptor.getRequiredMavenVersion())) {
            return pluginDescriptor.getRequiredMavenVersion();
        }
        return Optional.ofNullable(project.getPrerequisites()).map(Prerequisites::getMaven).orElse(null);
    }

    public static String discoverJdkRequirement(MavenProject project, PluginDescriptor pluginDescriptor) {
        String jdk = null;
        if (pluginDescriptor instanceof ExtendedPluginDescriptor) {
            ExtendedPluginDescriptor extPluginDescriptor = (ExtendedPluginDescriptor)pluginDescriptor;
            jdk = extPluginDescriptor.getRequiredJavaVersion();
        }
        if (jdk != null) {
            return jdk;
        }
        Plugin compiler = RequirementsHistory.getCompilerPlugin(project.getBuild().getPluginsAsMap());
        if (compiler == null) {
            compiler = RequirementsHistory.getCompilerPlugin(project.getPluginManagement().getPluginsAsMap());
        }
        if ((jdk = RequirementsHistory.getPluginParameter(compiler, "release")) == null) {
            jdk = project.getProperties().getProperty("maven.compiler.release");
        }
        if (jdk == null) {
            jdk = RequirementsHistory.getPluginParameter(compiler, "target");
        }
        if (jdk == null) {
            jdk = project.getProperties().getProperty("maven.compiler.target");
        }
        if (jdk == null) {
            String version;
            String string = version = compiler == null ? null : compiler.getVersion();
            if (version != null) {
                return "Default target for maven-compiler-plugin version " + version;
            }
        } else if (Arrays.asList("1.5", "1.6", "1.7", "1.8").contains(jdk)) {
            jdk = jdk.substring(2);
        }
        return jdk;
    }

    private static Plugin getCompilerPlugin(Map<String, Plugin> pluginsAsMap) {
        return pluginsAsMap.get("org.apache.maven.plugins:maven-compiler-plugin");
    }

    private static String getPluginParameter(Plugin plugin, String parameter) {
        Xpp3Dom target;
        Xpp3Dom pluginConf;
        if (plugin != null && (pluginConf = (Xpp3Dom)plugin.getConfiguration()) != null && (target = pluginConf.getChild(parameter)) != null) {
            return target.getValue();
        }
        return null;
    }

    public boolean hasSameRequirements(RequirementsHistory other) {
        return Objects.equals(this.maven, other.getMaven()) && Objects.equals(this.jdk, other.getJdk());
    }
}

