/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin.report;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.plugin.report.GoalRenderer;
import org.apache.maven.plugin.plugin.report.PluginOverviewRenderer;
import org.apache.maven.plugin.plugin.report.RequirementsHistory;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.plugin.descriptor.EnhancedPluginDescriptorBuilder;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.xml.XmlStreamReader;

@Mojo(name="report", threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class PluginReport
extends AbstractMavenReport {
    @Parameter(defaultValue="false", property="maven.plugin.report.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="maven.plugin.report.hasExtensionsToLoad")
    private boolean hasExtensionsToLoad;
    @Parameter
    private List<RequirementsHistory> requirementsHistories = new ArrayList<RequirementsHistory>();
    @Component
    private RuntimeInformation rtInfo;
    @Component
    private I18N i18n;
    @Parameter(defaultValue="${project.build.directory}/plugin-enhanced.xml", required=true, readonly=true)
    private File enhancedPluginXmlFile;
    @Parameter(property="maven.plugin.report.disableInternalJavadocLinkValidation")
    private boolean disableInternalJavadocLinkValidation;

    public boolean canGenerateReport() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Maven Plugin Plugin Report generation skipped.");
            return false;
        }
        return this.enhancedPluginXmlFile != null && this.enhancedPluginXmlFile.isFile() && this.enhancedPluginXmlFile.canRead();
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        PluginDescriptor pluginDescriptor = this.extractPluginDescriptor();
        this.generateMojosDocumentation(pluginDescriptor, locale);
        PluginOverviewRenderer r = new PluginOverviewRenderer(this.getSink(), this.i18n, locale, this.getProject(), this.requirementsHistories, pluginDescriptor, this.hasExtensionsToLoad);
        r.render();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginDescriptor extractPluginDescriptor() throws MavenReportException {
        EnhancedPluginDescriptorBuilder builder = new EnhancedPluginDescriptorBuilder(this.rtInfo);
        try (XmlStreamReader input = new XmlStreamReader(Files.newInputStream(this.enhancedPluginXmlFile.toPath(), new OpenOption[0]));){
            PluginDescriptor pluginDescriptor = builder.build((Reader)input);
            return pluginDescriptor;
        }
        catch (IOException | PlexusConfigurationException e) {
            throw new MavenReportException("Error extracting plugin descriptor from " + this.enhancedPluginXmlFile, (Exception)e);
        }
    }

    private String getI18nString(Locale locale, String key) {
        return this.i18n.getString("plugin-report", locale, "report.plugin." + key);
    }

    public String getName(Locale locale) {
        return this.getI18nString(locale, "name");
    }

    public String getDescription(Locale locale) {
        return this.getI18nString(locale, "description");
    }

    public String getOutputName() {
        return "plugin-info";
    }

    private void generateMojosDocumentation(PluginDescriptor pluginDescriptor, Locale locale) throws MavenReportException {
        if (pluginDescriptor.getMojos() != null) {
            for (MojoDescriptor descriptor : pluginDescriptor.getMojos()) {
                GoalRenderer renderer;
                try {
                    String filename = descriptor.getGoal() + "-mojo.html";
                    Sink sink = this.getSinkFactory().createSink(this.getReportOutputDirectory(), filename);
                    renderer = new GoalRenderer(sink, this.i18n, locale, this.project, descriptor, this.getReportOutputDirectory(), this.disableInternalJavadocLinkValidation, this.getLog());
                }
                catch (IOException e) {
                    throw new MavenReportException("Cannot generate sink for mojo " + descriptor.getGoal(), (Exception)e);
                }
                renderer.render();
            }
        }
    }
}

