/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin.report;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.util.HtmlTools;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.plugin.report.AbstractPluginReportRenderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.EnhancedParameterWrapper;
import org.apache.maven.tools.plugin.ExtendedMojoDescriptor;
import org.apache.maven.tools.plugin.javadoc.JavadocLinkGenerator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.i18n.I18N;

public class GoalRenderer
extends AbstractPluginReportRenderer {
    private static final Pattern HTML_LINK_PATTERN = Pattern.compile("<a href=\\\"([^\\\"]*)\\\">(.*?)</a>");
    private final File reportOutputDirectory;
    private final MojoDescriptor descriptor;
    private final boolean disableInternalJavadocLinkValidation;
    private final Log log;

    public GoalRenderer(Sink sink, I18N i18n, Locale locale, MavenProject project, MojoDescriptor descriptor, File reportOutputDirectory, boolean disableInternalJavadocLinkValidation, Log log) {
        super(sink, locale, i18n, project);
        this.reportOutputDirectory = reportOutputDirectory;
        this.descriptor = descriptor;
        this.disableInternalJavadocLinkValidation = disableInternalJavadocLinkValidation;
        this.log = log;
    }

    @Override
    public String getTitle() {
        return this.descriptor.getFullGoalName();
    }

    protected void renderBody() {
        this.startSection(this.descriptor.getFullGoalName());
        this.renderReportNotice();
        this.renderDescription("fullname", this.descriptor.getPluginDescriptor().getId() + ":" + this.descriptor.getGoal(), false);
        String context = "goal " + this.descriptor.getGoal();
        if (StringUtils.isNotEmpty((CharSequence)this.descriptor.getDeprecated())) {
            this.renderDescription("deprecated", this.getXhtmlWithValidatedLinks(this.descriptor.getDeprecated(), context), true);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.descriptor.getDescription())) {
            this.renderDescription("description", this.getXhtmlWithValidatedLinks(this.descriptor.getDescription(), context), true);
        } else {
            this.renderDescription("description", this.getI18nString("nodescription"), false);
        }
        this.renderAttributes();
        List<Parameter> parameterList = GoalRenderer.filterParameters(this.descriptor.getParameters() != null ? this.descriptor.getParameters() : Collections.emptyList());
        if (parameterList.isEmpty()) {
            this.startSection(this.getI18nString("parameters"));
            this.sink.paragraph();
            this.sink.text(this.getI18nString("noParameter"));
            this.sink.paragraph_();
            this.endSection();
        } else {
            this.renderParameterOverviewTable(this.getI18nString("requiredParameters"), parameterList.stream().filter(Parameter::isRequired).iterator());
            this.renderParameterOverviewTable(this.getI18nString("optionalParameters"), parameterList.stream().filter(p -> !p.isRequired()).iterator());
            this.renderParameterDetails(parameterList.iterator());
        }
        this.endSection();
    }

    private static List<Parameter> filterParameters(Collection<Parameter> parameterList) {
        return parameterList.stream().filter(p -> p.isEditable() && (p.getExpression() == null || !p.getExpression().startsWith("${component."))).collect(Collectors.toList());
    }

    private void renderReportNotice() {
        if (PluginUtils.isMavenReport((String)this.descriptor.getImplementation(), (MavenProject)this.project)) {
            this.renderDescription("notice.prefix", this.getI18nString("notice.isMavenReport"), false);
        }
    }

    private void renderDescription(String prefixKey, String description, boolean isHtmlMarkup) {
        this.renderDescriptionPrefix(prefixKey);
        this.sink.paragraph();
        if (isHtmlMarkup) {
            this.sink.rawText(description);
        } else {
            this.sink.text(description);
        }
        this.sink.paragraph_();
    }

    private void renderDescriptionPrefix(String prefixKey) {
        this.sink.paragraph();
        this.sink.inline(SinkEventAttributeSet.Semantics.STRONG);
        this.sink.text(this.getI18nString(prefixKey));
        this.sink.inline_();
        this.sink.text(":");
        this.sink.paragraph_();
    }

    private void renderAttributes() {
        this.renderDescriptionPrefix("attributes");
        this.sink.list();
        this.renderAttribute(this.descriptor.isProjectRequired(), "projectRequired");
        this.renderAttribute(this.descriptor.isRequiresReports(), "reportingMojo");
        this.renderAttribute(this.descriptor.isAggregator(), "aggregator");
        this.renderAttribute(this.descriptor.isDirectInvocationOnly(), "directInvocationOnly");
        this.renderAttribute(this.descriptor.isDependencyResolutionRequired(), "dependencyResolutionRequired");
        if (this.descriptor instanceof ExtendedMojoDescriptor) {
            ExtendedMojoDescriptor extendedDescriptor = (ExtendedMojoDescriptor)this.descriptor;
            this.renderAttribute(extendedDescriptor.getDependencyCollectionRequired(), "dependencyCollectionRequired");
        }
        this.renderAttribute(this.descriptor.isThreadSafe(), "threadSafe");
        this.renderAttribute(!this.descriptor.isThreadSafe(), "notThreadSafe");
        this.renderAttribute(this.descriptor.getSince(), "since");
        this.renderAttribute(this.descriptor.getPhase(), "phase");
        this.renderAttribute(this.descriptor.getExecutePhase(), "executePhase");
        this.renderAttribute(this.descriptor.getExecuteGoal(), "executeGoal");
        this.renderAttribute(this.descriptor.getExecuteLifecycle(), "executeLifecycle");
        this.renderAttribute(this.descriptor.isOnlineRequired(), "onlineRequired");
        this.renderAttribute(!this.descriptor.isInheritedByDefault(), "notInheritedByDefault");
        this.sink.list_();
    }

    private void renderAttribute(boolean condition, String attributeKey) {
        this.renderAttribute(condition, attributeKey, Optional.empty());
    }

    private void renderAttribute(String conditionAndCodeArgument, String attributeKey) {
        this.renderAttribute(StringUtils.isNotEmpty((CharSequence)conditionAndCodeArgument), attributeKey, Optional.ofNullable(conditionAndCodeArgument));
    }

    private void renderAttribute(boolean condition, String attributeKey, Optional<String> codeArgument) {
        if (condition) {
            this.sink.listItem();
            this.linkPatternedText(this.getI18nString(attributeKey));
            if (codeArgument.isPresent()) {
                this.text(": ");
                this.sink.inline(SinkEventAttributeSet.Semantics.CODE);
                this.sink.text(codeArgument.get());
                this.sink.inline_();
            }
            this.text(".");
            this.sink.listItem_();
        }
    }

    private void renderParameterOverviewTable(String title, Iterator<Parameter> parameters) {
        if (!parameters.hasNext()) {
            return;
        }
        this.startSection(title);
        this.startTable();
        this.tableHeader(new String[]{this.getI18nString("parameter.name.header"), this.getI18nString("parameter.type.header"), this.getI18nString("parameter.since.header"), this.getI18nString("parameter.description.header")});
        while (parameters.hasNext()) {
            this.renderParameterOverviewTableRow(parameters.next());
        }
        this.endTable();
        this.endSection();
    }

    private void renderTableCellWithCode(String text) {
        this.renderTableCellWithCode(text, Optional.empty());
    }

    private void renderTableCellWithCode(String text, Optional<String> link) {
        this.sink.tableCell();
        if (link.isPresent()) {
            this.sink.link(link.get(), null);
        }
        this.sink.inline(SinkEventAttributeSet.Semantics.CODE);
        this.sink.text(text);
        this.sink.inline_();
        if (link.isPresent()) {
            this.sink.link_();
        }
        this.sink.tableCell_();
    }

    private void renderParameterOverviewTableRow(Parameter parameter) {
        String description;
        this.sink.tableRow();
        this.renderTableCellWithCode(this.format("parameter.name", parameter.getName()), Optional.of("#" + HtmlTools.encodeId((String)parameter.getName())));
        Map.Entry<String, Optional<String>> type = this.getLinkedType(parameter, true);
        this.renderTableCellWithCode(type.getKey(), type.getValue());
        String since = (String)StringUtils.defaultIfEmpty((CharSequence)parameter.getSince(), (CharSequence)"-");
        this.renderTableCellWithCode(since);
        this.sink.tableCell();
        String context = "Parameter " + parameter.getName() + " in goal " + this.descriptor.getGoal();
        if (StringUtils.isNotEmpty((CharSequence)parameter.getDeprecated())) {
            String deprecated = this.getXhtmlWithValidatedLinks(parameter.getDescription(), context);
            description = this.format("parameter.deprecated", deprecated);
        } else {
            description = StringUtils.isNotEmpty((CharSequence)parameter.getDescription()) ? this.getXhtmlWithValidatedLinks(parameter.getDescription(), context) : this.getI18nString("nodescription");
        }
        this.sink.rawText(description);
        this.renderTableCellDetail("parameter.defaultValue", parameter.getDefaultValue());
        this.renderTableCellDetail("parameter.property", GoalRenderer.getPropertyFromExpression(parameter.getExpression()));
        this.renderTableCellDetail("parameter.alias", parameter.getAlias());
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    private void renderParameterDetails(Iterator<Parameter> parameters) {
        this.startSection(this.getI18nString("parameter.details"));
        while (parameters.hasNext()) {
            Parameter parameter = parameters.next();
            this.sink.anchor(parameter.getName());
            this.startSection(this.format("parameter.name", parameter.getName()));
            this.sink.anchor_();
            String context = "Parameter " + parameter.getName() + " in goal " + this.descriptor.getGoal();
            if (StringUtils.isNotEmpty((CharSequence)parameter.getDeprecated())) {
                this.sink.division();
                String deprecated = this.getXhtmlWithValidatedLinks(parameter.getDeprecated(), context);
                this.sink.rawText(this.format("parameter.deprecated", deprecated));
                this.sink.division_();
            }
            this.sink.division();
            if (StringUtils.isNotEmpty((CharSequence)parameter.getDescription())) {
                this.sink.rawText(this.getXhtmlWithValidatedLinks(parameter.getDescription(), context));
            } else {
                this.sink.text(this.getI18nString("nodescription"));
            }
            this.sink.division_();
            this.sink.list();
            Map.Entry<String, Optional<String>> typeAndLink = this.getLinkedType(parameter, false);
            this.renderDetail(this.getI18nString("parameter.type"), typeAndLink.getKey(), typeAndLink.getValue());
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSince())) {
                this.renderDetail(this.getI18nString("parameter.since"), parameter.getSince());
            }
            if (parameter.isRequired()) {
                this.renderDetail(this.getI18nString("parameter.required"), this.getI18nString("yes"));
            } else {
                this.renderDetail(this.getI18nString("parameter.required"), this.getI18nString("no"));
            }
            String expression = parameter.getExpression();
            String property = GoalRenderer.getPropertyFromExpression(expression);
            if (property == null) {
                this.renderDetail(this.getI18nString("parameter.expression"), expression);
            } else {
                this.renderDetail(this.getI18nString("parameter.property"), property);
            }
            this.renderDetail(this.getI18nString("parameter.defaultValue"), parameter.getDefaultValue());
            this.renderDetail(this.getI18nString("parameter.alias"), parameter.getAlias());
            this.sink.list_();
            if (parameters.hasNext()) {
                this.sink.horizontalRule();
            }
            this.endSection();
        }
        this.endSection();
    }

    private void renderTableCellDetail(String nameKey, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.sink.lineBreak();
            this.sink.inline(SinkEventAttributeSet.Semantics.STRONG);
            this.sink.text(this.getI18nString(nameKey));
            this.sink.inline_();
            this.sink.text(": ");
            this.sink.inline(SinkEventAttributeSet.Semantics.CODE);
            this.sink.text(value);
            this.sink.inline_();
        }
    }

    private void renderDetail(String param, String value) {
        this.renderDetail(param, value, Optional.empty());
    }

    private void renderDetail(String param, String value, Optional<String> valueLink) {
        if (value != null && !value.isEmpty()) {
            this.sink.listItem();
            this.sink.inline(SinkEventAttributeSet.Semantics.STRONG);
            this.sink.text(param);
            this.sink.inline_();
            this.sink.text(": ");
            if (valueLink.isPresent()) {
                this.sink.link(valueLink.get());
            }
            this.sink.inline(SinkEventAttributeSet.Semantics.CODE);
            this.sink.text(value);
            this.sink.inline_();
            if (valueLink.isPresent()) {
                this.sink.link_();
            }
            this.sink.listItem_();
        }
    }

    private static String getPropertyFromExpression(String expression) {
        if (expression != null && !expression.isEmpty() && expression.startsWith("${") && expression.endsWith("}") && !expression.substring(2).contains("${")) {
            return expression.substring(2, expression.length() - 1);
        }
        return null;
    }

    static String getShortType(String type) {
        int startTypeArguments = type.indexOf(60);
        if (startTypeArguments == -1) {
            return GoalRenderer.getShortTypeOfSimpleType(type);
        }
        StringBuilder shortType = new StringBuilder();
        shortType.append(GoalRenderer.getShortTypeOfSimpleType(type.substring(0, startTypeArguments)));
        shortType.append("<").append(GoalRenderer.getShortTypeOfTypeArgument(type.substring(startTypeArguments + 1, type.lastIndexOf(">")))).append(">");
        return shortType.toString();
    }

    private static String getShortTypeOfTypeArgument(String type) {
        String[] typeArguments = type.split(",\\s*");
        StringBuilder shortType = new StringBuilder();
        for (int i = 0; i < typeArguments.length; ++i) {
            String typeArgument = typeArguments[i];
            if (typeArgument.contains("<")) {
                return "...";
            }
            shortType.append(GoalRenderer.getShortTypeOfSimpleType(typeArgument));
            if (i >= typeArguments.length - 1) continue;
            shortType.append(",");
        }
        return shortType.toString();
    }

    private static String getShortTypeOfSimpleType(String type) {
        int index = type.lastIndexOf(46);
        return type.substring(index + 1);
    }

    private Map.Entry<String, Optional<String>> getLinkedType(Parameter parameter, boolean isShortType) {
        URI javadocUrl;
        EnhancedParameterWrapper enhancedParameter;
        String typeValue = isShortType ? GoalRenderer.getShortType(parameter.getType()) : parameter.getType();
        URI uri = null;
        if (parameter instanceof EnhancedParameterWrapper && (enhancedParameter = (EnhancedParameterWrapper)parameter).getTypeJavadocUrl() != null && ((javadocUrl = enhancedParameter.getTypeJavadocUrl()).isAbsolute() || this.disableInternalJavadocLinkValidation || JavadocLinkGenerator.isLinkValid((URI)javadocUrl, (Path)this.reportOutputDirectory.toPath()))) {
            uri = enhancedParameter.getTypeJavadocUrl();
        }
        return new AbstractMap.SimpleEntry<String, Optional<String>>(typeValue, Optional.ofNullable(uri).map(URI::toASCIIString));
    }

    String getXhtmlWithValidatedLinks(String xhtmlText, String context) {
        if (this.disableInternalJavadocLinkValidation) {
            return xhtmlText;
        }
        StringBuffer sanitizedXhtmlText = new StringBuffer();
        Matcher matcher = HTML_LINK_PATTERN.matcher(xhtmlText);
        while (matcher.find()) {
            try {
                URI link = new URI(matcher.group(1));
                if (!link.isAbsolute() && !JavadocLinkGenerator.isLinkValid((URI)link, (Path)this.reportOutputDirectory.toPath())) {
                    matcher.appendReplacement(sanitizedXhtmlText, matcher.group(2));
                    this.log.debug((CharSequence)String.format("Removed invalid link %s in %s", link, context));
                    continue;
                }
                matcher.appendReplacement(sanitizedXhtmlText, matcher.group(0));
            }
            catch (URISyntaxException e) {
                this.log.warn((CharSequence)String.format("Invalid URI %s found in %s. Cannot validate, leave untouched", matcher.group(1), context));
                matcher.appendReplacement(sanitizedXhtmlText, matcher.group(0));
            }
        }
        matcher.appendTail(sanitizedXhtmlText);
        return sanitizedXhtmlText.toString();
    }

    private String format(String key, Object arg1) {
        return this.format(key, new Object[]{arg1});
    }

    private String format(String key, Object[] args) {
        String pattern = this.getI18nString(key);
        pattern = StringUtils.replace((String)pattern, (String)"'", (String)"''");
        MessageFormat messageFormat = new MessageFormat(pattern, this.locale);
        return messageFormat.format(args);
    }

    @Override
    protected String getI18nSection() {
        return "plugin.goal";
    }
}

