/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.generator.PluginXdocGenerator;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.StringUtils;

public class PluginReport
extends AbstractMavenReport {
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    protected MojoScanner mojoScanner;
    static /* synthetic */ Class class$org$apache$maven$plugin$plugin$PluginReport;

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (!this.project.getPackaging().equals("maven-plugin")) {
            return;
        }
        String goalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(goalPrefix);
        try {
            pluginDescriptor.setDependencies(PluginUtils.toComponentDependencies((List)this.project.getRuntimeDependencies()));
            this.mojoScanner.populatePluginDescriptor(this.project, pluginDescriptor);
            this.generatePluginDocumentation(pluginDescriptor);
            PluginOverviewRenderer r = new PluginOverviewRenderer(this.getSink(), pluginDescriptor, locale);
            r.render();
        }
        catch (InvalidPluginDescriptorException e) {
            throw new MavenReportException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
        catch (ExtractionException e) {
            throw new MavenReportException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
    }

    public String getDescription(Locale locale) {
        return PluginReport.getBundle(locale).getString("report.plugin.description");
    }

    public String getName(Locale locale) {
        return PluginReport.getBundle(locale).getString("report.plugin.name");
    }

    public String getOutputName() {
        return "plugin-info";
    }

    private void generatePluginDocumentation(PluginDescriptor pluginDescriptor) throws MavenReportException {
        try {
            File outputDir = new File(this.getOutputDirectory());
            outputDir.mkdirs();
            PluginXdocGenerator generator = new PluginXdocGenerator();
            generator.execute(outputDir, pluginDescriptor);
        }
        catch (IOException e) {
            throw new MavenReportException("Error writing plugin documentation", (Exception)e);
        }
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("plugin-report", locale, (class$org$apache$maven$plugin$plugin$PluginReport == null ? (class$org$apache$maven$plugin$plugin$PluginReport = PluginReport.class$("org.apache.maven.plugin.plugin.PluginReport")) : class$org$apache$maven$plugin$plugin$PluginReport).getClassLoader());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class PluginOverviewRenderer
    extends AbstractMavenReportRenderer {
        private final PluginDescriptor pluginDescriptor;
        private final Locale locale;

        public PluginOverviewRenderer(Sink sink, PluginDescriptor pluginDescriptor, Locale locale) {
            super(sink);
            this.pluginDescriptor = pluginDescriptor;
            this.locale = locale;
        }

        public String getTitle() {
            return PluginReport.getBundle(this.locale).getString("report.plugin.title");
        }

        public void renderBody() {
            this.startSection(this.getTitle());
            this.paragraph(PluginReport.getBundle(this.locale).getString("report.plugin.goals.intro"));
            this.startTable();
            String goalColumnName = PluginReport.getBundle(this.locale).getString("report.plugin.goals.column.goal");
            String descriptionColumnName = PluginReport.getBundle(this.locale).getString("report.plugin.goals.column.description");
            this.tableHeader(new String[]{goalColumnName, descriptionColumnName});
            Iterator i = this.pluginDescriptor.getMojos().iterator();
            while (i.hasNext()) {
                MojoDescriptor mojo = (MojoDescriptor)i.next();
                String goalName = mojo.getFullGoalName();
                String goalDocumentationLink = "./" + mojo.getGoal() + "-mojo.html";
                String description = mojo.getDescription();
                if (StringUtils.isEmpty((String)mojo.getDescription())) {
                    description = PluginReport.getBundle(this.locale).getString("report.plugin.goal.nodescription");
                }
                this.sink.tableRow();
                this.tableCell(AbstractMavenReportRenderer.createLinkPatternedText((String)goalName, (String)goalDocumentationLink));
                this.tableCell(description, true);
                this.sink.tableRow_();
            }
            this.endTable();
            this.endSection();
        }
    }
}

