/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pdf;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.docrenderer.AbstractDocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRendererContext;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.pdf.PdfRenderer;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Writer;
import org.apache.maven.doxia.index.IndexEntry;
import org.apache.maven.doxia.index.IndexingSink;
import org.apache.maven.doxia.module.xdoc.XdocSink;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.sink.impl.SinkAdapter;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.pdf.AbstractPdfMojo;
import org.apache.maven.plugins.pdf.DocumentDescriptorReader;
import org.apache.maven.plugins.pdf.DocumentModelBuilder;
import org.apache.maven.plugins.pdf.TocFileHelper;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.apache.maven.reporting.exec.MavenReportExecutor;
import org.apache.maven.reporting.exec.MavenReportExecutorRequest;
import org.apache.maven.settings.Settings;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="pdf", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class PdfMojo
extends AbstractPdfMojo
implements Contextualizable {
    private static final String EOL = System.getProperty("line.separator");
    @Component(hint="fo")
    private PdfRenderer foRenderer;
    @Component
    private I18N i18n;
    @Component(hint="itext")
    private PdfRenderer itextRenderer;
    @Parameter(property="locales")
    private String locales;
    @Component
    private Renderer siteRenderer;
    @Component
    private SiteTool siteTool;
    @Component
    private Doxia doxia;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${basedir}/src/site", required=true)
    private File siteDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-site", required=true)
    private File generatedSiteDirectory;
    @Parameter(defaultValue="${project.build.directory}/pdf", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/pdf", required=true)
    private File workingDirectory;
    @Parameter(defaultValue="src/site/pdf.xml")
    private File docDescriptor;
    @Parameter(property="implementation", defaultValue="fo", required=true)
    private String implementation;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="aggregate", defaultValue="true")
    private boolean aggregate;
    @Parameter(defaultValue="${plugin.version}", readonly=true)
    private String pluginVersion;
    @Parameter(property="includeReports", defaultValue="true")
    private boolean includeReports;
    @Parameter(property="generateTOC", defaultValue="start")
    private String generateTOC;
    @Parameter(property="validate", defaultValue="false")
    private boolean validate;
    @Parameter(defaultValue="${reports}", required=true, readonly=true)
    private MavenReport[] reports;
    @Parameter(defaultValue="${project.reporting}", readonly=true)
    private Reporting reporting;
    private DocumentRenderer docRenderer;
    private Locale defaultLocale;
    private List<Locale> localesList;
    private DecorationModel defaultDecorationModel;
    private File generatedSiteDirectoryTmp;
    private Map<Locale, List<MavenReport>> generatedMavenReports;
    private PlexusContainer container;

    public void execute() throws MojoExecutionException {
        this.init();
        try {
            this.generatePdf();
        }
        catch (IOException e) {
            this.debugLogGeneratedModel(this.getDocumentModel(Locale.ENGLISH));
            throw new MojoExecutionException("Error during document generation: " + e.getMessage(), (Exception)e);
        }
        try {
            this.copyGeneratedPdf();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying generated PDF: " + e.getMessage(), (Exception)e);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    protected boolean isIncludeReports() {
        return this.includeReports;
    }

    private void init() {
        if ("fo".equalsIgnoreCase(this.implementation)) {
            this.docRenderer = this.foRenderer;
        } else if ("itext".equalsIgnoreCase(this.implementation)) {
            this.docRenderer = this.itextRenderer;
        } else {
            this.getLog().warn((CharSequence)("Invalid 'implementation' parameter: '" + this.implementation + "', using 'fo' as default."));
            this.docRenderer = this.foRenderer;
        }
        if (!("none".equalsIgnoreCase(this.generateTOC) || "start".equalsIgnoreCase(this.generateTOC) || "end".equalsIgnoreCase(this.generateTOC))) {
            this.getLog().warn((CharSequence)("Invalid 'generateTOC' parameter: '" + this.generateTOC + "', using 'start' as default."));
            this.generateTOC = "start";
        }
    }

    private void copyGeneratedPdf() throws MojoExecutionException, IOException {
        boolean requireCopy = !this.getOutputDirectory().getCanonicalPath().equals(this.getWorkingDirectory().getCanonicalPath());
        String outputName = this.getDocumentModel(this.getDefaultLocale()).getOutputName().trim();
        if (!outputName.endsWith(".pdf")) {
            outputName = outputName.concat(".pdf");
        }
        for (Locale locale : this.getAvailableLocales()) {
            File generatedPdfSource = new File(this.getLocaleDirectory(this.getWorkingDirectory(), locale), outputName);
            if (!generatedPdfSource.exists()) {
                this.getLog().warn((CharSequence)("Unable to find the generated pdf: " + generatedPdfSource.getAbsolutePath()));
                continue;
            }
            File generatedPdfDest = new File(this.getLocaleDirectory(this.getOutputDirectory(), locale), outputName);
            if (requireCopy) {
                FileUtils.copyFile((File)generatedPdfSource, (File)generatedPdfDest);
                generatedPdfSource.delete();
            }
            this.getLog().info((CharSequence)("pdf generated: " + generatedPdfDest));
        }
    }

    private void generatePdf() throws MojoExecutionException, IOException {
        Locale.setDefault(this.getDefaultLocale());
        for (Locale locale : this.getAvailableLocales()) {
            File workingDir = this.getLocaleDirectory(this.getWorkingDirectory(), locale);
            File siteDirectoryFile = this.getLocaleDirectory(this.getSiteDirectoryTmp(), locale);
            this.copyResources(locale);
            this.generateMavenReports(locale);
            DocumentRendererContext context = new DocumentRendererContext();
            context.put("project", (Object)this.project);
            context.put("settings", (Object)this.settings);
            context.put("PathTool", (Object)new PathTool());
            context.put("FileUtils", (Object)new FileUtils());
            context.put("StringUtils", (Object)new StringUtils());
            context.put("i18n", (Object)this.i18n);
            context.put("generateTOC", (Object)this.generateTOC);
            context.put("validate", (Object)this.validate);
            for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
                context.put((String)entry.getKey(), entry.getValue());
            }
            DocumentModel model = this.aggregate ? this.getDocumentModel(locale) : null;
            try {
                ((AbstractDocumentRenderer)this.docRenderer).render(siteDirectoryFile, workingDir, model, context);
            }
            catch (DocumentRendererException e) {
                throw new MojoExecutionException("Error during document generation: " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private File getGeneratedSiteDirectoryTmp() {
        if (this.generatedSiteDirectoryTmp == null) {
            this.generatedSiteDirectoryTmp = new File(this.getWorkingDirectory(), "generated-site.tmp");
        }
        return this.generatedSiteDirectoryTmp;
    }

    @Override
    protected void prepareTempSiteDirectory(File tmpSiteDir) throws IOException {
        tmpSiteDir.mkdirs();
        if (this.siteDirectory.exists()) {
            FileUtils.copyDirectoryStructure((File)this.siteDirectory, (File)tmpSiteDir);
        }
        List files = FileUtils.getFileAndDirectoryNames((File)tmpSiteDir, (String)FileUtils.getDefaultExcludesAsString(), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        for (String fileName : files) {
            File file = new File(fileName);
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
                continue;
            }
            file.delete();
        }
        this.copySiteDir(this.generatedSiteDirectory, tmpSiteDir);
    }

    private void copySiteDir(File from, File to) throws IOException {
        if (from == null || !from.exists()) {
            return;
        }
        for (Locale locale : this.getAvailableLocales()) {
            String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
            List siteFiles = this.siteDirectory.exists() ? FileUtils.getFileNames((File)this.siteDirectory, (String)"**/*", (String)excludes, (boolean)false) : new ArrayList();
            File siteDirectoryLocale = new File(this.siteDirectory, locale.getLanguage());
            if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage()) && siteDirectoryLocale.exists()) {
                siteFiles = FileUtils.getFileNames((File)siteDirectoryLocale, (String)"**/*", (String)excludes, (boolean)false);
            }
            List generatedSiteFiles = FileUtils.getFileNames((File)from, (String)"**/*", (String)excludes, (boolean)false);
            File fromLocale = new File(from, locale.getLanguage());
            if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage()) && fromLocale.exists()) {
                generatedSiteFiles = FileUtils.getFileNames((File)fromLocale, (String)"**/*", (String)excludes, (boolean)false);
            }
            for (String generatedSiteFile : generatedSiteFiles) {
                File out;
                File in;
                if (siteFiles.contains(generatedSiteFile)) {
                    this.getLog().warn((CharSequence)("Generated-site already contains a file in site: " + generatedSiteFile + ". Ignoring copying it!"));
                    continue;
                }
                if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
                    if (!fromLocale.exists()) continue;
                    in = new File(fromLocale, generatedSiteFile);
                    out = new File(new File(to, locale.getLanguage()), generatedSiteFile);
                    out.getParentFile().mkdirs();
                    FileUtils.copyFile((File)in, (File)out);
                    continue;
                }
                in = new File(from, generatedSiteFile);
                out = new File(to, generatedSiteFile);
                out.getParentFile().mkdirs();
                FileUtils.copyFile((File)in, (File)out);
            }
        }
    }

    private DocumentModel getDocumentModel(Locale locale) throws MojoExecutionException {
        if (this.docDescriptor.exists()) {
            DocumentModel doc = this.getDocumentModelFromDescriptor(locale);
            this.appendGeneratedReports(doc, locale);
            this.saveTOC(doc.getToc(), locale);
            return doc;
        }
        DocumentModel model = new DocumentModelBuilder(this.project, this.getDefaultDecorationModel()).getDocumentModel();
        model.getMeta().setGenerator(this.getDefaultGenerator());
        model.getMeta().setLanguage(locale.getLanguage());
        model.getCover().setCoverType(this.i18n.getString("pdf-plugin", this.getDefaultLocale(), "toc.type"));
        model.getToc().setName(this.i18n.getString("pdf-plugin", this.getDefaultLocale(), "toc.title"));
        this.appendGeneratedReports(model, locale);
        this.saveTOC(model.getToc(), locale);
        this.debugLogGeneratedModel(model);
        return model;
    }

    private DocumentModel getDocumentModelFromDescriptor(Locale locale) throws MojoExecutionException {
        DocumentModel model;
        try {
            model = new DocumentDescriptorReader(this.project, this.getLog(), locale).readAndFilterDocumentDescriptor(this.docDescriptor);
        }
        catch (XmlPullParserException ex) {
            throw new MojoExecutionException("Error reading DocumentDescriptor!", (Exception)((Object)ex));
        }
        catch (IOException io) {
            throw new MojoExecutionException("Error opening DocumentDescriptor!", (Exception)io);
        }
        if (model.getMeta() == null) {
            model.setMeta(new DocumentMeta());
        }
        if (StringUtils.isEmpty((String)model.getMeta().getLanguage())) {
            model.getMeta().setLanguage(locale.getLanguage());
        }
        if (StringUtils.isEmpty((String)model.getMeta().getGenerator())) {
            model.getMeta().setGenerator(this.getDefaultGenerator());
        }
        return model;
    }

    private File getLocaleDirectory(File basedir, Locale locale) {
        if (locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
            return basedir;
        }
        return new File(basedir, locale.getLanguage());
    }

    private Locale getDefaultLocale() {
        if (this.defaultLocale == null) {
            this.defaultLocale = this.getAvailableLocales().get(0);
        }
        return this.defaultLocale;
    }

    private List<Locale> getAvailableLocales() {
        if (this.localesList == null) {
            this.localesList = this.siteTool.getSiteLocales(this.locales);
        }
        return this.localesList;
    }

    private DecorationModel getDefaultDecorationModel() throws MojoExecutionException {
        if (this.defaultDecorationModel == null) {
            Locale locale = this.getDefaultLocale();
            File descriptorFile = this.siteTool.getSiteDescriptor(this.siteDirectory, locale);
            DecorationModel decoration = null;
            if (descriptorFile.exists()) {
                try (org.apache.commons.io.input.XmlStreamReader reader = new org.apache.commons.io.input.XmlStreamReader(descriptorFile);){
                    String siteDescriptorContent = IOUtil.toString((Reader)reader);
                    siteDescriptorContent = this.siteTool.getInterpolatedSiteDescriptorContent(new HashMap(2), this.project, siteDescriptorContent);
                    decoration = new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
                }
                catch (XmlPullParserException e) {
                    throw new MojoExecutionException("Error parsing site descriptor", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading site descriptor", (Exception)e);
                }
                catch (SiteToolException e) {
                    throw new MojoExecutionException("Error when interpoling site descriptor", (Exception)((Object)e));
                }
            }
            this.defaultDecorationModel = decoration;
        }
        return this.defaultDecorationModel;
    }

    private void copyResources(Locale locale) throws MojoExecutionException {
        Artifact skinArtifact;
        DecorationModel decorationModel = this.getDefaultDecorationModel();
        if (decorationModel == null) {
            return;
        }
        try {
            skinArtifact = this.siteTool.getSkinArtifactFromRepository(this.localRepository, this.project.getRemoteArtifactRepositories(), decorationModel);
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), (Exception)((Object)e));
        }
        if (skinArtifact == null) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Copy resources from skin artifact: '" + skinArtifact.getId() + "'..."));
        }
        try {
            SiteRenderingContext context = this.siteRenderer.createContextForSkin(skinArtifact, new HashMap(2), decorationModel, this.project.getName(), locale);
            context.addSiteDirectory(new File(this.siteDirectory, locale.getLanguage()));
            this.siteRenderer.copyResources(context, this.getWorkingDirectory());
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
        catch (RendererException e) {
            throw new MojoExecutionException("RendererException: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getDefaultGenerator() {
        return "Maven PDF Plugin v. " + this.pluginVersion + ", '" + this.implementation + "' implementation.";
    }

    private void debugLogGeneratedModel(DocumentModel docModel) {
        if (this.getLog().isDebugEnabled() && this.project != null) {
            File outputDir = new File(this.project.getBuild().getDirectory(), "pdf");
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            File doc = FileUtils.createTempFile((String)"pdf", (String)".xml", (File)outputDir);
            DocumentXpp3Writer xpp3 = new DocumentXpp3Writer();
            try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)doc);){
                xpp3.write((Writer)writer, docModel);
                this.getLog().debug((CharSequence)("Generated a default document model: " + doc.getAbsolutePath()));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to write document model: " + e.getMessage()));
                this.getLog().debug((Throwable)e);
            }
        }
    }

    private void generateMavenReports(Locale locale) throws MojoExecutionException, IOException {
        if (!this.isIncludeReports()) {
            this.getLog().info((CharSequence)"Skipped report generation.");
            return;
        }
        if (this.project.getReporting() == null) {
            this.getLog().info((CharSequence)"No report was specified.");
            return;
        }
        List<MavenReportExecution> reportExecutions = this.getReports();
        for (MavenReportExecution reportExecution : reportExecutions) {
            this.generateMavenReport(reportExecution, locale);
        }
        this.copySiteDir(this.getGeneratedSiteDirectoryTmp(), this.getSiteDirectoryTmp());
        this.copySiteDir(this.generatedSiteDirectory, this.getSiteDirectoryTmp());
    }

    private void generateMavenReport(MavenReportExecution reportExecution, Locale locale) throws IOException, MojoExecutionException {
        Object generatedReport2;
        MavenReport report = reportExecution.getMavenReport();
        String localReportName = report.getName(locale);
        if (!reportExecution.canGenerateReport()) {
            this.getLog().info((CharSequence)("Skipped \"" + localReportName + "\" report."));
            this.getLog().debug((CharSequence)"canGenerateReport() was false.");
            return;
        }
        if (report.isExternalReport()) {
            this.getLog().info((CharSequence)("Skipped external \"" + localReportName + "\" report (not supported by pdf plugin)."));
            this.getLog().debug((CharSequence)"isExternalReport() was false.");
            return;
        }
        for (Object generatedReport2 : this.getGeneratedMavenReports(locale)) {
            if (!report.getName(locale).equals(generatedReport2.getName(locale))) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(report.getName(locale) + " was already generated."));
            }
            return;
        }
        File outDir = new File(this.getGeneratedSiteDirectoryTmp(), "xdoc");
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            outDir = new File(new File(this.getGeneratedSiteDirectoryTmp(), locale.getLanguage()), "xdoc");
        }
        outDir.mkdirs();
        generatedReport2 = new File(outDir, report.getOutputName() + ".xml");
        if (this.siteDirectory.exists()) {
            String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
            List files = FileUtils.getFileNames((File)this.siteDirectory, (String)("*/" + report.getOutputName() + ".*"), (String)excludes, (boolean)false);
            if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
                files = FileUtils.getFileNames((File)new File(this.siteDirectory, locale.getLanguage()), (String)("*/" + report.getOutputName() + ".*"), (String)excludes, (boolean)false);
            }
            if (files.size() != 0) {
                String displayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)("Skipped \"" + report.getName(locale) + "\" report, file \"" + report.getOutputName() + "\" already exists for the " + displayLanguage + " version."));
                }
                return;
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Generating \"" + localReportName + "\" report."));
        }
        report.setReportOutputDirectory(outDir);
        StringWriter sw = new StringWriter();
        try (PdfXdocSink pdfXdocSink = null;){
            pdfXdocSink = new PdfXdocSink(sw);
            this.renderReportToSink(reportExecution, locale, pdfXdocSink);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Writing generated xdoc to " + generatedReport2));
        }
        PdfMojo.writeGeneratedReport(sw.toString(), (File)generatedReport2);
        if (this.isValidGeneratedReportXdoc(reportExecution.getPlugin().getId() + ':' + reportExecution.getGoal(), (File)generatedReport2, localReportName)) {
            this.getGeneratedMavenReports(locale).add(report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderReportToSink(MavenReportExecution reportExec, Locale locale, PdfXdocSink sink) throws MavenReportException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (reportExec.getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(reportExec.getClassLoader());
            }
            MavenReport report = reportExec.getMavenReport();
            report.generate((Sink)sink, locale);
        }
        finally {
            if (reportExec.getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    private List<MavenReport> getGeneratedMavenReports(Locale locale) {
        if (this.generatedMavenReports == null) {
            this.generatedMavenReports = new HashMap<Locale, List<MavenReport>>(2);
        }
        this.generatedMavenReports.computeIfAbsent(locale, k -> new ArrayList(2));
        return this.generatedMavenReports.get(locale);
    }

    protected void appendGeneratedReports(DocumentModel model, Locale locale) {
        if (!this.isIncludeReports()) {
            return;
        }
        if (this.getGeneratedMavenReports(locale).isEmpty()) {
            return;
        }
        DocumentTOCItem documentTOCItem = new DocumentTOCItem();
        documentTOCItem.setName(this.i18n.getString("pdf-plugin", locale, "toc.project-info.item"));
        documentTOCItem.setRef("project-info");
        ArrayList<String> addedRef = new ArrayList<String>(4);
        ArrayList<DocumentTOCItem> items = new ArrayList<DocumentTOCItem>(4);
        for (MavenReport report : this.getGeneratedMavenReports(locale)) {
            DocumentTOCItem reportItem = new DocumentTOCItem();
            reportItem.setName(report.getName(locale));
            reportItem.setRef(report.getOutputName());
            items.add(reportItem);
            addedRef.add(report.getOutputName());
        }
        try {
            if (this.generatedSiteDirectory.exists()) {
                String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
                List generatedDirs = FileUtils.getDirectoryNames((File)this.generatedSiteDirectory, (String)"*", (String)excludes, (boolean)true);
                if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
                    generatedDirs = FileUtils.getFileNames((File)new File(this.generatedSiteDirectory, locale.getLanguage()), (String)"*", (String)excludes, (boolean)true);
                }
                for (String generatedDir : generatedDirs) {
                    List generatedFiles = FileUtils.getFileNames((File)new File(generatedDir), (String)"**.*", (String)excludes, (boolean)false);
                    for (String generatedFile : generatedFiles) {
                        String title;
                        String ref = generatedFile.substring(0, generatedFile.lastIndexOf(46));
                        if (addedRef.contains(ref) || (title = this.getGeneratedDocumentTitle(new File(generatedDir, generatedFile))) == null) continue;
                        DocumentTOCItem reportItem = new DocumentTOCItem();
                        reportItem.setName(title);
                        reportItem.setRef(ref);
                        items.add(reportItem);
                    }
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
        }
        documentTOCItem.setItems(items);
        model.getToc().addItem(documentTOCItem);
    }

    private void saveTOC(DocumentTOC toc, Locale locale) {
        try {
            TocFileHelper.saveTOC(this.getWorkingDirectory(), toc, locale);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error while writing table of contents", (Throwable)e);
        }
    }

    private String getGeneratedDocumentTitle(File f) throws IOException {
        IndexEntry entry = new IndexEntry("index");
        IndexingSink titleSink = new IndexingSink(entry);
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)f);){
            this.doxia.parse((Reader)reader, f.getParentFile().getName(), (org.apache.maven.doxia.sink.Sink)titleSink);
        }
        catch (ParseException e) {
            this.getLog().error((CharSequence)("ParseException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
            return null;
        }
        catch (ParserNotFoundException e) {
            this.getLog().error((CharSequence)("ParserNotFoundException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
            return null;
        }
        return titleSink.getTitle();
    }

    private boolean isValidGeneratedReportXdoc(String fullGoal, File generatedReport, String localReportName) {
        SinkAdapter sinkAdapter = new SinkAdapter();
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)generatedReport);){
            this.doxia.parse((Reader)reader, "xdoc", (org.apache.maven.doxia.sink.Sink)sinkAdapter);
        }
        catch (ParseException e) {
            String sb = EOL + "Error when parsing the generated report xdoc file: " + generatedReport.getAbsolutePath() + EOL + e.getMessage() + EOL + "You could:" + EOL + "  * exclude all reports using -DincludeReports=false" + EOL + "  * remove the " + fullGoal + " from the <reporting/> part. To not affect the site generation, you could create a PDF profile." + EOL + "Ignoring the \"" + localReportName + "\" report in the PDF." + EOL;
            this.getLog().error((CharSequence)sb);
            this.getLog().debug((Throwable)e);
            return false;
        }
        catch (ParserNotFoundException e) {
            this.getLog().error((CharSequence)("ParserNotFoundException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
            return false;
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
            return false;
        }
        return true;
    }

    protected List<MavenReportExecution> getReports() throws MojoExecutionException {
        MavenReportExecutor mavenReportExecutor;
        MavenReportExecutorRequest mavenReportExecutorRequest = new MavenReportExecutorRequest();
        mavenReportExecutorRequest.setLocalRepository(this.localRepository);
        mavenReportExecutorRequest.setMavenSession(this.session);
        mavenReportExecutorRequest.setProject(this.project);
        mavenReportExecutorRequest.setReportPlugins(this.getReportingPlugins());
        try {
            mavenReportExecutor = (MavenReportExecutor)this.container.lookup(MavenReportExecutor.class.getName());
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("could not get MavenReportExecutor component", (Exception)((Object)e));
        }
        return mavenReportExecutor.buildMavenReports(mavenReportExecutorRequest);
    }

    private ReportPlugin[] getReportingPlugins() {
        List reportingPlugins = this.reporting.getPlugins();
        boolean hasMavenProjectInfoReportsPlugin = false;
        for (ReportPlugin plugin : reportingPlugins) {
            if (!"org.apache.maven.plugins".equals(plugin.getGroupId()) || !"maven-project-info-reports-plugin".equals(plugin.getArtifactId())) continue;
            hasMavenProjectInfoReportsPlugin = true;
            break;
        }
        if (!this.reporting.isExcludeDefaults() && !hasMavenProjectInfoReportsPlugin) {
            ReportPlugin mpir = new ReportPlugin();
            mpir.setArtifactId("maven-project-info-reports-plugin");
            reportingPlugins.add(mpir);
        }
        return reportingPlugins.toArray(new ReportPlugin[0]);
    }

    private static void writeGeneratedReport(String content, File toFile) throws IOException {
        if (content == null || content.isEmpty()) {
            return;
        }
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)toFile);){
            writer.write(StringUtils.replace((String)content, (String)"<table><table", (String)"<table"));
        }
    }

    private static String getDefaultExcludesWithLocales(List<Locale> locales, Locale defaultLocale) {
        StringBuilder excludesLocales = new StringBuilder(FileUtils.getDefaultExcludesAsString());
        for (Locale locale : locales) {
            if (locale.getLanguage().equals(defaultLocale.getLanguage())) continue;
            excludesLocales.append(",**/").append(locale.getLanguage()).append("/*");
        }
        return excludesLocales.toString();
    }

    private static class PdfXdocSink
    extends XdocSink
    implements Sink {
        protected PdfXdocSink(Writer writer) {
            super(writer);
        }

        public void text(String text) {
            super.text(StringUtils.replace((String)text, (String)"\u0092", (String)"'"));
        }

        public void tableRow() {
            if (!this.tableRows) {
                this.tableRows(null, false);
            }
            super.tableRow(null);
        }
    }
}

