/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pdf;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.pdf.DateBean;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DocumentDescriptorReader {
    private final MavenProject project;
    private final Log log;
    private final Locale locale;

    public DocumentDescriptorReader() {
        this(null, null, null);
    }

    public DocumentDescriptorReader(MavenProject project) {
        this(project, null, null);
    }

    public DocumentDescriptorReader(MavenProject project, Log log, Locale locale) {
        this.project = project;
        this.log = log;
        this.locale = locale;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentModel readAndFilterDocumentDescriptor(File docDescriptor) throws XmlPullParserException, IOException {
        if (this.locale != null) {
            String descriptorFilename = docDescriptor.getName();
            String localized = FileUtils.removeExtension((String)descriptorFilename) + '_' + this.locale.getLanguage() + '.' + FileUtils.getExtension((String)descriptorFilename);
            File localizedDocDescriptor = new File(docDescriptor.getParentFile(), localized);
            if (localizedDocDescriptor.exists()) {
                docDescriptor = localizedDocDescriptor;
            }
        }
        try {
            Properties filterProperties = System.getProperties();
            if (this.project != null && this.project.getProperties() != null) {
                filterProperties.putAll((Map<?, ?>)this.project.getProperties());
            }
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)filterProperties));
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource(this.project){

                public Object getValue(String expression) {
                    try {
                        return ReflectionValueExtractor.evaluate((String)expression, (Object)DocumentDescriptorReader.this.project);
                    }
                    catch (Exception e) {
                        this.addFeedback("Failed to extract '" + expression + "' from: " + DocumentDescriptorReader.this.project, e);
                        return null;
                    }
                }
            });
            DateBean bean = new DateBean();
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)bean));
            try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)docDescriptor);){
                String interpolatedDoc = interpolator.interpolate(IOUtil.toString((Reader)reader));
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Interpolated document descriptor (" + docDescriptor.getAbsolutePath() + ")\n" + interpolatedDoc));
                }
                DocumentModel documentModel = new DocumentXpp3Reader().read((Reader)new StringReader(interpolatedDoc), false);
                return documentModel;
            }
        }
        catch (InterpolationException e) {
            throw new IOException("Error interpolating document descriptor", e);
        }
    }
}

