/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.patch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="apply", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class ApplyMojo
extends AbstractMojo {
    public static final List<String> PATCH_FAILURE_WATCH_PHRASES;
    public static final List<String> DEFAULT_IGNORED_PATCHES;
    public static final List<String> DEFAULT_IGNORED_PATCH_PATTERNS;
    @Parameter(defaultValue="true")
    private boolean useDefaultIgnores;
    @Parameter
    protected List<String> patches;
    @Parameter(alias="patch.apply.skip", defaultValue="false")
    private boolean skipApplication;
    @Parameter(defaultValue="true")
    private boolean optimizations;
    @Parameter(defaultValue="${project.build.directory}/optimization-files/patches-applied.txt")
    private File patchTrackingFile;
    @Parameter(alias="patchTargetDir", defaultValue="${project.build.sourceDirectory}")
    private File targetDirectory;
    @Parameter(defaultValue="true")
    private boolean failFast;
    @Parameter(defaultValue="false")
    private boolean naturalOrderProcessing;
    @Parameter
    private List ignoredPatches;
    @Parameter(defaultValue="false")
    private boolean strictPatching;
    @Parameter(defaultValue="0")
    private int strip;
    @Parameter(defaultValue="true")
    private boolean ignoreWhitespace;
    @Parameter(defaultValue="false")
    private boolean reverse;
    @Parameter(defaultValue="false")
    private boolean backups;
    @Parameter
    private List<String> failurePhrases = PATCH_FAILURE_WATCH_PHRASES;
    @Parameter
    private File originalFile;
    @Parameter
    private File destFile;
    @Parameter
    private File patchFile;
    @Parameter(defaultValue="src/main/patches")
    private File patchDirectory;
    @Parameter(defaultValue="false")
    private boolean removeEmptyFiles;
    @Parameter(defaultValue="false")
    private boolean binary;
    @Parameter
    private List<String> excludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean patchFileEnabled;
        boolean patchDirEnabled = this.patches != null && !this.patches.isEmpty() || this.naturalOrderProcessing;
        boolean bl = patchFileEnabled = this.patchFile != null;
        if (!patchFileEnabled && !patchDirEnabled) {
            this.getLog().info((CharSequence)"Patching is disabled for this project.");
            return;
        }
        if (this.skipApplication) {
            this.getLog().info((CharSequence)"Skipping patch file application (per configuration).");
            return;
        }
        this.patchTrackingFile.getParentFile().mkdirs();
        try {
            Map<String, Commandline> patchesToApply;
            if (patchFileEnabled) {
                patchesToApply = Collections.singletonMap(this.patchFile.getName(), this.createPatchCommand(this.patchFile));
            } else {
                if (!this.patchDirectory.isDirectory()) {
                    throw new FileNotFoundException("The base directory for patch files does not exist: " + this.patchDirectory);
                }
                String excludePatterns = null;
                if (this.excludes != null) {
                    excludePatterns = StringUtils.join(this.excludes.iterator(), (String)",");
                    this.getLog().info((CharSequence)("Exclude pattern: " + excludePatterns));
                }
                List foundPatchFiles = FileUtils.getFileNames((File)this.patchDirectory, (String)"*", (String)excludePatterns, (boolean)false);
                patchesToApply = this.findPatchesToApply(foundPatchFiles, this.patchDirectory);
                this.checkStrictPatchCompliance(foundPatchFiles);
            }
            String output = this.applyPatches(patchesToApply);
            this.checkForWatchPhrases(output);
            this.writeTrackingFile(patchesToApply);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to obtain list of patch files", (Exception)ioe);
        }
    }

    private Map<String, Commandline> findPatchesToApply(List foundPatchFiles, File patchSourceDir) throws MojoFailureException {
        LinkedHashMap<String, Commandline> patchesApplied = new LinkedHashMap<String, Commandline>();
        if (this.naturalOrderProcessing) {
            this.patches = new ArrayList<String>(foundPatchFiles);
            Collections.sort(this.patches);
        }
        String alreadyAppliedPatches = "";
        try {
            if (this.optimizations && this.patchTrackingFile.exists()) {
                alreadyAppliedPatches = FileUtils.fileRead((File)this.patchTrackingFile);
            }
        }
        catch (IOException ioe) {
            throw new MojoFailureException("unable to read patch tracking file: " + ioe.getMessage());
        }
        for (String patch : this.patches) {
            if (alreadyAppliedPatches.contains(patch)) continue;
            File patchFile = new File(patchSourceDir, patch);
            this.getLog().debug((CharSequence)("Looking for patch: " + patch + " in: " + patchFile));
            if (!patchFile.exists()) {
                if (this.strictPatching) {
                    throw new MojoFailureException((Object)this, "Patch operation cannot proceed.", "Cannot find specified patch: '" + patch + "' in patch-source directory: '" + patchSourceDir + "'.\n\nEither fix this error, or relax strictPatching.");
                }
                this.getLog().info((CharSequence)("Skipping patch: " + patch + " listed in the parameter \"patches\"; it is missing."));
                continue;
            }
            foundPatchFiles.remove(patch);
            patchesApplied.put(patch, this.createPatchCommand(patchFile));
        }
        return patchesApplied;
    }

    private void checkStrictPatchCompliance(List<String> foundPatchFiles) throws MojoExecutionException {
        if (this.strictPatching) {
            ArrayList<String> ignored = new ArrayList<String>();
            if (this.ignoredPatches != null) {
                ignored.addAll(this.ignoredPatches);
            }
            if (this.useDefaultIgnores) {
                ignored.addAll(DEFAULT_IGNORED_PATCHES);
            }
            ArrayList<String> limbo = new ArrayList<String>(foundPatchFiles);
            limbo.removeAll(ignored);
            if (!limbo.isEmpty()) {
                StringBuilder extraFileBuffer = new StringBuilder();
                extraFileBuffer.append("Found ").append(limbo.size()).append(" unlisted patch files:");
                for (String patch : foundPatchFiles) {
                    extraFileBuffer.append("\n  '").append(patch).append('\'');
                }
                extraFileBuffer.append("\n\nEither remove these files, add them to the patches configuration list, or relax strictPatching.");
                throw new MojoExecutionException(extraFileBuffer.toString());
            }
        }
    }

    private String applyPatches(Map<String, Commandline> patchesApplied) throws MojoExecutionException {
        final StringWriter outputWriter = new StringWriter();
        StreamConsumer consumer = new StreamConsumer(){

            public void consumeLine(String line) {
                if (ApplyMojo.this.getLog().isDebugEnabled()) {
                    ApplyMojo.this.getLog().debug((CharSequence)line);
                }
                outputWriter.write(line + "\n");
            }
        };
        ArrayList<String> failedPatches = new ArrayList<String>();
        for (Map.Entry<String, Commandline> entry : patchesApplied.entrySet()) {
            String patchName = entry.getKey();
            Commandline cli = entry.getValue();
            try {
                this.getLog().info((CharSequence)("Applying patch: " + patchName));
                int result = this.executeCommandLine(cli, consumer, consumer);
                if (result == 0) continue;
                if (this.failFast) {
                    throw new MojoExecutionException("Patch command failed with exit code " + result + " for " + patchName + ". Please see console and debug output for more information.");
                }
                failedPatches.add(patchName);
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Failed to apply patch: " + patchName + ". See debug output for more information.", (Exception)((Object)e));
            }
        }
        if (!failedPatches.isEmpty()) {
            this.getLog().error((CharSequence)"Failed applying one or more patches:");
            for (String failedPatch : failedPatches) {
                this.getLog().error((CharSequence)("* " + failedPatch));
            }
            throw new MojoExecutionException("Patch command failed for one or more patches. See console and debug output for more information.");
        }
        return outputWriter.toString();
    }

    private int executeCommandLine(Commandline cli, StreamConsumer out, StreamConsumer err) throws CommandLineException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Executing: " + cli));
        }
        int result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Exit code: " + result));
        }
        return result;
    }

    private void writeTrackingFile(Map patchesApplied) throws MojoExecutionException {
        boolean appending = this.patchTrackingFile.exists();
        try (FileWriter writer = new FileWriter(this.patchTrackingFile, appending);){
            Iterator it = patchesApplied.keySet().iterator();
            while (it.hasNext()) {
                if (appending) {
                    writer.write(System.getProperty("line.separator"));
                }
                String patch = (String)it.next();
                writer.write(patch);
                if (!it.hasNext()) continue;
                writer.write(System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write patch-tracking file: " + this.patchTrackingFile, (Exception)e);
        }
    }

    private void checkForWatchPhrases(String output) throws MojoExecutionException {
        for (String phrase : this.failurePhrases) {
            if (!output.contains(phrase)) continue;
            throw new MojoExecutionException("Failed to apply patches (detected watch-phrase: '" + phrase + "' in output). If this is in error, configure the patchFailureWatchPhrases parameter.");
        }
    }

    private Commandline createPatchCommand(File patchFile) {
        Commandline cli = new Commandline();
        cli.setExecutable("patch");
        cli.setWorkingDirectory(this.targetDirectory.getAbsolutePath());
        cli.createArg().setValue("-p" + this.strip);
        if (this.binary) {
            cli.createArg().setValue("--binary");
        }
        if (this.ignoreWhitespace) {
            cli.createArg().setValue("-l");
        }
        if (this.reverse) {
            cli.createArg().setValue("-R");
        }
        if (this.backups) {
            cli.createArg().setValue("-b");
        }
        if (this.removeEmptyFiles) {
            cli.createArg().setValue("-E");
        }
        cli.createArg().setValue("-i");
        cli.createArg().setFile(patchFile);
        if (this.destFile != null) {
            cli.createArg().setValue("-o");
            cli.createArg().setFile(this.destFile);
        }
        if (this.originalFile != null) {
            cli.createArg().setFile(this.originalFile);
        }
        return cli;
    }

    static {
        ArrayList<String> watches = new ArrayList<String>();
        watches.add("fail");
        watches.add("skip");
        watches.add("reject");
        PATCH_FAILURE_WATCH_PHRASES = watches;
        ArrayList<String> ignored = new ArrayList<String>();
        ignored.add(".svn");
        ignored.add("CVS");
        DEFAULT_IGNORED_PATCHES = ignored;
        ArrayList<String> ignoredPatterns = new ArrayList<String>();
        ignoredPatterns.add(".svn/**");
        ignoredPatterns.add("CVS/**");
        DEFAULT_IGNORED_PATCH_PATTERNS = ignoredPatterns;
    }
}

