/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.mavenone;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class MavenOneRepositoryDeployMojo
extends AbstractMojo {
    protected String packaging;
    private File pomFile;
    private Artifact artifact;
    protected ArtifactDeployer deployer;
    protected ArtifactRepositoryFactory factory;
    protected String remoteRepositoryId;
    protected String remoteRepositoryUrl;
    private ArtifactRepositoryLayout legacyLayout;
    private ArtifactRepository localRepository;
    private List attachedArtifacts;

    public void execute() throws MojoExecutionException {
        try {
            ArtifactRepository deploymentRepository = this.factory.createDeploymentArtifactRepository(this.remoteRepositoryId, this.remoteRepositoryUrl, this.legacyLayout, false);
            boolean isPomArtifact = "pom".equals(this.packaging);
            if (isPomArtifact) {
                this.deployer.deploy(this.pomFile, this.artifact, deploymentRepository, this.localRepository);
            } else {
                File file = this.artifact.getFile();
                if (file == null) {
                    throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
                }
                this.deployer.deploy(file, this.artifact, deploymentRepository, this.localRepository);
            }
            if (this.attachedArtifacts != null && !this.attachedArtifacts.isEmpty()) {
                Iterator i = this.attachedArtifacts.iterator();
                while (i.hasNext()) {
                    Artifact attached = (Artifact)i.next();
                    this.deployer.deploy(attached.getFile(), attached, deploymentRepository, this.localRepository);
                }
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

