/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.jxr.AbstractJxrReport;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="jxr")
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class JxrReport
extends AbstractJxrReport {
    @Parameter(defaultValue="${project.compileSourceRoots}", required=true, readonly=true)
    private List<String> sourceDirs;
    @Parameter
    private String sourcePath;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref")
    private String destDir;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/apidocs")
    private File javadocDir;

    @Override
    protected String getDestinationDirectory() {
        return this.destDir;
    }

    @Override
    protected List<String> getSourceRoots() {
        String[] sourcePathArray;
        if (this.sourcePath != null && (sourcePathArray = this.sourcePath.split(";")).length > 0) {
            return Arrays.asList(sourcePathArray);
        }
        ArrayList<String> l = new ArrayList<String>();
        if (!"pom".equals(this.getProject().getPackaging().toLowerCase(Locale.US))) {
            l.addAll(this.sourceDirs);
        }
        if (this.getProject().getExecutionProject() != null && !"pom".equals(this.getProject().getExecutionProject().getPackaging().toLowerCase(Locale.US))) {
            l.addAll(this.getProject().getExecutionProject().getCompileSourceRoots());
        }
        return l;
    }

    @Override
    protected List<String> getSourceRoots(MavenProject project) {
        ArrayList<String> l = new ArrayList<String>();
        if (!"pom".equals(project.getPackaging().toLowerCase(Locale.US))) {
            l.addAll(project.getCompileSourceRoots());
        }
        if (project.getExecutionProject() != null && !"pom".equals(project.getExecutionProject().getPackaging().toLowerCase(Locale.US))) {
            l.addAll(project.getExecutionProject().getCompileSourceRoots());
        }
        return l;
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.xref.main.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.xref.main.name");
    }

    public String getOutputName() {
        return "xref/index";
    }

    @Override
    protected File getJavadocDir() {
        return this.javadocDir;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.destDir = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("xref") ? new File(reportOutputDirectory, "xref").getAbsolutePath() : reportOutputDirectory.getAbsolutePath();
    }
}

