/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jmod;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.jmod.AbstractJModMojo;
import org.codehaus.plexus.util.cli.Commandline;

@Mojo(name="hash", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PACKAGE)
public class JModHashMojo
extends AbstractJModMojo {
    @Parameter
    private List<String> classPath;
    @Parameter
    private List<String> cmds;
    @Parameter
    private File config;
    @Parameter
    private boolean dryRun;
    @Parameter
    private List<String> excludes;
    @Parameter
    private String mainClass;
    @Parameter
    private List<File> libs;
    @Parameter
    private String moduleVersion;
    @Parameter(required=true)
    private File modulePath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String jModExecutable;
        try {
            jModExecutable = this.getJModExecutable();
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to find jmod command: " + e.getMessage(), (Throwable)e);
        }
        Commandline cmd = this.createJModHashCommandLine();
        cmd.setExecutable(jModExecutable);
    }

    private Commandline createJModHashCommandLine() {
        Commandline cmd = new Commandline();
        cmd.createArg().setValue("hash");
        if (this.dryRun) {
            cmd.createArg().setValue("--dry-run");
        }
        return cmd;
    }
}

