/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jmod;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.jmod.AbstractJModMojo;
import org.codehaus.plexus.util.cli.Commandline;

@Mojo(name="describe", requiresDependencyResolution=ResolutionScope.NONE, defaultPhase=LifecyclePhase.NONE)
public class JModDescribeMojo
extends AbstractJModMojo {
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/jmods/${project.artifactId}.jmod", property="jmodfile", required=true)
    private File jmodFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Commandline cmd;
        String jModExecutable;
        try {
            jModExecutable = this.getJModExecutable();
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to find jmod command: " + e.getMessage(), (Throwable)e);
        }
        this.getLog().info((CharSequence)("Toolchain in maven-jmod-plugin: jmod [ " + jModExecutable + " ]"));
        if (!this.jmodFile.exists() || !this.jmodFile.isFile()) {
            throw new MojoFailureException("Unable to find " + this.jmodFile.getAbsolutePath());
        }
        try {
            cmd = this.createJModDescribeCommandLine(this.jmodFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        cmd.setExecutable(jModExecutable);
        this.getLog().info((CharSequence)("The following information is contained in the module file " + this.jmodFile.getAbsolutePath()));
        this.executeCommand(cmd, this.outputDirectory);
    }

    private Commandline createJModDescribeCommandLine(File resultingJModFile) throws IOException {
        File file = new File(this.outputDirectory, "jmodDescribeArgs");
        if (!this.getLog().isDebugEnabled()) {
            file.deleteOnExit();
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
        PrintStream argsFile = new PrintStream(file);
        argsFile.println("describe");
        argsFile.println(resultingJModFile.getAbsolutePath());
        argsFile.close();
        Commandline cmd = new Commandline();
        cmd.createArg().setValue('@' + file.getAbsolutePath());
        return cmd;
    }
}

