/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jmod;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.jmod.AbstractJModMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.Commandline;

@Mojo(name="create", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public class JModCreateMojo
extends AbstractJModMojo {
    private static final String JMODS = "jmods";
    private List<String> classpathElements;
    private List<String> modulepathElements;
    private Map<String, JavaModuleDescriptor> pathElements;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    @Component
    private LocationManager locationManager;
    @Parameter
    private List<String> cmds;
    private static final String DEFAULT_CMD_DIRECTORY = "src/main/cmds";
    @Parameter
    private List<String> configs;
    private static final String DEFAULT_CONFIG_DIRECTORY = "src/main/configs";
    @Parameter
    private List<String> excludes;
    @Parameter
    private String mainClass;
    @Parameter
    private List<String> libs;
    private static final String DEFAULT_LIB_DIRECTORY = "src/main/libs";
    @Parameter(defaultValue="${project.version}")
    private String moduleVersion;
    @Parameter(defaultValue="false")
    private boolean doNotResolveByDefault;
    @Parameter
    private List<String> headerFiles;
    private static final String DEFAULT_HEADER_FILES_DIRECTORY = "src/main/headerfiles";
    @Parameter
    private List<String> manPages;
    private static final String DEFAULT_MAN_PAGES_DIRECTORY = "src/main/manpages";
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    private String outputFileName;
    @Parameter
    private List<String> legalNotices;
    private static final String DEFAULT_LEGAL_NOTICES_DIRECTORY = "src/main/legalnotices";
    @Parameter
    private String targetPlatform;
    @Parameter
    private String warnIfResolved;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private File targetClassesDirectory;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File outputDirectory;
    private List<String> modulePaths;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Commandline cmd;
        String jModExecutable;
        try {
            jModExecutable = this.getJModExecutable();
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to find jmod command: " + e.getMessage(), (Throwable)e);
        }
        File jModExecuteableFile = new File(jModExecutable);
        File jModExecutableParent = jModExecuteableFile.getParentFile().getParentFile();
        File jmodsFolderJDK = new File(jModExecutableParent, JMODS);
        this.getLog().debug((CharSequence)("Parent: " + jModExecutableParent.getAbsolutePath()));
        this.getLog().debug((CharSequence)("jmodsFolder: " + jmodsFolderJDK.getAbsolutePath()));
        this.preparePaths();
        this.failIfParametersAreNotInTheirValidValueRanges();
        this.getLog().info((CharSequence)("Toolchain in maven-jmod-plugin: jmod [ " + jModExecutable + " ]"));
        File modsFolder = new File(this.outputDirectory, JMODS);
        File resultingJModFile = new File(modsFolder, this.outputFileName + ".jmod");
        this.deleteOutputIfAlreadyExists(resultingJModFile);
        modsFolder.mkdirs();
        this.modulePaths = new ArrayList<String>();
        for (Map.Entry<String, JavaModuleDescriptor> item : this.pathElements.entrySet()) {
            if (item.getValue() == null) {
                String message = "The given dependency " + item.getKey() + " does not have a module-info.java file. So it can't be linked.";
                this.getLog().error((CharSequence)message);
                throw new MojoFailureException(message);
            }
            this.getLog().debug((CharSequence)("pathElements Item:" + item.getKey() + " v:" + item.getValue().name()));
            this.getLog().info((CharSequence)(" -> module: " + item.getValue().name() + " ( " + item.getKey() + " )"));
            this.modulePaths.add(item.getKey());
        }
        this.modulePaths.add(jmodsFolderJDK.getAbsolutePath());
        try {
            cmd = this.createJModCreateCommandLine(resultingJModFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        cmd.setExecutable(jModExecutable);
        this.executeCommand(cmd, this.outputDirectory);
        if (this.projectHasAlreadySetAnArtifact()) {
            throw new MojoExecutionException("You have to use a classifier to attach supplemental artifacts to the project instead of replacing them.");
        }
        this.getProject().getArtifact().setFile(resultingJModFile);
    }

    private void deleteOutputIfAlreadyExists(File resultingJModFile) throws MojoFailureException {
        if (resultingJModFile.exists() && resultingJModFile.isFile()) {
            try {
                this.getLog().debug((CharSequence)("Deleting the existing " + resultingJModFile.getAbsolutePath() + " file."));
                FileUtils.forceDelete((File)resultingJModFile);
            }
            catch (IOException e) {
                String message = "Failure during deleting of file " + resultingJModFile.getAbsolutePath();
                this.getLog().error((CharSequence)message);
                throw new MojoFailureException(message);
            }
        }
    }

    private void failIfParametersAreNotInTheirValidValueRanges() throws MojoFailureException {
        String x;
        if (this.warnIfResolved != null && !"deprecated".equals(x = this.warnIfResolved.toLowerCase().trim()) && "deprecated-for-removal".equals(x) && "incubating".equals(x)) {
            String message = "The parameter warnIfResolved does not contain a valid value. Valid values are 'deprecated', 'deprecated-for-removal' or 'incubating'.";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        this.throwExceptionIfNotExistOrNotADirectory(this.handleConfigurationListWithDefault(this.cmds, DEFAULT_CMD_DIRECTORY), "cmd");
        this.throwExceptionIfNotExistOrNotADirectory(this.handleConfigurationListWithDefault(this.configs, DEFAULT_CONFIG_DIRECTORY), "config");
        this.throwExceptionIfNotExistOrNotADirectory(this.handleConfigurationListWithDefault(this.libs, DEFAULT_LIB_DIRECTORY), "lib");
        this.throwExceptionIfNotExistOrNotADirectory(this.handleConfigurationListWithDefault(this.headerFiles, DEFAULT_HEADER_FILES_DIRECTORY), "headerFile");
        this.throwExceptionIfNotExistOrNotADirectory(this.handleConfigurationListWithDefault(this.legalNotices, DEFAULT_LEGAL_NOTICES_DIRECTORY), "legalNotice");
        this.throwExceptionIfNotExistOrNotADirectory(this.handleConfigurationListWithDefault(this.manPages, DEFAULT_MAN_PAGES_DIRECTORY), "manPage");
    }

    private void throwExceptionIfNotExistOrNotADirectory(List<String> configurations, String partialMessage) throws MojoFailureException {
        for (String configLocation : configurations) {
            File dir = new File(configLocation);
            if (dir.exists() && dir.isDirectory()) continue;
            String message = "The directory " + configLocation + " for " + partialMessage + " parameter does not exist or is not a directory. ";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
    }

    private List<File> getCompileClasspathElements(MavenProject project) {
        ArrayList<File> list = new ArrayList<File>(project.getArtifacts().size() + 1);
        list.add(new File(project.getBuild().getOutputDirectory()));
        for (Artifact a : project.getArtifacts()) {
            list.add(a.getFile());
        }
        return list;
    }

    private void preparePaths() {
        assert (this.compilePath != null);
        boolean hasModuleDescriptor = false;
        File moduleInfo = new File(this.targetClassesDirectory, "module-info.class");
        if (moduleInfo.exists() && moduleInfo.isFile()) {
            this.getLog().debug((CharSequence)"We have found a module-info.class file.");
            hasModuleDescriptor = true;
        }
        if (hasModuleDescriptor) {
            this.modulepathElements = new ArrayList<String>();
            this.classpathElements = new ArrayList<String>();
            this.pathElements = new LinkedHashMap<String, JavaModuleDescriptor>();
            try {
                List<File> dependencyArtifacts = this.getCompileClasspathElements(this.getProject());
                ResolvePathsRequest request = ResolvePathsRequest.withFiles(dependencyArtifacts);
                Toolchain toolchain = this.getToolchain();
                if (toolchain != null && toolchain instanceof DefaultJavaToolChain) {
                    request.setJdkHome((Object)new File(((DefaultJavaToolChain)toolchain).getJavaHome()));
                }
                ResolvePathsResult resolvePathsResult = this.locationManager.resolvePaths(request);
                JavaModuleDescriptor moduleDescriptor = resolvePathsResult.getMainModuleDescriptor();
                for (Map.Entry entry : resolvePathsResult.getModulepathElements().entrySet()) {
                    this.getLog().debug((CharSequence)("File: " + ((File)entry.getKey()).getAbsolutePath() + " " + ((ResolvePathsResult.ModuleNameSource)entry.getValue()).name()));
                    if (!ResolvePathsResult.ModuleNameSource.FILENAME.equals(entry.getValue())) continue;
                    String message = "Required filename-based automodules detected. Please don't publish this project to a public artifact repository!";
                    if (moduleDescriptor.exports().isEmpty()) {
                        this.getLog().info((CharSequence)"Required filename-based automodules detected. Please don't publish this project to a public artifact repository!");
                        break;
                    }
                    this.writeBoxedWarning("Required filename-based automodules detected. Please don't publish this project to a public artifact repository!");
                    break;
                }
                for (Map.Entry entry : resolvePathsResult.getPathElements().entrySet()) {
                    this.getLog().debug((CharSequence)("pathElements: " + ((File)entry.getKey()).getPath() + " " + ((JavaModuleDescriptor)entry.getValue()).name()));
                    this.pathElements.put(((File)entry.getKey()).getPath(), (JavaModuleDescriptor)entry.getValue());
                }
                for (File file : resolvePathsResult.getClasspathElements()) {
                    this.getLog().debug((CharSequence)("classpathElements: File: " + file.getPath()));
                    this.classpathElements.add(file.getPath());
                }
                for (File file : resolvePathsResult.getModulepathElements().keySet()) {
                    this.getLog().debug((CharSequence)("modulepathElements: File: " + file.getPath()));
                    this.modulepathElements.add(file.getPath());
                }
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)e.getMessage());
            }
        } else {
            this.classpathElements = this.compilePath;
            this.modulepathElements = Collections.emptyList();
        }
    }

    private Commandline createJModCreateCommandLine(File resultingJModFile) throws IOException {
        List<String> manPagesList;
        List<String> legalNoticesList;
        List<String> headerFilesList;
        List<String> libsList;
        List<String> cmdsList;
        List<String> configList;
        File file = new File(this.outputDirectory, "jmodCreateArgs");
        if (!this.getLog().isDebugEnabled()) {
            file.deleteOnExit();
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
        PrintStream argsFile = new PrintStream(file);
        argsFile.println("create");
        if (this.moduleVersion != null) {
            argsFile.println("--module-version");
            argsFile.println(this.moduleVersion);
        }
        if (!this.pathElements.isEmpty()) {
            argsFile.println("--class-path");
            ArrayList<String> x = new ArrayList<String>();
            for (String string : this.pathElements.keySet()) {
                x.add(string);
            }
            argsFile.println(this.getPlatformSeparatedList(x));
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            argsFile.println("--exclude");
            String commaSeparatedList = this.getCommaSeparatedList(this.excludes);
            argsFile.append('\"').append(commaSeparatedList.replace("\\", "\\\\")).println('\"');
        }
        if (!(configList = this.handleConfigurationListWithDefault(this.configs, DEFAULT_CONFIG_DIRECTORY)).isEmpty()) {
            argsFile.println("--config");
            argsFile.println(this.getPlatformSeparatedList(configList));
        }
        if (!(cmdsList = this.handleConfigurationListWithDefault(this.cmds, DEFAULT_CMD_DIRECTORY)).isEmpty()) {
            argsFile.println("--cmds");
            argsFile.println(this.getPlatformSeparatedList(cmdsList));
        }
        if (!(libsList = this.handleConfigurationListWithDefault(this.libs, DEFAULT_LIB_DIRECTORY)).isEmpty()) {
            argsFile.println("--libs");
            argsFile.println(this.getPlatformSeparatedList(libsList));
        }
        if (!(headerFilesList = this.handleConfigurationListWithDefault(this.headerFiles, DEFAULT_HEADER_FILES_DIRECTORY)).isEmpty()) {
            argsFile.println("--header-files");
            argsFile.println(this.getPlatformSeparatedList(headerFilesList));
        }
        if (!(legalNoticesList = this.handleConfigurationListWithDefault(this.legalNotices, DEFAULT_LEGAL_NOTICES_DIRECTORY)).isEmpty()) {
            argsFile.println("--legal-notices");
            argsFile.println(this.getPlatformSeparatedList(legalNoticesList));
        }
        if (!(manPagesList = this.handleConfigurationListWithDefault(this.manPages, DEFAULT_MAN_PAGES_DIRECTORY)).isEmpty()) {
            argsFile.println("--man-pages");
            argsFile.println(this.getPlatformSeparatedList(manPagesList));
        }
        if (this.modulePaths != null) {
            argsFile.println("--module-path");
            argsFile.append('\"').append(this.getPlatformSeparatedList(this.modulePaths).replace("\\", "\\\\")).println('\"');
        }
        if (this.targetPlatform != null) {
            argsFile.println("--target-platform");
            argsFile.println(this.targetPlatform);
        }
        if (this.warnIfResolved != null) {
            argsFile.println("--warn-if-resolved");
            argsFile.println(this.warnIfResolved);
        }
        if (this.doNotResolveByDefault) {
            argsFile.println("--do-not-resolve-by-default");
        }
        argsFile.println(resultingJModFile.getAbsolutePath());
        argsFile.close();
        Commandline cmd = new Commandline();
        cmd.createArg().setValue('@' + file.getAbsolutePath());
        return cmd;
    }

    private boolean isConfigurationDefinedInPOM(List<String> configuration) {
        return configuration != null && !configuration.isEmpty();
    }

    private List<String> handleConfigurationListWithDefault(List<String> configuration, String defaultLocation) {
        List<String> commands = new ArrayList<String>();
        if (this.isConfigurationDefinedInPOM(configuration)) {
            commands.addAll(configuration);
        } else if (this.doDefaultsExist(defaultLocation)) {
            commands.add(defaultLocation);
        }
        commands = this.resolveAgainstProjectBaseDir(commands);
        return commands;
    }

    private List<String> resolveAgainstProjectBaseDir(List<String> relativeDirectories) {
        ArrayList<String> result = new ArrayList<String>();
        for (String configLocation : relativeDirectories) {
            File dir = new File(this.getProject().getBasedir(), configLocation);
            result.add(dir.getAbsolutePath());
        }
        return result;
    }

    private boolean doDefaultsExist(String defaultLocation) {
        boolean result = false;
        File dir = new File(this.getProject().getBasedir(), defaultLocation);
        if (dir.exists() && dir.isDirectory()) {
            result = true;
        }
        return result;
    }

    private String getPlatformSeparatedList(List<String> paths) {
        StringBuilder sb = new StringBuilder();
        for (String module : paths) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(module);
        }
        return sb.toString();
    }

    private void writeBoxedWarning(String message) {
        String line = StringUtils.repeat((String)"*", (int)(message.length() + 4));
        this.getLog().warn((CharSequence)line);
        this.getLog().warn((CharSequence)("* " + MessageUtils.buffer().strong((Object)message) + " *"));
        this.getLog().warn((CharSequence)line);
    }
}

