/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jlink;

import java.io.File;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.jlink.AbstractJLinkExecutor;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.toolchain.Toolchain;

abstract class AbstractJLinkToolchainExecutor
extends AbstractJLinkExecutor {
    private final Toolchain toolchain;

    AbstractJLinkToolchainExecutor(Toolchain toolchain, Log log) {
        super(log);
        this.toolchain = toolchain;
    }

    protected Optional<Toolchain> getToolchain() {
        return Optional.ofNullable(this.toolchain);
    }

    @Override
    public int executeJlink(List<String> jlinkArgs) throws MojoExecutionException {
        File jlinkExecutable = this.getJlinkExecutable();
        this.getLog().info((CharSequence)("Toolchain in maven-jlink-plugin: jlink [ " + jlinkExecutable + " ]"));
        Commandline cmd = this.createJLinkCommandLine(jlinkArgs);
        cmd.setExecutable(jlinkExecutable.getAbsolutePath());
        return this.executeCommand(cmd);
    }

    private File getJlinkExecutable() {
        return new File(this.getJLinkExecutable());
    }

    @Override
    public Optional<File> getJmodsFolder(File sourceJdkModules) {
        File jLinkParent = this.getJlinkExecutable().getParentFile().getParentFile();
        File jmodsFolder = sourceJdkModules != null && sourceJdkModules.isDirectory() ? new File(sourceJdkModules, "jmods") : new File(jLinkParent, "jmods");
        this.getLog().debug((CharSequence)(" Parent: " + jLinkParent.getAbsolutePath()));
        this.getLog().debug((CharSequence)(" jmodsFolder: " + jmodsFolder.getAbsolutePath()));
        return Optional.of(jmodsFolder);
    }

    private Commandline createJLinkCommandLine(List<String> jlinkArgs) {
        Commandline cmd = new Commandline();
        jlinkArgs.forEach(arg -> cmd.createArg().setValue(arg));
        return cmd;
    }

    private String getJLinkExecutable() {
        Optional<Toolchain> toolchain = this.getToolchain();
        if (!toolchain.isPresent()) {
            this.getLog().error((CharSequence)"Either JDK9+ or a toolchain pointing to a JDK9+ containing a jlink binary is required.");
            this.getLog().info((CharSequence)"See https://maven.apache.org/guides/mini/guide-using-toolchains.html for mor information.");
            throw new IllegalStateException("Running on JDK8 and no toolchain found.");
        }
        String jLinkExecutable = toolchain.orElseThrow(NoSuchElementException::new).findTool("jlink");
        if (jLinkExecutable.isEmpty()) {
            throw new IllegalStateException("The jlink executable '" + jLinkExecutable + "' doesn't exist or is not a file.");
        }
        String jLinkCommand = "jlink" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        File jLinkExe = new File(jLinkExecutable);
        if (jLinkExe.isDirectory()) {
            jLinkExe = new File(jLinkExe, jLinkCommand);
        }
        if (SystemUtils.IS_OS_WINDOWS && jLinkExe.getName().indexOf(46) < 0) {
            jLinkExe = new File(jLinkExe.getPath() + ".exe");
        }
        if (!jLinkExe.isFile()) {
            throw new IllegalStateException("The jlink executable '" + jLinkExe + "' doesn't exist or is not a file.");
        }
        return jLinkExe.getAbsolutePath();
    }

    private int executeCommand(Commandline cmd) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", ""));
        }
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        try {
            String output;
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
            String string = output = StringUtils.isEmpty((CharSequence)out.getOutput()) ? null : '\n' + out.getOutput().trim();
            if (exitCode != 0) {
                if (StringUtils.isNotEmpty(output)) {
                    for (String outputLine : output.split("\n")) {
                        this.getLog().error((CharSequence)outputLine);
                    }
                }
                StringBuilder msg = new StringBuilder("\nExit code: ");
                msg.append(exitCode);
                if (StringUtils.isNotEmpty((CharSequence)err.getOutput())) {
                    msg.append(" - ").append(err.getOutput());
                }
                msg.append('\n');
                msg.append("Command line was: ").append(cmd).append('\n').append('\n');
                throw new MojoExecutionException(msg.toString());
            }
            if (StringUtils.isNotEmpty(output)) {
                for (String outputLine : output.split("\n")) {
                    this.getLog().info((CharSequence)outputLine);
                }
            }
            return exitCode;
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute jlink command: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

