/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.javadoc.SystemUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyUtils;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JavadocUtil {
    public static final int DEFAULT_TIMEOUT = 2000;
    protected static final String ERROR_INIT_VM = "Error occurred during initialization of VM, try to reduce the Java heap size for the MAVEN_OPTS environment variable using -Xms:<size> and -Xmx:<size>.";
    private static final Pattern EXTRACT_JAVADOC_VERSION_PATTERN = Pattern.compile("(?s).*?[^a-zA-Z](([0-9]+\\.?[0-9]*)(\\.[0-9]+)?).*");
    private static final Pattern PARSE_JAVADOC_MEMORY_PATTERN_0 = Pattern.compile("^\\s*(\\d+)\\s*?\\s*$");
    private static final Pattern PARSE_JAVADOC_MEMORY_PATTERN_1 = Pattern.compile("^\\s*(\\d+)\\s*k(b)?\\s*$", 2);
    private static final Pattern PARSE_JAVADOC_MEMORY_PATTERN_2 = Pattern.compile("^\\s*(\\d+)\\s*m(b)?\\s*$", 2);
    private static final Pattern PARSE_JAVADOC_MEMORY_PATTERN_3 = Pattern.compile("^\\s*(\\d+)\\s*g(b)?\\s*$", 2);
    private static final Pattern PARSE_JAVADOC_MEMORY_PATTERN_4 = Pattern.compile("^\\s*(\\d+)\\s*t(b)?\\s*$", 2);

    public static Collection<Path> prunePaths(MavenProject project, Collection<String> paths, boolean includeFiles) {
        Path projectBasedir = project.getBasedir().toPath();
        LinkedHashSet<Path> pruned = new LinkedHashSet<Path>(paths.size());
        for (String path : paths) {
            Path resolvedPath;
            if (path == null || !Files.isDirectory(resolvedPath = projectBasedir.resolve(path), new LinkOption[0]) && (!includeFiles || !Files.isRegularFile(resolvedPath, new LinkOption[0]))) continue;
            pruned.add(resolvedPath.toAbsolutePath());
        }
        return pruned;
    }

    public static Collection<Path> pruneDirs(MavenProject project, Collection<String> dirs) {
        return JavadocUtil.prunePaths(project, dirs, false);
    }

    protected static List<String> pruneFiles(Collection<String> files) {
        ArrayList<String> pruned = new ArrayList<String>(files.size());
        for (String f : files) {
            if (JavadocUtil.shouldPruneFile(f, pruned)) continue;
            pruned.add(f);
        }
        return pruned;
    }

    public static boolean shouldPruneFile(String f, List<String> pruned) {
        return f == null || !Files.isRegularFile(Paths.get(f, new String[0]), new LinkOption[0]) || pruned.contains(f);
    }

    protected static List<String> getExcludedPackages(Collection<Path> sourcePaths, Collection<String> excludedPackages) {
        ArrayList<String> excludedNames = new ArrayList<String>();
        for (Path sourcePath : sourcePaths) {
            excludedNames.addAll(JavadocUtil.getExcludedPackages(sourcePath, excludedPackages));
        }
        return excludedNames;
    }

    protected static String quotedArgument(String value) {
        String arg = value;
        if (arg != null && !arg.isEmpty()) {
            arg = arg.replace("'", "\\'");
            arg = "'" + arg + "'";
            arg = arg.replace("\n", " ");
        }
        return arg;
    }

    protected static String quotedPathArgument(String value) {
        String path = value;
        if (path != null && !path.isEmpty()) {
            if ((path = path.replace('\\', '/')).contains("'")) {
                StringBuilder pathBuilder = new StringBuilder();
                pathBuilder.append('\'');
                String[] split = path.split("'");
                for (int i = 0; i < split.length; ++i) {
                    if (i != split.length - 1) {
                        pathBuilder.append(split[i]).append("\\'");
                        continue;
                    }
                    pathBuilder.append(split[i]);
                }
                pathBuilder.append('\'');
                path = pathBuilder.toString();
            } else {
                path = "'" + path + "'";
            }
        }
        return path;
    }

    protected static void copyJavadocResources(File outputDirectory, File javadocDir, String excludedocfilessubdir) throws IOException {
        if (!javadocDir.isDirectory()) {
            return;
        }
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(FileUtils.getDefaultExcludes()));
        if (excludedocfilessubdir != null && !excludedocfilessubdir.isEmpty()) {
            StringTokenizer st = new StringTokenizer(excludedocfilessubdir, ":");
            while (st.hasMoreTokens()) {
                String current = st.nextToken();
                excludes.add("**/" + current + "/**");
            }
        }
        List docFiles = FileUtils.getDirectoryNames((File)javadocDir, (String)"resources,**/doc-files", (String)String.join((CharSequence)",", excludes), (boolean)false, (boolean)true);
        for (String docFile : docFiles) {
            File docFileOutput = new File(outputDirectory, docFile);
            FileUtils.mkdir((String)docFileOutput.getAbsolutePath());
            FileUtils.copyDirectoryStructure((File)new File(javadocDir, docFile), (File)docFileOutput);
            List files = FileUtils.getFileAndDirectoryNames((File)docFileOutput, (String)String.join((CharSequence)",", excludes), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
            for (String filename : files) {
                File file = new File(filename);
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory((File)file);
                    continue;
                }
                file.delete();
            }
        }
    }

    protected static List<String> getIncludedFiles(File sourceDirectory, String[] fileList, Collection<String> excludePackages) {
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<Pattern> excludePackagePatterns = new ArrayList<Pattern>(excludePackages.size());
        for (String excludePackage : excludePackages) {
            excludePackagePatterns.add(Pattern.compile(excludePackage.replace('.', File.separatorChar).replace("\\", "\\\\").replace("*", ".+").concat("[\\\\/][^\\\\/]+\\.java")));
        }
        for (String file : fileList) {
            boolean excluded = false;
            for (Pattern excludePackagePattern : excludePackagePatterns) {
                if (!excludePackagePattern.matcher(file).matches()) continue;
                excluded = true;
                break;
            }
            if (excluded) continue;
            files.add(file.replace('\\', '/'));
        }
        return files;
    }

    protected static Collection<String> getExcludedPackages(final Path sourceDirectory, Collection<String> excludePackagenames) {
        String regexFileSeparator = File.separator.replace("\\", "\\\\");
        final ArrayList fileList = new ArrayList();
        try {
            Files.walkFileTree(sourceDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".java")) {
                        fileList.add(sourceDirectory.relativize(file.getParent()).toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList<String> files = new ArrayList<String>();
        for (String excludePackagename : excludePackagenames) {
            Pattern p = Pattern.compile(excludePackagename.replace(".", regexFileSeparator).replaceFirst("^\\*", ".+").replace("*", "[^" + regexFileSeparator + "]+"));
            for (String aFileList : fileList) {
                if (!p.matcher(aFileList).matches()) continue;
                files.add(aFileList.replace(File.separatorChar, '.'));
            }
        }
        return files;
    }

    protected static List<String> getFilesFromSource(File sourceDirectory, List<String> sourceFileIncludes, List<String> sourceFileExcludes, Collection<String> excludePackages) {
        DirectoryScanner ds = new DirectoryScanner();
        if (sourceFileIncludes == null) {
            sourceFileIncludes = Collections.singletonList("**/*.java");
        }
        ds.setIncludes(sourceFileIncludes.toArray(new String[sourceFileIncludes.size()]));
        if (sourceFileExcludes != null && sourceFileExcludes.size() > 0) {
            ds.setExcludes(sourceFileExcludes.toArray(new String[sourceFileExcludes.size()]));
        }
        ds.setBasedir(sourceDirectory);
        ds.scan();
        String[] fileList = ds.getIncludedFiles();
        ArrayList<String> files = new ArrayList<String>();
        if (fileList.length != 0) {
            files.addAll(JavadocUtil.getIncludedFiles(sourceDirectory, fileList, excludePackages));
        }
        return files;
    }

    protected static JavaVersion getJavadocVersion(File javadocExe) throws IOException, CommandLineException, IllegalArgumentException {
        if (javadocExe == null || !javadocExe.exists() || !javadocExe.isFile()) {
            throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. ");
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable(javadocExe.getAbsolutePath());
        cmd.setWorkingDirectory(javadocExe.getParentFile());
        cmd.createArg().setValue("-J-version");
        JavadocOutputStreamConsumer out = new JavadocOutputStreamConsumer();
        JavadocOutputStreamConsumer err = new JavadocOutputStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
        String errOutput = err.getOutput();
        if (exitCode != 0) {
            StringBuilder msg = new StringBuilder("Exit code: " + exitCode + " - " + errOutput);
            msg.append('\n');
            msg.append("Command line was:").append(CommandLineUtils.toString((String[])cmd.getCommandline()));
            throw new CommandLineException(msg.toString());
        }
        if (!errOutput.isEmpty()) {
            return JavaVersion.parse((String)JavadocUtil.extractJavadocVersion(errOutput));
        }
        String outOutput = out.getOutput();
        if (!outOutput.isEmpty()) {
            return JavaVersion.parse((String)JavadocUtil.extractJavadocVersion(outOutput));
        }
        throw new IllegalArgumentException("No output found from the command line 'javadoc -J-version'");
    }

    protected static String extractJavadocVersion(String output) throws IllegalArgumentException {
        if (output == null || output.isEmpty()) {
            throw new IllegalArgumentException("The output could not be null.");
        }
        Pattern pattern = EXTRACT_JAVADOC_VERSION_PATTERN;
        Matcher matcher = pattern.matcher(output);
        if (!matcher.matches()) {
            throw new PatternSyntaxException("Unrecognized version of Javadoc: '" + output + "'", pattern.pattern(), pattern.toString().length() - 1);
        }
        return matcher.group(1);
    }

    protected static String parseJavadocMemory(String memory) throws IllegalArgumentException {
        if (memory == null || memory.isEmpty()) {
            throw new IllegalArgumentException("The memory could not be null.");
        }
        Matcher m0 = PARSE_JAVADOC_MEMORY_PATTERN_0.matcher(memory);
        if (m0.matches()) {
            return m0.group(1) + "m";
        }
        Matcher m1 = PARSE_JAVADOC_MEMORY_PATTERN_1.matcher(memory);
        if (m1.matches()) {
            return m1.group(1) + "k";
        }
        Matcher m2 = PARSE_JAVADOC_MEMORY_PATTERN_2.matcher(memory);
        if (m2.matches()) {
            return m2.group(1) + "m";
        }
        Matcher m3 = PARSE_JAVADOC_MEMORY_PATTERN_3.matcher(memory);
        if (m3.matches()) {
            return Integer.parseInt(m3.group(1)) * 1024 + "m";
        }
        Matcher m4 = PARSE_JAVADOC_MEMORY_PATTERN_4.matcher(memory);
        if (m4.matches()) {
            return Integer.parseInt(m4.group(1)) * 1024 * 1024 + "m";
        }
        throw new IllegalArgumentException("Could convert not to a memory size: " + memory);
    }

    protected static boolean validateEncoding(String charsetName) {
        if (charsetName == null || charsetName.isEmpty()) {
            return false;
        }
        try {
            return Charset.isSupported(charsetName);
        }
        catch (IllegalCharsetNameException e) {
            return false;
        }
    }

    protected static List<String> getTagletClassNames(File jarFile) throws IOException, ClassNotFoundException, NoClassDefFoundError {
        Class<?> tagletClass;
        List<String> classes = JavadocUtil.getClassNamesFromJar(jarFile);
        File tools = new File(System.getProperty("java.home"), "../lib/tools.jar");
        URLClassLoader cl = tools.exists() && tools.isFile() ? new URLClassLoader(new URL[]{jarFile.toURI().toURL(), tools.toURI().toURL()}, null) : new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, ClassLoader.getSystemClassLoader());
        ArrayList<String> tagletClasses = new ArrayList<String>();
        try {
            tagletClass = cl.loadClass("com.sun.tools.doclets.Taglet");
        }
        catch (ClassNotFoundException e) {
            tagletClass = cl.loadClass("jdk.javadoc.doclet.Taglet");
        }
        for (String s : classes) {
            Class<?> c = cl.loadClass(s);
            if (!tagletClass.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
            tagletClasses.add(c.getName());
        }
        try {
            cl.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tagletClasses;
    }

    protected static void copyResource(URL url, File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("The file can't be null.");
        }
        if (url == null) {
            throw new NullPointerException("The url could not be null.");
        }
        FileUtils.copyURLToFile((URL)url, (File)file);
    }

    protected static void invokeMaven(Log log, File localRepositoryDir, File projectFile, List<String> goals, Properties properties, File invokerLog, File globalSettingsFile, File userSettingsFile, File globalToolchainsFile, File userToolchainsFile) throws MavenInvocationException {
        String invokerLogContent;
        InvocationResult result;
        File javaHome;
        if (projectFile == null) {
            throw new IllegalArgumentException("projectFile should be not null.");
        }
        if (!projectFile.isFile()) {
            throw new IllegalArgumentException(projectFile.getAbsolutePath() + " is not a file.");
        }
        if (goals == null || goals.size() == 0) {
            throw new IllegalArgumentException("goals should be not empty.");
        }
        if (localRepositoryDir == null || !localRepositoryDir.isDirectory()) {
            throw new IllegalArgumentException("localRepositoryDir '" + localRepositoryDir + "' should be a directory.");
        }
        String mavenHome = JavadocUtil.getMavenHome(log);
        if (mavenHome == null || mavenHome.isEmpty()) {
            String msg = "Could NOT invoke Maven because no Maven Home is defined. You need to have set the M2_HOME system env variable or a maven.home Java system properties.";
            if (log != null) {
                log.error((CharSequence)msg);
            } else {
                System.err.println(msg);
            }
            return;
        }
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(mavenHome));
        invoker.setLocalRepositoryDirectory(localRepositoryDir);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setBaseDirectory(projectFile.getParentFile());
        request.setPomFile(projectFile);
        if (globalSettingsFile != null && globalSettingsFile.isFile()) {
            request.setGlobalSettingsFile(globalSettingsFile);
        }
        if (userSettingsFile != null && userSettingsFile.isFile()) {
            request.setUserSettingsFile(userSettingsFile);
        }
        if (globalToolchainsFile != null && globalToolchainsFile.isFile()) {
            request.setGlobalToolchainsFile(globalToolchainsFile);
        }
        if (userToolchainsFile != null && userToolchainsFile.isFile()) {
            request.setToolchainsFile(userToolchainsFile);
        }
        request.setBatchMode(true);
        if (log != null) {
            request.setDebug(log.isDebugEnabled());
        } else {
            request.setDebug(true);
        }
        request.setGoals(goals);
        if (properties != null) {
            request.setProperties(properties);
        }
        if ((javaHome = JavadocUtil.getJavaHome(log)) != null) {
            request.setJavaHome(javaHome);
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug((CharSequence)("Invoking Maven for the goals: " + goals + " with " + (properties == null ? "no properties" : "properties=" + properties)));
        }
        if ((result = JavadocUtil.invoke(log, (Invoker)invoker, (InvocationRequest)request, invokerLog, goals, properties, null)).getExitCode() != 0 && (invokerLogContent = JavadocUtil.readFile(invokerLog, "UTF-8")) != null && (!invokerLogContent.contains("Scanning for projects...") || invokerLogContent.contains(OutOfMemoryError.class.getName()))) {
            if (log != null) {
                log.error((CharSequence)"Error occurred during initialization of VM, trying to use an empty MAVEN_OPTS...");
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("Reinvoking Maven for the goals: " + goals + " with an empty MAVEN_OPTS..."));
                }
            }
            result = JavadocUtil.invoke(log, (Invoker)invoker, (InvocationRequest)request, invokerLog, goals, properties, "");
        }
        if (result.getExitCode() != 0) {
            invokerLogContent = JavadocUtil.readFile(invokerLog, "UTF-8");
            if (invokerLogContent != null && (!invokerLogContent.contains("Scanning for projects...") || invokerLogContent.contains(OutOfMemoryError.class.getName()))) {
                throw new MavenInvocationException(ERROR_INIT_VM);
            }
            throw new MavenInvocationException("Error when invoking Maven, consult the invoker log file: " + invokerLog.getAbsolutePath());
        }
    }

    protected static String readFile(File javaFile, String encoding) {
        try {
            return FileUtils.fileRead((File)javaFile, (String)encoding);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected static String[] splitPath(String path) {
        if (path == null) {
            return null;
        }
        ArrayList<String> subpaths = new ArrayList<String>();
        PathTokenizer pathTokenizer = new PathTokenizer(path);
        while (pathTokenizer.hasMoreTokens()) {
            subpaths.add(pathTokenizer.nextToken());
        }
        return subpaths.toArray(new String[subpaths.size()]);
    }

    protected static String unifyPathSeparator(String path) {
        if (path == null) {
            return null;
        }
        return String.join((CharSequence)File.pathSeparator, JavadocUtil.splitPath(path));
    }

    private static List<String> getClassNamesFromJar(File jarFile) throws IOException {
        if (jarFile == null || !jarFile.exists() || !jarFile.isFile()) {
            throw new IOException("The jar '" + jarFile + "' doesn't exist or is not a file.");
        }
        ArrayList<String> classes = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(?i)^(META-INF/versions/(?<v>[0-9]+)/)?(?<n>.+)[.]class$");
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(jarFile));){
            JarEntry jarEntry = jarStream.getNextJarEntry();
            while (jarEntry != null) {
                String version;
                Matcher matcher = pattern.matcher(jarEntry.getName());
                if (matcher.matches() && ((version = matcher.group("v")) == null || version.isEmpty() || JavaVersion.JAVA_VERSION.isAtLeast(version))) {
                    String name = matcher.group("n");
                    classes.add(name.replaceAll("/", "\\."));
                }
                jarStream.closeEntry();
                jarEntry = jarStream.getNextJarEntry();
            }
        }
        return classes;
    }

    private static InvocationResult invoke(Log log, Invoker invoker, InvocationRequest request, File invokerLog, List<String> goals, Properties properties, String mavenOpts) throws MavenInvocationException {
        InvocationResult invocationResult;
        block19: {
            PrintStream ps;
            FileOutputStream os = null;
            if (invokerLog != null) {
                if (log != null && log.isDebugEnabled()) {
                    log.debug((CharSequence)("Using " + invokerLog.getAbsolutePath() + " to log the invoker"));
                }
                try {
                    if (!invokerLog.exists()) {
                        invokerLog.getParentFile().mkdirs();
                    }
                    os = new FileOutputStream(invokerLog);
                    ps = new PrintStream((OutputStream)os, true, "UTF-8");
                }
                catch (FileNotFoundException e) {
                    if (log != null && log.isErrorEnabled()) {
                        log.error((CharSequence)("FileNotFoundException: " + e.getMessage() + ". Using System.out to log the invoker."));
                    }
                    ps = System.out;
                }
                catch (UnsupportedEncodingException e) {
                    if (log != null && log.isErrorEnabled()) {
                        log.error((CharSequence)("UnsupportedEncodingException: " + e.getMessage() + ". Using System.out to log the invoker."));
                    }
                    ps = System.out;
                }
            } else {
                if (log != null && log.isDebugEnabled()) {
                    log.debug((CharSequence)"Using System.out to log the invoker.");
                }
                ps = System.out;
            }
            if (mavenOpts != null) {
                request.setMavenOpts(mavenOpts);
            }
            PrintStreamHandler outputHandler = new PrintStreamHandler(ps, false);
            request.setOutputHandler((InvocationOutputHandler)outputHandler);
            FileOutputStream closeMe = os;
            try {
                outputHandler.consumeLine("Invoking Maven for the goals: " + goals + " with " + (properties == null ? "no properties" : "properties=" + properties));
                outputHandler.consumeLine("");
                outputHandler.consumeLine("M2_HOME=" + JavadocUtil.getMavenHome(log));
                outputHandler.consumeLine("MAVEN_OPTS=" + JavadocUtil.getMavenOpts(log));
                outputHandler.consumeLine("JAVA_HOME=" + JavadocUtil.getJavaHome(log));
                outputHandler.consumeLine("JAVA_OPTS=" + JavadocUtil.getJavaOpts(log));
                outputHandler.consumeLine("");
                invocationResult = invoker.execute(request);
                if (closeMe == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (closeMe != null) {
                        try {
                            ((OutputStream)closeMe).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new MavenInvocationException("IOException while consuming invocation output", (Throwable)ioe);
                }
            }
            ((OutputStream)closeMe).close();
        }
        return invocationResult;
    }

    private static String getMavenHome(Log log) {
        String mavenHome = System.getProperty("maven.home");
        File m2Home = new File(mavenHome);
        if (!m2Home.exists() && log != null && log.isErrorEnabled()) {
            log.error((CharSequence)"Cannot find Maven application directory. Either specify 'maven.home' system property.");
        }
        return mavenHome;
    }

    private static String getMavenOpts(Log log) {
        return CommandLineUtils.getSystemEnvVars().getProperty("MAVEN_OPTS");
    }

    private static File getJavaHome(Log log) {
        File javaHome = null;
        String javaHomeValue = CommandLineUtils.getSystemEnvVars().getProperty("JAVA_HOME");
        if (System.getProperty("maven.home") == null || javaHomeValue == null) {
            javaHome = SystemUtils.IS_OS_MAC_OSX || JavaVersion.JAVA_VERSION.isAtLeast("9") ? SystemUtils.getJavaHome() : new File(SystemUtils.getJavaHome(), "..");
        }
        if (javaHome == null || !javaHome.exists()) {
            javaHome = new File(javaHomeValue);
        }
        if ((javaHome == null || !javaHome.exists()) && log != null && log.isErrorEnabled()) {
            log.error((CharSequence)"Cannot find Java application directory. Either specify 'java.home' system property, or JAVA_HOME environment variable.");
        }
        return javaHome;
    }

    private static String getJavaOpts(Log log) {
        return CommandLineUtils.getSystemEnvVars().getProperty("JAVA_OPTS");
    }

    static List<String> toList(String src) {
        return JavadocUtil.toList(src, null, null);
    }

    static List<String> toList(String src, String elementPrefix, String elementSuffix) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(src, "[,:;]");
        StringBuilder sb = new StringBuilder(256);
        while (st.hasMoreTokens()) {
            sb.setLength(0);
            if (elementPrefix != null && !elementPrefix.isEmpty()) {
                sb.append(elementPrefix);
            }
            sb.append(st.nextToken());
            if (elementSuffix != null && !elementSuffix.isEmpty()) {
                sb.append(elementSuffix);
            }
            result.add(sb.toString());
        }
        return result;
    }

    static <T> List<T> toList(T[] multiple) {
        return JavadocUtil.toList(null, multiple);
    }

    static <T> List<T> toList(T single, T[] multiple) {
        if (single == null && (multiple == null || multiple.length < 1)) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        if (single != null) {
            result.add(single);
        }
        if (multiple != null && multiple.length > 0) {
            result.addAll(Arrays.asList(multiple));
        }
        return result;
    }

    public static String toRelative(File basedir, String absolutePath) {
        String relative;
        String basedirPath;
        if ((absolutePath = absolutePath.replace('\\', '/')).startsWith(basedirPath = basedir.getAbsolutePath().replace('\\', '/'))) {
            relative = absolutePath.substring(basedirPath.length());
            if (relative.startsWith("/")) {
                relative = relative.substring(1);
            }
            if (relative.length() <= 0) {
                relative = ".";
            }
        } else {
            relative = absolutePath;
        }
        return relative;
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    protected static URL getRedirectUrl(URL url, Settings settings) throws IOException {
        String protocol = url.getProtocol();
        if (!"http".equals(protocol) && !"https".equals(protocol)) {
            return url;
        }
        try (CloseableHttpClient httpClient = JavadocUtil.createHttpClient(settings, url);){
            HttpClientContext httpContext = HttpClientContext.create();
            HttpGet httpMethod = new HttpGet(url.toString());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpMethod, (HttpContext)httpContext);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new FileNotFoundException("Unexpected HTTP status code " + status + " getting resource " + url.toExternalForm() + ".");
            }
            List redirects = httpContext.getRedirectLocations();
            if (JavadocUtil.isEmpty(redirects)) {
                URL uRL = url;
                return uRL;
            }
            URI last = (URI)redirects.get(redirects.size() - 1);
            String truncate = "index.html";
            if (last.getPath().endsWith("/" + truncate)) {
                try {
                    String fixedPath = last.getPath().substring(0, last.getPath().length() - truncate.length());
                    last = new URI(last.getScheme(), last.getAuthority(), fixedPath, last.getQuery(), last.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            URL uRL = last.toURL();
            return uRL;
        }
    }

    protected static boolean isValidPackageList(URL url, Settings settings, boolean validateContent) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("The url is null");
        }
        try (BufferedReader reader = JavadocUtil.getReader(url, settings);){
            if (validateContent) {
                String line = reader.readLine();
                while (line != null) {
                    if (!JavadocUtil.isValidPackageName(line)) {
                        boolean bl = false;
                        return bl;
                    }
                    line = reader.readLine();
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    protected static boolean isValidElementList(URL url, Settings settings, boolean validateContent) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("The url is null");
        }
        try (BufferedReader reader = JavadocUtil.getReader(url, settings);){
            if (validateContent) {
                String line = reader.readLine();
                while (line != null) {
                    if (!line.startsWith("module:") && !JavadocUtil.isValidPackageName(line)) {
                        boolean bl = false;
                        return bl;
                    }
                    line = reader.readLine();
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    private static BufferedReader getReader(URL url, Settings settings) throws IOException {
        BufferedReader reader = null;
        if ("file".equals(url.getProtocol())) {
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
        } else {
            CloseableHttpResponse response;
            final CloseableHttpClient httpClient = JavadocUtil.createHttpClient(settings, url);
            final HttpGet httpMethod = new HttpGet(url.toString());
            HttpClientContext httpContext = HttpClientContext.create();
            try {
                response = httpClient.execute((HttpUriRequest)httpMethod, (HttpContext)httpContext);
            }
            catch (SocketTimeoutException e) {
                response = httpClient.execute((HttpUriRequest)httpMethod, (HttpContext)httpContext);
            }
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new FileNotFoundException("Unexpected HTTP status code " + status + " getting resource " + url.toExternalForm() + ".");
            }
            int pos = url.getPath().lastIndexOf(47);
            List redirects = httpContext.getRedirectLocations();
            if (pos >= 0 && JavadocUtil.isNotEmpty(redirects)) {
                URI location = (URI)redirects.get(redirects.size() - 1);
                String suffix = url.getPath().substring(pos);
                if (!location.getPath().endsWith(suffix)) {
                    throw new FileNotFoundException(url.toExternalForm() + " redirects to " + location.toURL().toExternalForm() + ".");
                }
            }
            reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent())){

                @Override
                public void close() throws IOException {
                    super.close();
                    if (httpMethod != null) {
                        httpMethod.releaseConnection();
                    }
                    if (httpClient != null) {
                        httpClient.close();
                    }
                }
            };
        }
        return reader;
    }

    private static boolean isValidPackageName(String str) {
        int idx;
        if (str == null || str.isEmpty()) {
            return true;
        }
        while ((idx = str.indexOf(46)) != -1) {
            if (!JavadocUtil.isValidClassName(str.substring(0, idx))) {
                return false;
            }
            str = str.substring(idx + 1);
        }
        return JavadocUtil.isValidClassName(str);
    }

    private static boolean isValidClassName(String str) {
        if (str == null || str.isEmpty() || !Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = str.length() - 1; i > 0; --i) {
            if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static CloseableHttpClient createHttpClient(Settings settings, URL url) {
        HttpClientBuilder builder = HttpClients.custom();
        Registry csfRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSystemSocketFactory()).build();
        builder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(csfRegistry));
        builder.setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(2000).setConnectTimeout(2000).setCircularRedirectsAllowed(true).setCookieSpec("ignoreCookies").build());
        builder.setUserAgent("Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        builder.setDefaultHeaders(Arrays.asList(new BasicHeader("Accept", "*/*")));
        if (settings != null && settings.getActiveProxy() != null) {
            Proxy activeProxy = settings.getActiveProxy();
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.setNonProxyHosts(activeProxy.getNonProxyHosts());
            String activeProxyHost = activeProxy.getHost();
            if (!(activeProxyHost == null || activeProxyHost.isEmpty() || url != null && ProxyUtils.validateNonProxyHosts((ProxyInfo)proxyInfo, (String)url.getHost()))) {
                HttpHost proxy = new HttpHost(activeProxy.getHost(), activeProxy.getPort());
                builder.setProxy(proxy);
                String activeProxyUsername = activeProxy.getUsername();
                if (activeProxyUsername != null && !activeProxyUsername.isEmpty() && activeProxy.getPassword() != null) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(activeProxyUsername, activeProxy.getPassword());
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                    builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
            }
        }
        return builder.build();
    }

    static boolean equalsIgnoreCase(String value, String ... strings) {
        for (String s : strings) {
            if (!s.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    static boolean equals(String value, String ... strings) {
        for (String s : strings) {
            if (!s.equals(value)) continue;
            return true;
        }
        return false;
    }

    protected static class JavadocOutputStreamConsumer
    extends CommandLineUtils.StringStreamConsumer {
        protected JavadocOutputStreamConsumer() {
        }

        public void consumeLine(String line) {
            if (!line.startsWith("Picked up ")) {
                super.consumeLine(line);
            }
        }
    }

    private static class PathTokenizer {
        private StringTokenizer tokenizer;
        private String lookahead = null;
        private boolean dosStyleFilesystem;

        PathTokenizer(String path) {
            this.tokenizer = new StringTokenizer(path, ":;", false);
            this.dosStyleFilesystem = File.pathSeparatorChar == ';';
        }

        public boolean hasMoreTokens() {
            return this.lookahead != null || this.tokenizer.hasMoreTokens();
        }

        public String nextToken() throws NoSuchElementException {
            String token;
            if (this.lookahead != null) {
                token = this.lookahead;
                this.lookahead = null;
            } else {
                token = this.tokenizer.nextToken().trim();
            }
            if (token.length() == 1 && Character.isLetter(token.charAt(0)) && this.dosStyleFilesystem && this.tokenizer.hasMoreTokens()) {
                String nextToken = this.tokenizer.nextToken().trim();
                if (nextToken.startsWith("\\") || nextToken.startsWith("/")) {
                    token = token + ":" + nextToken;
                } else {
                    this.lookahead = nextToken;
                }
            }
            return token;
        }
    }
}

