// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.9.1,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.plugins.invoker.model;

/**
 * 
 *         Describes a build job processed by the Maven Invoker
 * Plugin. A build job can consist of a pre-build hook script,
 *         one ore more invocations of Maven and a post-build hook
 * script.
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class BuildJob
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The path to the project to build. This path is usually
     * relative and can denote both a POM file or a project
     * directory.
     */
    private String project;

    /**
     * The name of this build job.
     */
    private String name;

    /**
     * The description of this build job.
     */
    private String description;

    /**
     * The result of this build job.
     */
    private String result;

    /**
     * Any failure message(s) in case this build job failed.
     */
    private String failureMessage;

    /**
     * The number of seconds that this build job took to complete.
     */
    private double time = 0.0;

    /**
     * The type of the build job.
     */
    private String type;

    /**
     * BuildJobs will be sorted in the descending order of the
     * ordinal. In other words, the BuildJobs with the highest
     * numbers will be executed first.
     */
    private int ordinal = 0;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the description of this build job.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription()

    /**
     * Get any failure message(s) in case this build job failed.
     * 
     * @return String
     */
    public String getFailureMessage()
    {
        return this.failureMessage;
    } //-- String getFailureMessage()

    /**
     * Get the modelEncoding field.
     * 
     * @return String
     */
    public String getModelEncoding()
    {
        return this.modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Get the name of this build job.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Get buildJobs will be sorted in the descending order of the
     * ordinal. In other words, the BuildJobs with the highest
     * numbers will be executed first.
     * 
     * @return int
     */
    public int getOrdinal()
    {
        return this.ordinal;
    } //-- int getOrdinal()

    /**
     * Get the path to the project to build. This path is usually
     * relative and can denote both a POM file or a project
     * directory.
     * 
     * @return String
     */
    public String getProject()
    {
        return this.project;
    } //-- String getProject()

    /**
     * Get the result of this build job.
     * 
     * @return String
     */
    public String getResult()
    {
        return this.result;
    } //-- String getResult()

    /**
     * Get the number of seconds that this build job took to
     * complete.
     * 
     * @return double
     */
    public double getTime()
    {
        return this.time;
    } //-- double getTime()

    /**
     * Get the type of the build job.
     * 
     * @return String
     */
    public String getType()
    {
        return this.type;
    } //-- String getType()

    /**
     * Set the description of this build job.
     * 
     * @param description
     */
    public void setDescription( String description )
    {
        this.description = description;
    } //-- void setDescription( String )

    /**
     * Set any failure message(s) in case this build job failed.
     * 
     * @param failureMessage
     */
    public void setFailureMessage( String failureMessage )
    {
        this.failureMessage = failureMessage;
    } //-- void setFailureMessage( String )

    /**
     * Set the modelEncoding field.
     * 
     * @param modelEncoding
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set the name of this build job.
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set buildJobs will be sorted in the descending order of the
     * ordinal. In other words, the BuildJobs with the highest
     * numbers will be executed first.
     * 
     * @param ordinal
     */
    public void setOrdinal( int ordinal )
    {
        this.ordinal = ordinal;
    } //-- void setOrdinal( int )

    /**
     * Set the path to the project to build. This path is usually
     * relative and can denote both a POM file or a project
     * directory.
     * 
     * @param project
     */
    public void setProject( String project )
    {
        this.project = project;
    } //-- void setProject( String )

    /**
     * Set the result of this build job.
     * 
     * @param result
     */
    public void setResult( String result )
    {
        this.result = result;
    } //-- void setResult( String )

    /**
     * Set the number of seconds that this build job took to
     * complete.
     * 
     * @param time
     */
    public void setTime( double time )
    {
        this.time = time;
    } //-- void setTime( double )

    /**
     * Set the type of the build job.
     * 
     * @param type
     */
    public void setType( String type )
    {
        this.type = type;
    } //-- void setType( String )

    
    /**
     * Creates a new empty build job.
     */
    public BuildJob()
    {
        // enables no-arg construction
    }

    /**
     * Creates a new build job with the specified project path and type.
     * 
     * @param project The path to the project.
     * @param type The type of the build job.
     */
    public BuildJob( String project, String type )
    {
        this.project = project;
        this.type = type;
    }
          
    
    /**
     * The various results with which a build job can complete.
     */
    public static class Result
    {

        /**
         * The result value corresponding with a successful invocation of Maven and completion of all post-hook scripts.
         */
        public static final String SUCCESS = "success";

        /**
         * The result value corresponding with an invocation that failed before Maven was be invoked.
         */
        public static final String FAILURE_PRE_HOOK = "failure-pre-hook";

        /**
         * The result value corresponding with an invocation that failed while invoking of Maven.
         */
        public static final String FAILURE_BUILD = "failure-build";

        /**
         * The result value corresponding with an invocation that failed after the invocation of Maven.
         */
        public static final String FAILURE_POST_HOOK = "failure-post-hook";

        /**
         * The result value corresponding with an invocation that was skipped.
         */
        public static final String SKIPPED = "skipped";

        /**
         * The result value corresponding with an unexpected error trying to invoke Maven.
         */
        public static final String ERROR = "error";

    }
          
    
    /**
     * The various types of a build job.
     */
    public static class Type
    {

        /**
         * A build job that should be invoked before any non-setup build jobs.
         */
        public static final String SETUP = "setup";

        /**
         * A normal build job.
         */
        public static final String NORMAL = "normal";

        /**
         * A build job that was directly selected via the <code>-Dinvoker.test=xxx,yyy</code> parameter.
         */
        public static final String DIRECT = "direct";

    }
          
    
    public String toString()
    {
        StringBuffer buf = new StringBuffer( 128 );
        buf.append( "BuildJob[project = \"" );
        buf.append( project );
        buf.append( "\", type = " );
        buf.append( type );
        buf.append( ']' );
        return buf.toString();
    }
          
}
