/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.invoker.model.BuildJob;
import org.apache.maven.plugin.logging.Log;

class InvokerSession {
    private List buildJobs;
    private List failedJobs;
    private List errorJobs;
    private List successfulJobs;
    private List skippedJobs;

    public InvokerSession() {
        this.buildJobs = new ArrayList();
    }

    public InvokerSession(BuildJob[] buildJobs) {
        this.buildJobs = new ArrayList<BuildJob>(Arrays.asList(buildJobs));
    }

    public void addJob(BuildJob buildJob) {
        this.buildJobs.add(buildJob);
        this.resetStats();
    }

    public void setJobs(List buildJobs) {
        this.buildJobs = new ArrayList(buildJobs);
        this.resetStats();
    }

    public List getJobs() {
        return this.buildJobs;
    }

    public List getSuccessfulJobs() {
        this.updateStats();
        return this.successfulJobs;
    }

    public List getFailedJobs() {
        this.updateStats();
        return this.failedJobs;
    }

    public List getErrorJobs() {
        this.updateStats();
        return this.errorJobs;
    }

    public List getSkippedJobs() {
        this.updateStats();
        return this.skippedJobs;
    }

    private void resetStats() {
        this.successfulJobs = null;
        this.failedJobs = null;
        this.skippedJobs = null;
        this.errorJobs = null;
    }

    private void updateStats() {
        if (this.successfulJobs != null && this.skippedJobs != null && this.failedJobs != null && this.errorJobs != null) {
            return;
        }
        this.successfulJobs = new ArrayList();
        this.failedJobs = new ArrayList();
        this.skippedJobs = new ArrayList();
        this.errorJobs = new ArrayList();
        Iterator iterator = this.buildJobs.iterator();
        while (iterator.hasNext()) {
            BuildJob buildJob = (BuildJob)iterator.next();
            if ("success".equals(buildJob.getResult())) {
                this.successfulJobs.add(buildJob);
                continue;
            }
            if ("skipped".equals(buildJob.getResult())) {
                this.skippedJobs.add(buildJob);
                continue;
            }
            if ("error".equals(buildJob.getResult())) {
                this.errorJobs.add(buildJob);
                continue;
            }
            if (buildJob.getResult() == null) continue;
            this.failedJobs.add(buildJob);
        }
    }

    public void logSummary(Log logger, boolean ignoreFailures) {
        this.updateStats();
        String separator = "-------------------------------------------------";
        logger.info((CharSequence)separator);
        logger.info((CharSequence)"Build Summary:");
        logger.info((CharSequence)("  Passed: " + this.successfulJobs.size() + ", Failed: " + this.failedJobs.size() + ", Errors: " + this.errorJobs.size() + ", Skipped: " + this.skippedJobs.size()));
        logger.info((CharSequence)separator);
        if (!this.failedJobs.isEmpty()) {
            String heading = "The following builds failed:";
            if (ignoreFailures) {
                logger.warn((CharSequence)heading);
            } else {
                logger.error((CharSequence)heading);
            }
            Iterator it = this.failedJobs.iterator();
            while (it.hasNext()) {
                BuildJob buildJob = (BuildJob)it.next();
                String item = "*  " + buildJob.getProject();
                if (ignoreFailures) {
                    logger.warn((CharSequence)item);
                    continue;
                }
                logger.error((CharSequence)item);
            }
            logger.info((CharSequence)separator);
        }
    }

    public void handleFailures(Log logger, boolean ignoreFailures) throws MojoFailureException {
        String message;
        this.updateStats();
        if (!this.failedJobs.isEmpty()) {
            message = this.failedJobs.size() + " build" + (this.failedJobs.size() == 1 ? "" : "s") + " failed.";
            if (ignoreFailures) {
                logger.warn((CharSequence)("Ignoring that " + message));
            } else {
                throw new MojoFailureException((Object)this, message, message);
            }
        }
        if (!this.errorJobs.isEmpty()) {
            message = this.errorJobs.size() + " build" + (this.errorJobs.size() == 1 ? "" : "s") + " in error.";
            if (ignoreFailures) {
                logger.warn((CharSequence)("Ignoring that " + message));
            } else {
                throw new MojoFailureException((Object)this, message, message);
            }
        }
    }
}

