/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.idea;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.idea.IdeaXmlWriter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class AbstractIdeaMojo
extends AbstractMojo {
    protected MavenProject executedProject;
    protected Log log;
    protected boolean overwrite;
    protected ArtifactFactory artifactFactory;
    protected ArtifactRepository localRepo;
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetadataSource;

    public void initParam(MavenProject project, ArtifactFactory artifactFactory, ArtifactRepository localRepo, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, Log log, boolean overwrite) {
        this.executedProject = project;
        this.log = log;
        this.artifactFactory = artifactFactory;
        this.localRepo = localRepo;
        this.artifactResolver = artifactResolver;
        this.artifactMetadataSource = artifactMetadataSource;
        this.overwrite = overwrite;
    }

    protected Document readXmlDocument(File file, String altFilename) throws DocumentException {
        SAXReader reader = new SAXReader();
        if (file.exists() && !this.overwrite) {
            return reader.read(file);
        }
        File altFile = new File(this.executedProject.getBasedir(), "src/main/idea/" + altFilename);
        if (altFile.exists()) {
            return reader.read(altFile);
        }
        return reader.read(((Object)((Object)this)).getClass().getResourceAsStream("/templates/default/" + altFilename));
    }

    protected void writeXmlDocument(File file, Document document) throws IOException {
        IdeaXmlWriter writer = new IdeaXmlWriter(file);
        writer.write(document);
        writer.close();
    }

    protected Element findComponent(Element module, String name) {
        return this.findElement(module, "component", name);
    }

    protected Element findElement(Element element, String elementName, String attributeName) {
        Iterator children = element.elementIterator(elementName);
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!attributeName.equals(child.attributeValue("name"))) continue;
            return child;
        }
        return this.createElement(element, elementName).addAttribute("name", attributeName);
    }

    protected Element findElement(Element component, String name) {
        Element element = component.element(name);
        if (element == null) {
            element = this.createElement(component, name);
        }
        return element;
    }

    protected Element createElement(Element module, String name) {
        return module.addElement(name);
    }

    protected String toRelative(String basedir, String absolutePath) {
        String relative;
        String matchableBasedir;
        String convertedBasedir = this.convertDriveLetter(basedir);
        String convertedAbsolutePath = this.convertDriveLetter(absolutePath);
        convertedBasedir = StringUtils.replace((String)convertedBasedir, (String)"\\", (String)"/");
        convertedAbsolutePath = StringUtils.replace((String)convertedAbsolutePath, (String)"\\", (String)"/");
        if (convertedBasedir.endsWith("/")) {
            convertedBasedir = convertedBasedir.substring(0, convertedBasedir.length() - 1);
        }
        if (convertedAbsolutePath.endsWith("/")) {
            convertedAbsolutePath = convertedAbsolutePath.substring(0, convertedAbsolutePath.length() - 1);
        }
        if (convertedAbsolutePath.startsWith(matchableBasedir = convertedBasedir + "/") && convertedAbsolutePath.length() > matchableBasedir.length()) {
            relative = convertedAbsolutePath.substring(matchableBasedir.length());
        } else {
            StringTokenizer baseTokens = new StringTokenizer(convertedBasedir, "/", false);
            int baseCount = baseTokens.countTokens();
            ArrayList<String> baseTokenList = new ArrayList<String>(baseCount);
            while (baseTokens.hasMoreTokens()) {
                baseTokenList.add(baseTokens.nextToken());
            }
            StringTokenizer pathTokens = new StringTokenizer(convertedAbsolutePath, "/", false);
            int pathCount = pathTokens.countTokens();
            ArrayList<String> pathTokenList = new ArrayList<String>(pathCount);
            while (pathTokens.hasMoreTokens()) {
                pathTokenList.add(pathTokens.nextToken());
            }
            int maxCount = Math.max(baseTokenList.size(), pathTokenList.size());
            int differIndex = -1;
            for (int i = 0; i < maxCount; ++i) {
                String pathPart;
                if (i >= pathTokenList.size() || i >= baseTokenList.size()) {
                    differIndex = i;
                    break;
                }
                String basePart = (String)baseTokenList.get(i);
                if (basePart.equals(pathPart = (String)pathTokenList.get(i))) continue;
                differIndex = i;
                break;
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Construction of relative path... differIndex=" + differIndex));
            }
            if (differIndex < 1) {
                relative = convertedAbsolutePath;
            } else {
                int i;
                StringBuffer result = new StringBuffer();
                int parentCount = baseTokenList.size() - differIndex;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("parentCount=" + parentCount));
                }
                boolean isFirst = true;
                for (i = 0; i < parentCount; ++i) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        result.append("/");
                    }
                    result.append("..");
                }
                for (i = differIndex; i < pathTokenList.size(); ++i) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        result.append("/");
                    }
                    result.append(pathTokenList.get(i));
                }
                relative = result.toString();
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("toRelative(" + basedir + ", " + absolutePath + ") => " + relative));
        }
        return relative;
    }

    String convertDriveLetter(String absolutePath) {
        if (absolutePath != null && absolutePath.length() >= 3 && !absolutePath.startsWith("/") && Character.isLetter(absolutePath.substring(0, 1).charAt(0)) && absolutePath.substring(1, 3).equals(":\\")) {
            return absolutePath.substring(0, 1).toUpperCase() + absolutePath.substring(1);
        }
        return absolutePath;
    }

    protected void removeOldElements(Element content, String name) {
        Iterator children = content.elementIterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!name.equals(child.getName())) continue;
            content.remove(child);
        }
    }

    protected void doDependencyResolution(MavenProject project, ArtifactRepository localRepo) throws InvalidDependencyVersionException, ProjectBuildingException, InvalidVersionSpecificationException, ArtifactNotFoundException, ArtifactResolutionException {
        Map managedVersions = this.createManagedVersionMap(this.artifactFactory, project.getId(), project.getDependencyManagement());
        try {
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(this.getProjectArtifacts(), project.getArtifact(), managedVersions, localRepo, project.getRemoteArtifactRepositories(), this.artifactMetadataSource);
            project.setArtifacts(result.getArtifacts());
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
            StringBuffer msg = new StringBuffer();
            msg.append("An error occurred during dependency resolution.\n\n");
            msg.append("    Failed to retrieve " + e.getDownloadUrl() + "\n");
            msg.append("from the following repositories:");
            Iterator repositories = e.getRemoteRepositories().iterator();
            while (repositories.hasNext()) {
                ArtifactRepository repository = (ArtifactRepository)repositories.next();
                msg.append("\n    " + repository.getId() + "(" + repository.getUrl() + ")");
            }
            msg.append("\nCaused by: " + e.getMessage());
            this.getLog().warn((CharSequence)msg);
            throw e;
        }
        catch (ArtifactResolutionException e) {
            this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
            StringBuffer msg = new StringBuffer();
            msg.append("An error occurred during dependency resolution of the following artifact:\n\n");
            msg.append("    " + e.getGroupId() + ":" + e.getArtifactId() + e.getVersion() + "\n\n");
            msg.append("Caused by: " + e.getMessage());
            this.getLog().warn((CharSequence)msg);
            throw e;
        }
    }

    protected String getPluginSetting(String artifactId, String optionName, String defaultValue) {
        Iterator it = this.executedProject.getBuildPlugins().iterator();
        while (it.hasNext()) {
            Xpp3Dom o;
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getArtifactId().equals(artifactId) || (o = (Xpp3Dom)plugin.getConfiguration()) == null || o.getChild(optionName) == null) continue;
            return o.getChild(optionName).getValue();
        }
        return defaultValue;
    }

    private Set getProjectArtifacts() throws InvalidVersionSpecificationException {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Iterator dependencies = this.executedProject.getDependencies().iterator();
        while (dependencies.hasNext()) {
            Dependency dep = (Dependency)dependencies.next();
            String groupId = dep.getGroupId();
            String artifactId = dep.getArtifactId();
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)dep.getVersion());
            String type = dep.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dep.getClassifier();
            boolean optional = dep.isOptional();
            String scope = dep.getScope();
            if (scope == null) {
                scope = "compile";
            }
            Artifact artifact = this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, optional);
            if (scope.equalsIgnoreCase("system")) {
                artifact.setFile(new File(dep.getSystemPath()));
            }
            ArrayList<String> exclusions = new ArrayList<String>();
            Iterator j = dep.getExclusions().iterator();
            while (j.hasNext()) {
                Exclusion e = (Exclusion)j.next();
                exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
            }
            ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
            artifact.setDependencyFilter((ArtifactFilter)newFilter);
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private Map createManagedVersionMap(ArtifactFactory artifactFactory, String projectId, DependencyManagement dependencyManagement) throws ProjectBuildingException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            Iterator i = dependencyManagement.getDependencies().iterator();
            while (i.hasNext()) {
                Dependency d = (Dependency)i.next();
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = super.getLog();
        }
        return this.log;
    }
}

