/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.surefire.failsafe.model.FailsafeSummary;
import org.apache.maven.surefire.failsafe.model.io.xpp3.FailsafeSummaryXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class VerifyMojo
extends AbstractMojo {
    private boolean skipTests;
    private boolean skipITs;
    private boolean skipExec;
    private boolean skip;
    private boolean testFailureIgnore;
    private File basedir;
    private File testClassesDirectory;
    private File reportsDirectory;
    private File summaryFile;
    private Boolean failIfNoTests;
    protected String encoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.verifyParameters()) {
            int result;
            this.getLog().info((CharSequence)("Failsafe report directory: " + this.reportsDirectory));
            try {
                String encoding;
                if (StringUtils.isEmpty((String)this.encoding)) {
                    this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
                    encoding = ReaderFactory.FILE_ENCODING;
                } else {
                    encoding = this.encoding;
                }
                FileInputStream fos = new FileInputStream(this.summaryFile);
                BufferedInputStream bos = new BufferedInputStream(fos);
                InputStreamReader w = new InputStreamReader((InputStream)bos, encoding);
                FailsafeSummaryXpp3Reader reader = new FailsafeSummaryXpp3Reader();
                FailsafeSummary summary = reader.read(w);
                result = summary.getResult();
                ((Reader)w).close();
                bos.close();
                fos.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (result == 0) {
                return;
            }
            if (result == 254) {
                if (this.failIfNoTests == null || !this.failIfNoTests.booleanValue()) {
                    return;
                }
                throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
            }
            String msg = "There are test failures.\n\nPlease refer to " + this.reportsDirectory + " for the individual test results.";
            if (this.testFailureIgnore) {
                this.getLog().error((CharSequence)msg);
            } else {
                throw new MojoFailureException(msg);
            }
        }
    }

    private boolean verifyParameters() throws MojoFailureException {
        if (this.skip || this.skipTests || this.skipITs || this.skipExec) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return false;
        }
        if (!this.testClassesDirectory.exists()) {
            if (this.failIfNoTests != null && this.failIfNoTests.booleanValue()) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getLog().info((CharSequence)"No tests to run.");
            return false;
        }
        return true;
    }
}

