/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.surefire.booter.ForkConfiguration;
import org.apache.maven.surefire.booter.SurefireBooter;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.failsafe.model.FailsafeSummary;
import org.apache.maven.surefire.failsafe.model.io.xpp3.FailsafeSummaryXpp3Writer;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class IntegrationTestMojo
extends AbstractMojo {
    private boolean skipTests;
    private boolean skipITs;
    private boolean skipExec;
    private boolean skip;
    private File basedir;
    private File testClassesDirectory;
    private File classesDirectory;
    protected MavenProject project;
    private List classpathElements;
    private List additionalClasspathElements;
    private File reportsDirectory;
    private File testSourceDirectory;
    private String test;
    private List includes;
    private List excludes;
    private ArtifactRepository localRepository;
    private Properties systemProperties;
    private Map systemPropertyVariables;
    private Properties properties;
    private Map pluginArtifactMap;
    private Map projectArtifactMap;
    private File summaryFile;
    private boolean printSummary;
    private String reportFormat;
    private boolean useFile;
    private boolean redirectTestOutputToFile;
    private Boolean failIfNoTests;
    private String forkMode;
    private String jvm;
    private String argLine;
    private String debugForkedProcess;
    private int forkedProcessTimeoutInSeconds;
    private Map environmentVariables = new HashMap();
    private File workingDirectory;
    private boolean childDelegation;
    private String groups;
    private String excludedGroups;
    private File[] suiteXmlFiles;
    private String junitArtifactName;
    private String testNGArtifactName;
    private int threadCount;
    private String perCoreThreadCount;
    private String useUnlimitedThreads;
    private String parallel;
    private boolean trimStackTrace;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private List remoteRepositories;
    private ArtifactMetadataSource metadataSource;
    private static final String BRIEF_REPORT_FORMAT = "brief";
    private static final String PLAIN_REPORT_FORMAT = "plain";
    private Properties originalSystemProperties;
    private Properties internalSystemProperties = new Properties();
    private boolean disableXmlReport;
    private Boolean useSystemClassLoader;
    private boolean useManifestOnlyJar;
    private boolean enableAssertions;
    private MavenSession session;
    private String objectFactory;
    protected String encoding;
    private ToolchainManager toolchainManager;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$ForkingConsoleReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$ConsoleReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$BriefFileReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$FileReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$BriefConsoleReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$DetailedConsoleReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$XMLReporter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.verifyParameters()) {
            SurefireBooter surefireBooter = this.constructSurefireBooter();
            this.getLog().info((CharSequence)("Failsafe report directory: " + this.reportsDirectory));
            FailsafeSummary result = new FailsafeSummary();
            try {
                result.setResult(surefireBooter.run());
            }
            catch (SurefireBooterForkException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            catch (SurefireExecutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (this.originalSystemProperties != null && !surefireBooter.isForking()) {
                System.setProperties(this.originalSystemProperties);
            }
            if (!this.summaryFile.getParentFile().isDirectory()) {
                this.summaryFile.getParentFile().mkdirs();
            }
            try {
                String encoding;
                if (StringUtils.isEmpty((String)this.encoding)) {
                    this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
                    encoding = ReaderFactory.FILE_ENCODING;
                } else {
                    encoding = this.encoding;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(this.summaryFile);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedOutputStream, encoding);
                FailsafeSummaryXpp3Writer xpp3Writer = new FailsafeSummaryXpp3Writer();
                xpp3Writer.write(writer, result);
                ((Writer)writer).close();
                bufferedOutputStream.close();
                fileOutputStream.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    private boolean verifyParameters() throws MojoFailureException {
        if (this.skip || this.skipTests || this.skipITs || this.skipExec) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return false;
        }
        if (!this.testClassesDirectory.exists()) {
            if (this.failIfNoTests != null && this.failIfNoTests.booleanValue()) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getLog().info((CharSequence)"No tests to run.");
            return false;
        }
        if (this.useSystemClassLoader != null && "never".equals(this.forkMode)) {
            this.getLog().warn((CharSequence)"useSystemClassloader setting has no effect when not forking");
        }
        return true;
    }

    private void convertTestNGParameters() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.parallel != null) {
            this.properties.setProperty("parallel", this.parallel);
        }
        if (this.excludedGroups != null) {
            this.properties.setProperty("excludegroups", this.excludedGroups);
        }
        if (this.groups != null) {
            this.properties.setProperty("groups", this.groups);
        }
        if (this.threadCount > 0) {
            this.properties.setProperty("threadcount", new Integer(this.threadCount).toString());
        }
        if (this.objectFactory != null) {
            this.properties.setProperty("objectfactory", this.objectFactory);
        }
    }

    private boolean isAnyConcurrencySelected() {
        return this.parallel != null && this.parallel.trim().length() > 0;
    }

    private void convertJunitCoreParameters() {
        Artifact configurableParallelComputer;
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.parallel != null) {
            this.properties.setProperty("parallel", this.parallel);
        }
        if (this.threadCount > 0) {
            this.properties.setProperty("threadCount", new Integer(this.threadCount).toString());
        }
        if (this.perCoreThreadCount != null) {
            this.properties.setProperty("perCoreThreadCount", this.perCoreThreadCount);
        }
        if (this.useUnlimitedThreads != null) {
            this.properties.setProperty("useUnlimitedThreads", this.useUnlimitedThreads);
        }
        this.properties.setProperty("configurableParallelComputerPresent", Boolean.toString((configurableParallelComputer = (Artifact)this.projectArtifactMap.get("org.jdogma.junit:configurable-parallel-computer")) != null));
    }

    private boolean isJunit47Compatible(Artifact artifact) throws MojoExecutionException {
        return this.isWithinVersionSpec(artifact, "[4.7,)");
    }

    private boolean isAnyJunit4(Artifact artifact) throws MojoExecutionException {
        return this.isWithinVersionSpec(artifact, "[4.0,)");
    }

    private boolean isWithinVersionSpec(Artifact artifact, String versionSpec) throws MojoExecutionException {
        if (artifact == null) {
            return false;
        }
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)versionSpec);
            try {
                return range.containsVersion(artifact.getSelectedVersion());
            }
            catch (NullPointerException e) {
                return range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getBaseVersion()));
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Bug in junit 4.7 plugin. Please report with stacktrace");
        }
        catch (OverConstrainedVersionException e) {
            throw new MojoExecutionException("Bug in junit 4.7 plugin. Please report with stacktrace");
        }
    }

    private SurefireBooter constructSurefireBooter() throws MojoExecutionException, MojoFailureException {
        File projectTestClassesDirectory;
        Artifact testNgArtifact;
        Artifact junitArtifact;
        SurefireBooter surefireBooter = new SurefireBooter();
        Artifact surefireArtifact = (Artifact)this.pluginArtifactMap.get("org.apache.maven.surefire:surefire-booter");
        if (surefireArtifact == null) {
            throw new MojoExecutionException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        surefireArtifact.isSnapshot();
        try {
            this.addArtifact(surefireBooter, surefireArtifact);
            junitArtifact = (Artifact)this.projectArtifactMap.get(this.junitArtifactName);
            if (junitArtifact == null && "junit:junit".equals(this.junitArtifactName)) {
                junitArtifact = (Artifact)this.projectArtifactMap.get("junit:junit-dep");
            }
            if ((testNgArtifact = (Artifact)this.projectArtifactMap.get(this.testNGArtifactName)) != null) {
                VersionRange range = VersionRange.createFromVersionSpec((String)"[4.7,)");
                if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(testNgArtifact.getVersion()))) {
                    throw new MojoFailureException("TestNG support requires version 4.7 or above. You have declared version " + testNgArtifact.getVersion());
                }
                this.convertTestNGParameters();
                if (this.testClassesDirectory != null) {
                    this.properties.setProperty("testng.test.classpath", this.testClassesDirectory.getAbsolutePath());
                }
                this.addArtifact(surefireBooter, testNgArtifact);
                this.addProvider(surefireBooter, "surefire-testng", surefireArtifact.getBaseVersion(), testNgArtifact);
            } else if (junitArtifact != null && this.isAnyJunit4(junitArtifact)) {
                if (this.isAnyConcurrencySelected() && this.isJunit47Compatible(junitArtifact)) {
                    this.convertJunitCoreParameters();
                    this.addProvider(surefireBooter, "surefire-junit47", surefireArtifact.getBaseVersion(), null);
                } else {
                    this.addProvider(surefireBooter, "surefire-junit4", surefireArtifact.getBaseVersion(), null);
                }
            } else {
                this.addProvider(surefireBooter, "surefire-junit", surefireArtifact.getBaseVersion(), null);
            }
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to locate required surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Error determining the TestNG version requested: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error to resolving surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.suiteXmlFiles != null && this.suiteXmlFiles.length > 0 && this.test == null) {
            if (testNgArtifact == null) {
                throw new MojoExecutionException("suiteXmlFiles is configured, but there is no TestNG dependency");
            }
            surefireBooter.addTestSuite("org.apache.maven.surefire.testng.TestNGXmlTestSuite", new Object[]{this.suiteXmlFiles, this.testSourceDirectory.getAbsolutePath(), testNgArtifact.getVersion(), testNgArtifact.getClassifier(), this.properties, this.reportsDirectory});
        } else {
            String junitDirectoryTestSuite;
            ArrayList<Object> excludes;
            ArrayList<Object> includes;
            if (this.test != null) {
                includes = new ArrayList();
                excludes = new ArrayList();
                if (this.failIfNoTests == null) {
                    this.failIfNoTests = Boolean.TRUE;
                }
                String[] testRegexes = StringUtils.split((String)this.test, (String)",");
                for (int i = 0; i < testRegexes.length; ++i) {
                    String testRegex = testRegexes[i];
                    if (testRegex.endsWith(".java")) {
                        testRegex = testRegex.substring(0, testRegex.length() - 5);
                    }
                    testRegex = testRegex.replace('.', '/');
                    includes.add("**/" + testRegex + ".java");
                }
            } else {
                includes = this.includes;
                excludes = this.excludes;
                if (includes == null || includes.size() == 0) {
                    includes = new ArrayList<String>(Arrays.asList("**/IT*.java", "**/*IT.java", "**/*ITCase.java"));
                }
                if (excludes == null || excludes.size() == 0) {
                    excludes = new ArrayList<String>(Arrays.asList("**/*$*"));
                }
            }
            if (testNgArtifact != null) {
                surefireBooter.addTestSuite("org.apache.maven.surefire.testng.TestNGDirectoryTestSuite", new Object[]{this.testClassesDirectory, includes, excludes, this.testSourceDirectory.getAbsolutePath(), testNgArtifact.getVersion(), testNgArtifact.getClassifier(), this.properties, this.reportsDirectory});
            } else if (this.isAnyConcurrencySelected() && this.isJunit47Compatible(junitArtifact)) {
                junitDirectoryTestSuite = "org.apache.maven.surefire.junitcore.JUnitCoreDirectoryTestSuite";
                this.getLog().info((CharSequence)("Concurrency config is " + this.properties.toString()));
                surefireBooter.addTestSuite(junitDirectoryTestSuite, new Object[]{this.testClassesDirectory, includes, excludes, this.properties});
            } else {
                junitDirectoryTestSuite = this.isAnyJunit4(junitArtifact) ? "org.apache.maven.surefire.junit4.JUnit4DirectoryTestSuite" : "org.apache.maven.surefire.junit.JUnitDirectoryTestSuite";
                surefireBooter.addTestSuite(junitDirectoryTestSuite, new Object[]{this.testClassesDirectory, includes, excludes});
            }
        }
        File projectClassesDirectory = new File(this.project.getBuild().getOutputDirectory());
        if (!projectClassesDirectory.equals(this.classesDirectory)) {
            int indexToReplace = this.classpathElements.indexOf(this.project.getBuild().getOutputDirectory());
            if (indexToReplace != -1) {
                this.classpathElements.remove(indexToReplace);
                this.classpathElements.add(indexToReplace, this.classesDirectory.getAbsolutePath());
            } else {
                this.classpathElements.add(1, this.classesDirectory.getAbsolutePath());
            }
        }
        if (!(projectTestClassesDirectory = new File(this.project.getBuild().getTestOutputDirectory())).equals(this.testClassesDirectory)) {
            int indexToReplace = this.classpathElements.indexOf(this.project.getBuild().getTestOutputDirectory());
            if (indexToReplace != -1) {
                this.classpathElements.remove(indexToReplace);
                this.classpathElements.add(indexToReplace, this.testClassesDirectory.getAbsolutePath());
            } else {
                this.classpathElements.add(0, this.testClassesDirectory.getAbsolutePath());
            }
        }
        this.getLog().debug((CharSequence)"Test Classpath :");
        Iterator i = this.classpathElements.iterator();
        while (i.hasNext()) {
            String classpathElement = (String)i.next();
            this.getLog().debug((CharSequence)("  " + classpathElement));
            surefireBooter.addClassPathUrl(classpathElement);
        }
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in failsafe-plugin: " + tc));
            if ("never".equals(this.forkMode)) {
                this.forkMode = "once";
            }
            if (this.jvm != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.jvm));
            } else {
                this.jvm = tc.findTool("java");
            }
        }
        if (this.additionalClasspathElements != null) {
            Iterator i2 = this.additionalClasspathElements.iterator();
            while (i2.hasNext()) {
                String classpathElement = (String)i2.next();
                this.getLog().debug((CharSequence)("  " + classpathElement));
                surefireBooter.addClassPathUrl(classpathElement);
            }
        }
        ForkConfiguration fork = new ForkConfiguration();
        fork.setForkMode(this.forkMode);
        this.processSystemProperties(!fork.isForking());
        if (this.getLog().isDebugEnabled()) {
            this.showMap(this.internalSystemProperties, "system property");
        }
        if (fork.isForking()) {
            List<String> args;
            this.useSystemClassLoader = this.useSystemClassLoader == null ? Boolean.TRUE : this.useSystemClassLoader;
            fork.setUseSystemClassLoader(this.useSystemClassLoader.booleanValue());
            fork.setUseManifestOnlyJar(this.useManifestOnlyJar);
            fork.setSystemProperties(this.internalSystemProperties);
            if ("true".equals(this.debugForkedProcess)) {
                this.debugForkedProcess = "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005";
            }
            fork.setDebugLine(this.debugForkedProcess);
            if (this.jvm == null || "".equals(this.jvm)) {
                this.jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                this.getLog().debug((CharSequence)("Using JVM: " + this.jvm));
            }
            fork.setJvmExecutable(this.jvm);
            if (this.workingDirectory != null) {
                fork.setWorkingDirectory(this.workingDirectory);
            } else {
                fork.setWorkingDirectory(this.basedir);
            }
            fork.setArgLine(this.argLine);
            fork.setEnvironmentVariables(this.environmentVariables);
            if (this.getLog().isDebugEnabled()) {
                this.showMap(this.environmentVariables, "environment variable");
                fork.setDebug(true);
            }
            if (this.argLine != null && ((args = Arrays.asList(this.argLine.split(" "))).contains("-da") || args.contains("-disableassertions"))) {
                this.enableAssertions = false;
            }
        }
        surefireBooter.setFailIfNoTests(this.failIfNoTests == null ? false : this.failIfNoTests);
        surefireBooter.setForkedProcessTimeoutInSeconds(this.forkedProcessTimeoutInSeconds);
        surefireBooter.setRedirectTestOutputToFile(this.redirectTestOutputToFile);
        surefireBooter.setForkConfiguration(fork);
        surefireBooter.setChildDelegation(this.childDelegation);
        surefireBooter.setEnableAssertions(this.enableAssertions);
        surefireBooter.setReportsDirectory(this.reportsDirectory);
        this.addReporters(surefireBooter, fork.isForking());
        return surefireBooter;
    }

    private void showMap(Map map, String setting) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)map.get(key);
            this.getLog().debug((CharSequence)("Setting " + setting + " [" + key + "]=[" + value + "]"));
        }
    }

    private void addProvider(SurefireBooter surefireBooter, String provider, String version, Artifact filteredArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        Artifact providerArtifact = this.artifactFactory.createDependencyArtifact("org.apache.maven.surefire", provider, VersionRange.createFromVersion((String)version), "jar", null, "test");
        ArtifactResolutionResult result = this.resolveArtifact(filteredArtifact, providerArtifact);
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().debug((CharSequence)("Adding to surefire test classpath: " + artifact.getFile().getAbsolutePath()));
            surefireBooter.addSurefireClassPathUrl(artifact.getFile().getAbsolutePath());
        }
    }

    private ArtifactResolutionResult resolveArtifact(Artifact filteredArtifact, Artifact providerArtifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        ExcludesArtifactFilter filter = null;
        if (filteredArtifact != null) {
            filter = new ExcludesArtifactFilter(Collections.singletonList(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId()));
        }
        Artifact originatingArtifact = this.artifactFactory.createBuildArtifact("dummy", "dummy", "1.0", "jar");
        return this.artifactResolver.resolveTransitively(Collections.singleton(providerArtifact), originatingArtifact, this.localRepository, this.remoteRepositories, this.metadataSource, (ArtifactFilter)filter);
    }

    private void addArtifact(SurefireBooter surefireBooter, Artifact surefireArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArtifactResolutionResult result = this.resolveArtifact(null, surefireArtifact);
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().debug((CharSequence)("Adding to surefire booter test classpath: " + artifact.getFile().getAbsolutePath()));
            surefireBooter.addSurefireBootClassPathUrl(artifact.getFile().getAbsolutePath());
        }
    }

    protected void processSystemProperties(boolean setInSystem) {
        String value;
        String key;
        Iterator<Object> i;
        if (this.systemProperties != null) {
            i = this.systemProperties.keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                value = (String)this.systemProperties.get(key);
                this.internalSystemProperties.setProperty(key, value);
            }
        }
        if (this.systemPropertyVariables != null) {
            i = this.systemPropertyVariables.keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                value = (String)this.systemPropertyVariables.get(key);
                if (value == null) continue;
                this.internalSystemProperties.setProperty(key, value);
            }
        }
        this.originalSystemProperties = (Properties)System.getProperties().clone();
        Properties userSpecifiedProperties = (Properties)this.session.getExecutionProperties().clone();
        userSpecifiedProperties.putAll((Map<?, ?>)this.internalSystemProperties);
        this.internalSystemProperties.setProperty("basedir", this.basedir.getAbsolutePath());
        this.internalSystemProperties.setProperty("user.dir", this.workingDirectory.getAbsolutePath());
        this.internalSystemProperties.setProperty("localRepository", this.localRepository.getBasedir());
        if (setInSystem) {
            Iterator<Object> iter = this.internalSystemProperties.keySet().iterator();
            while (iter.hasNext()) {
                String key2 = (String)iter.next();
                String value2 = this.internalSystemProperties.getProperty(key2);
                System.setProperty(key2, value2);
            }
        }
    }

    private void addReporters(SurefireBooter surefireBooter, boolean forking) {
        Boolean trimStackTrace = this.trimStackTrace;
        if (this.useFile) {
            if (this.printSummary) {
                if (forking) {
                    surefireBooter.addReport((class$org$apache$maven$surefire$report$ForkingConsoleReporter == null ? (class$org$apache$maven$surefire$report$ForkingConsoleReporter = IntegrationTestMojo.class$("org.apache.maven.surefire.report.ForkingConsoleReporter")) : class$org$apache$maven$surefire$report$ForkingConsoleReporter).getName(), new Object[]{trimStackTrace});
                } else {
                    surefireBooter.addReport((class$org$apache$maven$surefire$report$ConsoleReporter == null ? (class$org$apache$maven$surefire$report$ConsoleReporter = IntegrationTestMojo.class$("org.apache.maven.surefire.report.ConsoleReporter")) : class$org$apache$maven$surefire$report$ConsoleReporter).getName(), new Object[]{trimStackTrace});
                }
            }
            if (BRIEF_REPORT_FORMAT.equals(this.reportFormat)) {
                surefireBooter.addReport((class$org$apache$maven$surefire$report$BriefFileReporter == null ? (class$org$apache$maven$surefire$report$BriefFileReporter = IntegrationTestMojo.class$("org.apache.maven.surefire.report.BriefFileReporter")) : class$org$apache$maven$surefire$report$BriefFileReporter).getName(), new Object[]{this.reportsDirectory, trimStackTrace});
            } else if (PLAIN_REPORT_FORMAT.equals(this.reportFormat)) {
                surefireBooter.addReport((class$org$apache$maven$surefire$report$FileReporter == null ? (class$org$apache$maven$surefire$report$FileReporter = IntegrationTestMojo.class$("org.apache.maven.surefire.report.FileReporter")) : class$org$apache$maven$surefire$report$FileReporter).getName(), new Object[]{this.reportsDirectory, trimStackTrace});
            }
        } else if (BRIEF_REPORT_FORMAT.equals(this.reportFormat)) {
            surefireBooter.addReport((class$org$apache$maven$surefire$report$BriefConsoleReporter == null ? (class$org$apache$maven$surefire$report$BriefConsoleReporter = IntegrationTestMojo.class$("org.apache.maven.surefire.report.BriefConsoleReporter")) : class$org$apache$maven$surefire$report$BriefConsoleReporter).getName(), new Object[]{trimStackTrace});
        } else if (PLAIN_REPORT_FORMAT.equals(this.reportFormat)) {
            surefireBooter.addReport((class$org$apache$maven$surefire$report$DetailedConsoleReporter == null ? (class$org$apache$maven$surefire$report$DetailedConsoleReporter = IntegrationTestMojo.class$("org.apache.maven.surefire.report.DetailedConsoleReporter")) : class$org$apache$maven$surefire$report$DetailedConsoleReporter).getName(), new Object[]{trimStackTrace});
        }
        if (!this.disableXmlReport) {
            surefireBooter.addReport((class$org$apache$maven$surefire$report$XMLReporter == null ? (class$org$apache$maven$surefire$report$XMLReporter = IntegrationTestMojo.class$("org.apache.maven.surefire.report.XMLReporter")) : class$org$apache$maven$surefire$report$XMLReporter).getName(), new Object[]{this.reportsDirectory, trimStackTrace});
        }
    }

    public boolean isSkipExec() {
        return this.skipTests;
    }

    public void setSkipExec(boolean skipExec) {
        this.skipTests = skipExec;
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

