/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.Summary;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.failsafe.model.FailsafeSummary;
import org.apache.maven.surefire.failsafe.model.io.xpp3.FailsafeSummaryXpp3Reader;
import org.apache.maven.surefire.failsafe.model.io.xpp3.FailsafeSummaryXpp3Writer;
import org.apache.maven.surefire.suite.RunResult;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="integration-test", requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.INTEGRATION_TEST, threadSafe=true)
public class IntegrationTestMojo
extends AbstractSurefireMojo {
    private static final String FAILSAFE_IN_PROGRESS_CONTEXT_KEY = "failsafe-in-progress";
    @Parameter(property="skipITs")
    private boolean skipITs;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports")
    private File reportsDirectory;
    @Parameter(property="it.test")
    private String test;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports/failsafe-summary.xml", required=true)
    private File summaryFile;
    @Parameter(property="failsafe.printSummary", defaultValue="true")
    private boolean printSummary;
    @Parameter(property="failsafe.reportFormat", defaultValue="brief")
    private String reportFormat;
    @Parameter(property="failsafe.useFile", defaultValue="true")
    private boolean useFile;
    @Parameter(property="it.failIfNoSpecifiedTests")
    private Boolean failIfNoSpecifiedTests;
    @Parameter(property="maven.failsafe.debug")
    private String debugForkedProcess;
    @Parameter(property="failsafe.timeout")
    private int forkedProcessTimeoutInSeconds;
    private Properties originalSystemProperties;
    private Properties internalSystemProperties = new Properties();
    @Parameter(property="failsafe.useSystemClassLoader", defaultValue="true")
    private boolean useSystemClassLoader;
    @Parameter(property="failsafe.useManifestOnlyJar", defaultValue="true")
    private boolean useManifestOnlyJar;
    @Parameter(property="encoding", defaultValue="${project.reporting.outputEncoding}")
    private String encoding;

    protected void handleSummary(Summary summary) throws MojoExecutionException, MojoFailureException {
        FailsafeSummary failsafeSummary = this.createFailsafeSummaryFromSummary(summary);
        this.writeSummary(failsafeSummary);
    }

    private FailsafeSummary createFailsafeSummaryFromSummary(Summary summary) {
        FailsafeSummary failsafeSummary = new FailsafeSummary();
        if (summary.isErrorFree()) {
            RunResult result = summary.getResultOfLastSuccessfulRun();
            if (result != null) {
                failsafeSummary.setResult(result.getForkedProcessCode());
            }
        } else {
            failsafeSummary.setResult(255);
            failsafeSummary.setException(summary.getFirstException().getMessage());
        }
        return failsafeSummary;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSummary(FailsafeSummary summary) throws MojoExecutionException {
        File summaryFile = this.getSummaryFile();
        if (!summaryFile.getParentFile().isDirectory()) {
            summaryFile.getParentFile().mkdirs();
        }
        FileOutputStream fout = null;
        FileInputStream fin = null;
        try {
            FailsafeSummary mergedSummary = summary;
            Object token = this.getPluginContext().get(FAILSAFE_IN_PROGRESS_CONTEXT_KEY);
            if (summaryFile.exists() && token != null) {
                fin = new FileInputStream(summaryFile);
                mergedSummary = new FailsafeSummaryXpp3Reader().read(new InputStreamReader((InputStream)new BufferedInputStream(fin), this.getEncodingOrDefault()));
                mergedSummary.merge(summary);
            }
            fout = new FileOutputStream(summaryFile);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fout);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedOutputStream, this.getEncodingOrDefault());
            FailsafeSummaryXpp3Writer xpp3Writer = new FailsafeSummaryXpp3Writer();
            xpp3Writer.write(writer, mergedSummary);
            ((Writer)writer).close();
            bufferedOutputStream.close();
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
                catch (XmlPullParserException e2) {
                    throw new MojoExecutionException(e2.getMessage(), (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(fin);
                IOUtil.close(fout);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)fin);
        IOUtil.close((OutputStream)fout);
        this.getPluginContext().put(FAILSAFE_IN_PROGRESS_CONTEXT_KEY, FAILSAFE_IN_PROGRESS_CONTEXT_KEY);
    }

    private String getEncodingOrDefault() {
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            return ReaderFactory.FILE_ENCODING;
        }
        return this.encoding;
    }

    protected boolean isSkipExecution() {
        return this.isSkip() || this.isSkipTests() || this.isSkipITs() || this.isSkipExec();
    }

    protected String getPluginName() {
        return "failsafe";
    }

    protected String[] getDefaultIncludes() {
        return new String[]{"**/IT*.java", "**/*IT.java", "**/*ITCase.java"};
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public boolean isSkipITs() {
        return this.skipITs;
    }

    public void setSkipITs(boolean skipITs) {
        this.skipITs = skipITs;
    }

    public boolean isSkipExec() {
        return this.skipExec;
    }

    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public List<String> getClasspathDependencyExcludes() {
        return this.classpathDependencyExcludes;
    }

    public void setClasspathDependencyExcludes(List<String> classpathDependencyExcludes) {
        this.classpathDependencyExcludes = classpathDependencyExcludes;
    }

    public String getClasspathDependencyScopeExclude() {
        return this.classpathDependencyScopeExclude;
    }

    public void setClasspathDependencyScopeExclude(String classpathDependencyScopeExclude) {
        this.classpathDependencyScopeExclude = classpathDependencyScopeExclude;
    }

    public List<String> getAdditionalClasspathElements() {
        return this.additionalClasspathElements;
    }

    public void setAdditionalClasspathElements(List<String> additionalClasspathElements) {
        this.additionalClasspathElements = additionalClasspathElements;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public String getTest() {
        if (StringUtils.isBlank((String)this.test)) {
            return null;
        }
        int index = this.test.indexOf(35);
        if (index >= 0) {
            return this.test.substring(0, index);
        }
        return this.test;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public String getTestMethod() {
        if (StringUtils.isBlank((String)this.test)) {
            return null;
        }
        int index = this.test.indexOf(35);
        if (index >= 0) {
            return this.test.substring(index + 1, this.test.length());
        }
        return null;
    }

    public File getSummaryFile() {
        return this.summaryFile;
    }

    public void setSummaryFile(File summaryFile) {
        this.summaryFile = summaryFile;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    public String getDebugForkedProcess() {
        return this.debugForkedProcess;
    }

    public void setDebugForkedProcess(String debugForkedProcess) {
        this.debugForkedProcess = debugForkedProcess;
    }

    public int getForkedProcessTimeoutInSeconds() {
        return this.forkedProcessTimeoutInSeconds;
    }

    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    public boolean isUseSystemClassLoader() {
        return this.useSystemClassLoader;
    }

    public void setUseSystemClassLoader(boolean useSystemClassLoader) {
        this.useSystemClassLoader = useSystemClassLoader;
    }

    public boolean isUseManifestOnlyJar() {
        return this.useManifestOnlyJar;
    }

    public void setUseManifestOnlyJar(boolean useManifestOnlyJar) {
        this.useManifestOnlyJar = useManifestOnlyJar;
    }

    public boolean isTestFailureIgnore() {
        return true;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
    }

    protected void addPluginSpecificChecksumItems(ChecksumCalculator checksum) {
        checksum.add(this.skipITs);
        checksum.add(this.summaryFile);
    }

    public Boolean getFailIfNoSpecifiedTests() {
        return this.failIfNoSpecifiedTests;
    }

    public void setFailIfNoSpecifiedTests(Boolean failIfNoSpecifiedTests) {
        this.failIfNoSpecifiedTests = failIfNoSpecifiedTests;
    }
}

