/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ejb;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public class EjbMojo
extends AbstractMojo {
    private static final String EJB_JAR_XML = "META-INF/ejb-jar.xml";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_EXCLUDES = new String[]{"META-INF/ejb-jar.xml", "**/package.html"};
    private static final String[] DEFAULT_CLIENT_EXCLUDES = new String[]{"**/*Bean.class", "**/*CMP.class", "**/*Session.class", "**/package.html"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private File basedir;
    private File outputDirectory;
    private String jarName;
    private String classifier;
    private boolean generateClient;
    private List clientExcludes;
    private List clientIncludes;
    private List excludes;
    private MavenProject project;
    private JarArchiver jarArchiver;
    private String ejbVersion;
    private JarArchiver clientJarArchiver;
    private MavenProjectHelper projectHelper;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private boolean escapeBackslashesInFilePath;
    protected String escapeString;
    private boolean filterDeploymentDescriptor;
    private List filters;
    private MavenFileFilter mavenFileFilter;
    private MavenSession session;

    public void execute() throws MojoExecutionException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Building EJB " + this.jarName + " with EJB version " + this.ejbVersion));
        }
        File jarFile = EjbMojo.getEJBJarFile(this.basedir, this.jarName, this.classifier);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        File deploymentDescriptor = new File(this.outputDirectory, EJB_JAR_XML);
        if (!this.ejbVersion.matches("\\A[2-3]\\.[0-9]\\z")) {
            throw new MojoExecutionException("ejbVersion is not valid: " + this.ejbVersion + ". Must be 2.x or 3.x (where x is a digit)");
        }
        if (this.ejbVersion.matches("\\A2\\.[0-9]\\z") && !deploymentDescriptor.exists()) {
            throw new MojoExecutionException("Error assembling EJB: META-INF/ejb-jar.xml is required for ejbVersion 2.x");
        }
        try {
            String[] mainJarExcludes = DEFAULT_EXCLUDES;
            if (this.excludes != null && !this.excludes.isEmpty()) {
                this.excludes.add(EJB_JAR_XML);
                mainJarExcludes = this.excludes.toArray(EMPTY_STRING_ARRAY);
            }
            archiver.getArchiver().addDirectory(this.outputDirectory, DEFAULT_INCLUDES, mainJarExcludes);
            if (deploymentDescriptor.exists()) {
                if (this.filterDeploymentDescriptor) {
                    this.getLog().debug((CharSequence)"Filtering deployment descriptor.");
                    MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
                    mavenResourcesExecution.setEscapeString(this.escapeString);
                    List filterWrappers = this.mavenFileFilter.getDefaultFilterWrappers(this.project, this.filters, this.escapeBackslashesInFilePath, this.session, mavenResourcesExecution);
                    File unfilteredDeploymentDescriptor = new File(this.outputDirectory, "META-INF/ejb-jar.xml.unfiltered");
                    FileUtils.copyFile((File)deploymentDescriptor, (File)unfilteredDeploymentDescriptor);
                    this.mavenFileFilter.copyFile(unfilteredDeploymentDescriptor, deploymentDescriptor, true, filterWrappers, this.getEncoding(unfilteredDeploymentDescriptor));
                    FileUtils.forceDelete((File)unfilteredDeploymentDescriptor);
                }
                archiver.getArchiver().addFile(deploymentDescriptor, EJB_JAR_XML);
            }
            archiver.createArchive(this.project, this.archive);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("There was a problem filtering the deployment descriptor: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "ejb", this.classifier, jarFile);
        } else {
            this.project.getArtifact().setFile(jarFile);
        }
        if (this.generateClient) {
            String clientJarName = this.jarName;
            if (this.classifier != null) {
                clientJarName = clientJarName + "-" + this.classifier;
            }
            this.getLog().info((CharSequence)("Building EJB client " + clientJarName + "-client"));
            String[] excludes = DEFAULT_CLIENT_EXCLUDES;
            String[] includes = DEFAULT_INCLUDES;
            if (this.clientIncludes != null && !this.clientIncludes.isEmpty()) {
                includes = this.clientIncludes.toArray(EMPTY_STRING_ARRAY);
            }
            if (this.clientExcludes != null && !this.clientExcludes.isEmpty()) {
                excludes = this.clientExcludes.toArray(EMPTY_STRING_ARRAY);
            }
            File clientJarFile = new File(this.basedir, clientJarName + "-client.jar");
            MavenArchiver clientArchiver = new MavenArchiver();
            clientArchiver.setArchiver(this.clientJarArchiver);
            clientArchiver.setOutputFile(clientJarFile);
            try {
                clientArchiver.getArchiver().addDirectory(this.outputDirectory, includes, excludes);
                clientArchiver.createArchive(this.project, this.archive);
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (ManifestException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)e);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
            }
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.project, "ejb-client", this.classifier + "-client", clientJarFile);
            } else {
                this.projectHelper.attachArtifact(this.project, "ejb-client", "client", clientJarFile);
            }
        }
    }

    private static File getEJBJarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".jar");
    }

    private String getEncoding(File xmlFile) throws IOException {
        XmlStreamReader xmlReader = new XmlStreamReader(xmlFile);
        return xmlReader.getEncoding();
    }
}

