/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.BuildCommand;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseAntExternalLaunchConfigurationWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseClasspathWriter
extends AbstractEclipseWriter {
    private static final String ORG_ECLIPSE_AJDT_INPATH = "org.eclipse.ajdt.inpath";
    private static final String ORG_ECLIPSE_AJDT_ASPECTPATH = "org.eclipse.ajdt.aspectpath";
    private static final String ASPECTJRT_CONTAINER = "org.eclipse.ajdt.core.ASPECTJRT_CONTAINER";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String ATTRIBUTE = "attribute";
    private static final String ATTRIBUTES = "attributes";
    protected static final String M2_REPO = "M2_REPO";
    private static final String ATTR_SOURCEPATH = "sourcepath";
    private static final String ATTR_OUTPUT = "output";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_KIND = "kind";
    private static final String ATTR_VAR = "var";
    private static final String ATTR_LIB = "lib";
    private static final String ATTR_SRC = "src";
    private static final String ATTR_INCLUDING = "including";
    private static final String ATTR_EXCLUDING = "excluding";
    private static final String ELT_CLASSPATHENTRY = "classpathentry";
    private static final String ELT_CLASSPATH = "classpath";
    private static final String FILE_DOT_CLASSPATH = ".classpath";

    public void write() throws MojoExecutionException {
        String depId;
        IdeDependency dep;
        int j;
        EclipseSourceDir dir;
        int j2;
        OutputStreamWriter w;
        try {
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.config.getEclipseProjectDirectory(), FILE_DOT_CLASSPATH)), "UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        writer.startElement(ELT_CLASSPATH);
        String defaultOutput = IdeUtils.toRelativeAndFixSeparator(this.config.getProjectBaseDir(), this.config.getBuildOutputDirectory(), false);
        ArrayList<EclipseSourceDir> specialSources = new ArrayList<EclipseSourceDir>();
        HashMap<String, ArrayList<EclipseSourceDir>> byOutputDir = new HashMap<String, ArrayList<EclipseSourceDir>>();
        for (j2 = 0; j2 < this.config.getSourceDirs().length; ++j2) {
            dir = this.config.getSourceDirs()[j2];
            ArrayList<EclipseSourceDir> byOutputDirs = (ArrayList<EclipseSourceDir>)byOutputDir.get(dir.getOutput());
            if (byOutputDirs == null) {
                byOutputDirs = new ArrayList<EclipseSourceDir>();
                byOutputDir.put(dir.getOutput() == null ? defaultOutput : dir.getOutput(), byOutputDirs);
            }
            byOutputDirs.add(dir);
        }
        for (j2 = 0; j2 < this.config.getSourceDirs().length; ++j2) {
            String excludes;
            String includes;
            dir = this.config.getSourceDirs()[j2];
            this.log.debug((CharSequence)("Processing classpath for: " + dir.toString() + "; default output=" + defaultOutput));
            boolean isSpecial = false;
            if (dir.isResource() && dir.getOutput() != null && !dir.getOutput().equals(defaultOutput) && dir.getOutput().startsWith(defaultOutput) && byOutputDir.get(defaultOutput) != null && !((List)byOutputDir.get(defaultOutput)).isEmpty()) {
                this.log.debug((CharSequence)("Marking as special to prevent output folder nesting: " + dir.getPath() + " (output=" + dir.getOutput() + ")"));
                isSpecial = true;
                specialSources.add(dir);
            }
            writer.startElement(ELT_CLASSPATHENTRY);
            writer.addAttribute(ATTR_KIND, ATTR_SRC);
            writer.addAttribute(ATTR_PATH, dir.getPath());
            if (!isSpecial && dir.getOutput() != null && !defaultOutput.equals(dir.getOutput())) {
                writer.addAttribute(ATTR_OUTPUT, dir.getOutput());
            }
            if (StringUtils.isNotEmpty((String)(includes = dir.getIncludeAsString()))) {
                writer.addAttribute(ATTR_INCLUDING, includes);
            }
            if (StringUtils.isNotEmpty((String)(excludes = dir.getExcludeAsString()))) {
                writer.addAttribute(ATTR_EXCLUDING, excludes);
            }
            writer.endElement();
        }
        if (!specialSources.isEmpty()) {
            this.log.info((CharSequence)"Creating maven-eclipse.xml Ant file to handle resources");
            try {
                OutputStreamWriter buildXmlWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.config.getEclipseProjectDirectory(), "maven-eclipse.xml")), "UTF-8");
                PrettyPrintXMLWriter buildXmlPrinter = new PrettyPrintXMLWriter((Writer)buildXmlWriter);
                buildXmlPrinter.startElement("project");
                buildXmlPrinter.addAttribute("default", "copy-resources");
                buildXmlPrinter.startElement("target");
                buildXmlPrinter.addAttribute(NAME, "init");
                buildXmlPrinter.endElement();
                buildXmlPrinter.startElement("target");
                buildXmlPrinter.addAttribute(NAME, "copy-resources");
                buildXmlPrinter.addAttribute("depends", "init");
                Iterator it = specialSources.iterator();
                while (it.hasNext()) {
                    EclipseSourceDir dir2 = (EclipseSourceDir)it.next();
                    buildXmlPrinter.startElement("copy");
                    buildXmlPrinter.addAttribute("todir", dir2.getOutput());
                    buildXmlPrinter.addAttribute("filtering", "" + dir2.isFiltering());
                    buildXmlPrinter.startElement("fileset");
                    buildXmlPrinter.addAttribute("dir", dir2.getPath());
                    if (dir2.getIncludeAsString() != null) {
                        buildXmlPrinter.addAttribute("includes", dir2.getIncludeAsString());
                    }
                    if (dir2.getExcludeAsString() != null) {
                        buildXmlPrinter.addAttribute("excludes", dir2.getExcludeAsString());
                    }
                    buildXmlPrinter.endElement();
                    buildXmlPrinter.endElement();
                }
                buildXmlPrinter.endElement();
                buildXmlPrinter.endElement();
                IOUtil.close((Writer)buildXmlWriter);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot create " + this.config.getEclipseProjectDirectory() + "/maven-eclipse.xml", (Exception)e);
            }
            this.log.info((CharSequence)"Creating external launcher file");
            new EclipseAntExternalLaunchConfigurationWriter().init(this.log, this.config, "Maven_Ant_Builder.launch", "maven-eclipse.xml").write();
            this.config.getBuildCommands().add(new BuildCommand("org.eclipse.ui.externaltools.ExternalToolBuilder", "LaunchConfigHandle", "<project>/.externalToolBuilders/Maven_Ant_Builder.launch"));
        }
        writer.startElement(ELT_CLASSPATHENTRY);
        writer.addAttribute(ATTR_KIND, ATTR_OUTPUT);
        writer.addAttribute(ATTR_PATH, defaultOutput);
        writer.endElement();
        HashSet<String> addedDependencies = new HashSet<String>();
        IdeDependency[] depsToWrite = this.config.getDepsOrdered();
        for (j = 0; j < depsToWrite.length; ++j) {
            dep = depsToWrite[j];
            if (!dep.isJavaApi() || addedDependencies.contains(depId = this.getDependencyId(dep))) continue;
            this.addDependency((XMLWriter)writer, dep);
            addedDependencies.add(depId);
        }
        for (j = 0; j < depsToWrite.length; ++j) {
            dep = depsToWrite[j];
            if (!dep.isAddedToClasspath() || addedDependencies.contains(depId = this.getDependencyId(dep))) continue;
            this.addDependency((XMLWriter)writer, dep);
            addedDependencies.add(depId);
        }
        Iterator it = this.config.getClasspathContainers().iterator();
        while (it.hasNext()) {
            writer.startElement(ELT_CLASSPATHENTRY);
            writer.addAttribute(ATTR_KIND, "con");
            writer.addAttribute(ATTR_PATH, (String)it.next());
            writer.endElement();
        }
        writer.endElement();
        IOUtil.close((Writer)w);
    }

    private String getDependencyId(IdeDependency dep) {
        String depId = dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getClassifier() + ":" + dep.getVersion();
        if (dep.isReferencedProject()) {
            depId = dep.getEclipseProjectName();
        }
        return depId;
    }

    protected void addDependency(XMLWriter writer, IdeDependency dep) throws MojoExecutionException {
        String kind;
        String path;
        String sourcepath = null;
        String javadocpath = null;
        if (dep.isReferencedProject() && !this.config.isPde()) {
            path = "/" + dep.getEclipseProjectName();
            kind = ATTR_SRC;
        } else {
            if (dep.isReferencedProject() && this.config.isPde()) {
                return;
            }
            File artifactPath = dep.getFile();
            if (artifactPath == null) {
                this.log.error((CharSequence)Messages.getString("EclipsePlugin.artifactpathisnull", dep.getId()));
                return;
            }
            if (dep.isSystemScoped()) {
                path = IdeUtils.toRelativeAndFixSeparator(this.config.getEclipseProjectDirectory(), artifactPath, false);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)Messages.getString("EclipsePlugin.artifactissystemscoped", new Object[]{dep.getArtifactId(), path}));
                }
                kind = ATTR_LIB;
            } else {
                File localRepositoryFile = new File(this.config.getLocalRepository().getBasedir());
                if (this.config.isPde() && (dep.isProvided() || dep.isOsgiBundle())) {
                    return;
                }
                if (this.config.isPde() && !dep.isProvided() && !dep.isTestDependency()) {
                    path = dep.getFile().getName();
                    kind = ATTR_LIB;
                } else {
                    String fullPath = artifactPath.getPath();
                    String relativePath = IdeUtils.toRelativeAndFixSeparator(localRepositoryFile, new File(fullPath), false);
                    if (!new File(relativePath).isAbsolute()) {
                        path = "M2_REPO/" + relativePath;
                        kind = ATTR_VAR;
                    } else {
                        path = relativePath;
                        kind = ATTR_LIB;
                    }
                }
                if (dep.getSourceAttachment() != null) {
                    sourcepath = ATTR_VAR.equals(kind) ? "M2_REPO/" + IdeUtils.toRelativeAndFixSeparator(localRepositoryFile, dep.getSourceAttachment(), false) : IdeUtils.getCanonicalPath(dep.getSourceAttachment());
                }
                if (dep.getJavadocAttachment() != null) {
                    javadocpath = StringUtils.replace((String)IdeUtils.getCanonicalPath(dep.getJavadocAttachment()), (String)"\\", (String)"/");
                }
            }
        }
        if (this.config.getAjdtVersion() != 0.0f && this.isAspectJRuntime(dep)) {
            if (!this.config.getClasspathContainers().contains(ASPECTJRT_CONTAINER)) {
                this.config.getClasspathContainers().add(ASPECTJRT_CONTAINER);
            }
            return;
        }
        writer.startElement(ELT_CLASSPATHENTRY);
        writer.addAttribute(ATTR_KIND, kind);
        writer.addAttribute(ATTR_PATH, path);
        if (sourcepath != null) {
            writer.addAttribute(ATTR_SOURCEPATH, sourcepath);
        }
        boolean attributeElemOpen = false;
        if (javadocpath != null) {
            if (!attributeElemOpen) {
                writer.startElement(ATTRIBUTES);
                attributeElemOpen = true;
            }
            writer.startElement(ATTRIBUTE);
            writer.addAttribute(VALUE, "jar:" + new File(javadocpath).toURI() + "!/");
            writer.addAttribute(NAME, "javadoc_location");
            writer.endElement();
        }
        if ("war".equals(this.config.getPackaging()) && this.config.getWtpapplicationxml() && kind.equals(ATTR_VAR) && !dep.isTestDependency() && !dep.isProvided() && !dep.isSystemScopedOutsideProject(this.config.getProject())) {
            if (!attributeElemOpen) {
                writer.startElement(ATTRIBUTES);
                attributeElemOpen = true;
            }
            writer.startElement(ATTRIBUTE);
            writer.addAttribute(VALUE, "/WEB-INF/lib");
            writer.addAttribute(NAME, "org.eclipse.jst.component.dependency");
            writer.endElement();
        }
        if (dep.isAjdtDependency() && (double)this.config.getAjdtVersion() >= 1.5) {
            if (!attributeElemOpen) {
                writer.startElement(ATTRIBUTES);
                attributeElemOpen = true;
            }
            writer.startElement(ATTRIBUTE);
            writer.addAttribute(NAME, ORG_ECLIPSE_AJDT_ASPECTPATH);
            writer.addAttribute(VALUE, Boolean.TRUE.toString());
            writer.endElement();
        }
        if (dep.isAjdtWeaveDependency() && (double)this.config.getAjdtVersion() >= 1.5) {
            if (!attributeElemOpen) {
                writer.startElement(ATTRIBUTES);
                attributeElemOpen = true;
            }
            writer.startElement(ATTRIBUTE);
            writer.addAttribute(NAME, ORG_ECLIPSE_AJDT_INPATH);
            writer.addAttribute(VALUE, Boolean.TRUE.toString());
            writer.endElement();
        }
        if (attributeElemOpen) {
            writer.endElement();
        }
        writer.endElement();
    }

    private boolean isAspectJRuntime(IdeDependency dep) {
        if (dep.getArtifactId().equals("aspectjrt")) {
            return dep.getGroupId().equals("org.aspectj") || dep.getGroupId().equals("aspectj");
        }
        return false;
    }
}

