/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ear;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.ear.AppClientModule;
import org.apache.maven.plugins.ear.EarModule;
import org.apache.maven.plugins.ear.EjbClientModule;
import org.apache.maven.plugins.ear.EjbModule;
import org.apache.maven.plugins.ear.HarModule;
import org.apache.maven.plugins.ear.JarModule;
import org.apache.maven.plugins.ear.ParModule;
import org.apache.maven.plugins.ear.RarModule;
import org.apache.maven.plugins.ear.SarModule;
import org.apache.maven.plugins.ear.UnknownArtifactTypeException;
import org.apache.maven.plugins.ear.WebModule;
import org.apache.maven.plugins.ear.WsrModule;
import org.apache.maven.plugins.ear.util.ArtifactTypeMappingService;
import org.apache.maven.plugins.ear.util.JavaEEVersion;

public final class EarModuleFactory {
    public static final List<String> STANDARD_ARTIFACT_TYPE = Collections.unmodifiableList(Arrays.asList("jar", "ejb", "par", "ejb-client", "app-client", "rar", "war", "sar", "wsr", "har"));

    public static EarModule newEarModule(Artifact artifact, JavaEEVersion javaEEVersion, String defaultLibBundleDir, Boolean includeInApplicationXml, ArtifactTypeMappingService typeMappingService) throws UnknownArtifactTypeException {
        String artifactType;
        try {
            artifactType = typeMappingService.getStandardType(artifact.getType());
        }
        catch (UnknownArtifactTypeException e) {
            throw new UnknownArtifactTypeException(e.getMessage() + " for " + artifact.getArtifactId());
        }
        if ("jar".equals(artifactType)) {
            return new JarModule(artifact, defaultLibBundleDir, includeInApplicationXml);
        }
        if ("ejb".equals(artifactType)) {
            return new EjbModule(artifact);
        }
        if ("par".equals(artifactType)) {
            return new ParModule(artifact);
        }
        if ("ejb-client".equals(artifactType)) {
            if (javaEEVersion.le(JavaEEVersion.ONE_DOT_FOUR)) {
                return new EjbClientModule(artifact, null);
            }
            return new EjbClientModule(artifact, defaultLibBundleDir);
        }
        if ("app-client".equals(artifactType)) {
            return new AppClientModule(artifact);
        }
        if ("rar".equals(artifactType)) {
            return new RarModule(artifact);
        }
        if ("war".equals(artifactType)) {
            return new WebModule(artifact);
        }
        if ("sar".equals(artifactType)) {
            return new SarModule(artifact);
        }
        if ("wsr".equals(artifactType)) {
            return new WsrModule(artifact);
        }
        if ("har".equals(artifactType)) {
            return new HarModule(artifact);
        }
        throw new IllegalStateException("Could not handle artifact type[" + artifactType + "]");
    }

    public static List<String> getStandardArtifactTypes() {
        return STANDARD_ARTIFACT_TYPE;
    }

    public static boolean isStandardArtifactType(String type) {
        return STANDARD_ARTIFACT_TYPE.contains(type);
    }
}

