/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.docck.reports;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.docck.reports.DocumentationReport;
import org.apache.maven.plugin.docck.reports.ErrorDocumentationReport;
import org.apache.maven.plugin.docck.reports.InfoDocumentationReport;
import org.apache.maven.plugin.docck.reports.WarningDocumentationReport;

public class DocumentationReporter {
    private List<DocumentationReport> reports = new ArrayList<DocumentationReport>();

    public void info(String message) {
        this.reports.add(new InfoDocumentationReport("[INFO]  " + message));
    }

    public void warn(String message) {
        this.reports.add(new WarningDocumentationReport("[WARN]  " + message));
    }

    public void error(String message) {
        this.reports.add(new ErrorDocumentationReport("[ERROR] " + message));
    }

    public List<String> getMessagesByType(int type) {
        ArrayList<String> list = new ArrayList<String>();
        for (DocumentationReport report : this.reports) {
            if (report.getType() != type) continue;
            list.add(report.getMessage());
        }
        return list;
    }

    public List<String> getMessages() {
        ArrayList<String> list = new ArrayList<String>();
        for (DocumentationReport report : this.reports) {
            list.add(report.getMessage());
        }
        return list;
    }

    public boolean hasErrors() {
        for (DocumentationReport report : this.reports) {
            if (report.getType() != 3) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.reports.clear();
    }
}

