/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.doap.options;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Developer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class ASFExtOptionsUtil {
    private static final String APACHE_DOMAIN_NAME = "apache.org";
    public static final String CATEGORY_RESOURCE = "http://projects.apache.org/category/";
    public static final String BUILD_MANAGEMENT_CATEGORY = "build-management";
    public static final String DATABASE_CATEGORY = "database";
    public static final String HTTP_CATEGORY = "http";
    public static final String HTTP_MODULES_CATEGORY = "httpd-modules";
    public static final String LIBRARY_CATEGORY = "library";
    public static final String MAIL_CATEGORY = "mail";
    public static final String NETWORK_CLIENT_CATEGORY = "network-client";
    public static final String NETWORK_SERVER_CATEGORY = "network-server";
    public static final String TESTING_CATEGORY = "testing";
    public static final String WEB_FRAMEWORK_CATEGORY = "web-framework";
    public static final String XML_CATEGORY = "xml";
    public static final String[] CATEGORIES = new String[]{"build-management", "database", "http", "httpd-modules", "library", "mail", "network-client", "network-server", "testing", "web-framework", "xml"};
    public static final String C_PROGRAMMING_LANGUAGE = "C";
    public static final String JAVA_PROGRAMMING_LANGUAGE = "Java";
    public static final String PERL_PROGRAMMING_LANGUAGE = "Perl";
    public static final String PYTHON_PROGRAMMING_LANGUAGE = "Python";
    public static final String SVG_PROGRAMMING_LANGUAGE = "SVG";
    public static final String TCL_PROGRAMMING_LANGUAGE = "Tcl";
    public static final String[] PROGRAMMING_LANGUAGES = new String[]{"C", "Java", "Perl", "Python", "SVG", "Tcl"};

    public static String getCategorySupportedByASF(String category) {
        for (String supportedCategory : CATEGORIES) {
            if (!supportedCategory.equalsIgnoreCase(category)) continue;
            return supportedCategory;
        }
        return null;
    }

    public static String getProgrammingLanguageSupportedByASF(String programmingLanguage) {
        for (String supportedProgrammingLanguage : PROGRAMMING_LANGUAGES) {
            if (!supportedProgrammingLanguage.equalsIgnoreCase(programmingLanguage)) continue;
            return supportedProgrammingLanguage;
        }
        return null;
    }

    public static Developer findChair(List<Developer> developers) {
        if (developers == null || developers.isEmpty()) {
            return null;
        }
        for (Developer developer : developers) {
            List roles = developer.getRoles();
            for (String role : roles) {
                if (!role.toLowerCase().contains("chair")) continue;
                return developer;
            }
        }
        return null;
    }

    public static List<Developer> findPMCMembers(List<Developer> developers) {
        if (developers == null || developers.isEmpty()) {
            return null;
        }
        ArrayList<Developer> pmcs = new ArrayList<Developer>();
        for (Developer developer : developers) {
            List roles = developer.getRoles();
            for (String role : roles) {
                if (!role.toLowerCase().contains("pmc")) continue;
                pmcs.add(developer);
            }
        }
        return pmcs;
    }

    public static boolean isASFProject(MavenProject project) {
        if (project == null) {
            throw new IllegalArgumentException("project is required");
        }
        if (project.getOrganization() != null && StringUtils.isNotEmpty((String)project.getOrganization().getName()) && project.getOrganization().getName().trim().equals("The Apache Software Foundation")) {
            return true;
        }
        if (project.getOrganization() != null && ASFExtOptionsUtil.isHostedAtASF(project.getOrganization().getUrl())) {
            return true;
        }
        if (ASFExtOptionsUtil.isHostedAtASF(project.getUrl())) {
            return true;
        }
        if (project.getScm() != null) {
            if (StringUtils.isNotEmpty((String)project.getScm().getUrl()) && project.getScm().getUrl().contains(APACHE_DOMAIN_NAME)) {
                return true;
            }
            if (StringUtils.isNotEmpty((String)project.getScm().getConnection()) && project.getScm().getConnection().contains(APACHE_DOMAIN_NAME)) {
                return true;
            }
            if (StringUtils.isNotEmpty((String)project.getScm().getDeveloperConnection()) && project.getScm().getDeveloperConnection().contains(APACHE_DOMAIN_NAME)) {
                return true;
            }
        }
        if (project.getDistributionManagement() != null) {
            if (ASFExtOptionsUtil.isHostedAtASF(project.getDistributionManagement().getDownloadUrl())) {
                return true;
            }
            if (project.getDistributionManagement().getRepository() != null && ASFExtOptionsUtil.isHostedAtASF(project.getDistributionManagement().getRepository().getUrl())) {
                return true;
            }
            if (project.getDistributionManagement().getSnapshotRepository() != null && ASFExtOptionsUtil.isHostedAtASF(project.getDistributionManagement().getSnapshotRepository().getUrl())) {
                return true;
            }
            if (project.getDistributionManagement().getSite() != null && ASFExtOptionsUtil.isHostedAtASF(project.getDistributionManagement().getSite().getUrl())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHostedAtASF(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        str = str.trim();
        try {
            URL url = new URL(str);
            if (url.getHost().endsWith(APACHE_DOMAIN_NAME)) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }
}

