/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.deploy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-deploy-plugin:2.4", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Deploy Plugin 2.4", 0);
        this.append(sb, "Maven Plugins", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy".equals(this.goal)) {
            this.append(sb, "deploy:deploy", 0);
            this.append(sb, "Deploys an artifact to remote repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "altDeploymentRepository", 2);
                this.append(sb, "Specifies an alternative repository to which the project artifacts should be deployed ( other than those specified in <distributionManagement> ).\nFormat: id::layout::url", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass artifact deploy", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateReleaseInfo (Default: false)", 2);
                this.append(sb, "Parameter used to update the metadata to make the artifact as release.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy-file".equals(this.goal)) {
            this.append(sb, "deploy:deploy-file", 0);
            this.append(sb, "Installs the artifact in the remote repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifactId", 2);
                this.append(sb, "ArtifactId of the artifact to be deployed. Retrieved from POM file if specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Add classifier to the artifact", 3);
                this.append(sb, "", 0);
                this.append(sb, "description", 2);
                this.append(sb, "Description passed to a generated POM file (in case of generatePom=true)", 3);
                this.append(sb, "", 0);
                this.append(sb, "file", 2);
                this.append(sb, "File to be deployed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatePom (Default: true)", 2);
                this.append(sb, "Upload a POM for this artifact. Will generate a default POM if none is supplied with the pomFile argument.", 3);
                this.append(sb, "", 0);
                this.append(sb, "groupId", 2);
                this.append(sb, "GroupId of the artifact to be deployed. Retrieved from POM file if specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packaging", 2);
                this.append(sb, "Type of the artifact to be deployed. Retrieved from POM file if specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomFile", 2);
                this.append(sb, "Location of an existing POM file to be deployed alongside the main artifact, given by the ${file} parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryId (Default: remote-repository)", 2);
                this.append(sb, "Server Id to map on the <id> under <server> section of settings.xml In most cases, this parameter will be required for authentication.", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryLayout (Default: default)", 2);
                this.append(sb, "The type of remote repository layout to deploy to. Try legacy for a Maven 1.x-style repository layout.", 3);
                this.append(sb, "", 0);
                this.append(sb, "uniqueVersion (Default: true)", 2);
                this.append(sb, "Whether to deploy snapshots with a unique version or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "URL where the artifact will be deployed.\nie ( file://C:\\m2-repo or scp://host.com/path/to/repo )", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "Version of the artifact to be deployed. Retrieved from POM file if specified.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "deploy:help", 0);
            this.append(sb, "Display help information on maven-deploy-plugin. Call\n\u00a0\u00a0mvn\u00a0deploy:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

