/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.maven.plugins.dependency.tree.AbstractVerboseGraphSerializer;
import org.eclipse.aether.graph.DependencyNode;

public class VerboseGraphGraphmlSerializer
extends AbstractVerboseGraphSerializer {
    @Override
    public String serialize(DependencyNode root) {
        HashSet<String> coordinateStrings = new HashSet<String>();
        HashMap<String, String> coordinateVersionMap = new HashMap<String, String>();
        Map<DependencyNode, String> nodeErrors = this.getNodeConflictMessagesBfs(root, coordinateStrings, coordinateVersionMap);
        HashSet<DependencyNode> visitedNodes = new HashSet<DependencyNode>();
        LinkedList<DependencyNode> queue = new LinkedList<DependencyNode>();
        queue.add(root);
        StringBuilder result = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?> <graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:y=\"http://www.yworks.com/xml/graphml\" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n  <key for=\"node\" id=\"d0\" yfiles.type=\"nodegraphics\"/>\n  <key for=\"edge\" id=\"d1\" yfiles.type=\"edgegraphics\"/>\n<graph id=\"dependencies\" edgedefault=\"directed\">\n");
        StringBuilder nodes = new StringBuilder();
        StringBuilder edges = new StringBuilder();
        while (!queue.isEmpty()) {
            DependencyNode node = (DependencyNode)queue.poll();
            nodes.append(this.getGraphmlNodeLine(node, nodeErrors));
            if (nodeErrors.get(node) != null || node.getArtifact().getProperties().containsKey("Cycle")) continue;
            for (DependencyNode child : node.getChildren()) {
                if (!visitedNodes.contains(child)) {
                    visitedNodes.add(child);
                    queue.add(child);
                }
                edges.append(this.getGraphmlEdgeLine(node, child, nodeErrors));
            }
        }
        result.append((CharSequence)nodes).append((CharSequence)edges);
        result.append("</graph></graphml>");
        return result.toString();
    }

    private String getGraphmlEdgeLine(DependencyNode parent, DependencyNode child, Map<DependencyNode, String> nodeErrors) {
        StringBuilder builder = new StringBuilder();
        builder.append("<edge source=\"").append(parent.hashCode()).append("\" target=\"").append(child.hashCode()).append("\"><data key=\"d1\"><y:PolyLineEdge><y:EdgeLabel>");
        boolean messageAdded = false;
        if (child.getArtifact().getProperties().containsKey("preManagedScope")) {
            messageAdded = true;
            builder.append((String)child.getArtifact().getProperties().get("managedScope"));
            builder.append(", scope managed from ").append((String)child.getArtifact().getProperties().get("preManagedScope"));
        } else {
            builder.append(child.getDependency().getScope());
        }
        if (child.getArtifact().getProperties().containsKey("Cycle")) {
            if (messageAdded) {
                builder.append(",");
            }
            builder.append(" omitted due to cycle");
        } else if (nodeErrors.get(child) != null) {
            if (messageAdded) {
                builder.append(",");
            }
            builder.append(" ").append(nodeErrors.get(child));
        }
        builder.append("</y:EdgeLabel></y:PolyLineEdge></data></edge>").append("\n");
        return builder.toString();
    }

    private String getGraphmlNodeLine(DependencyNode node, Map<DependencyNode, String> nodeErrors) {
        StringBuilder builder = new StringBuilder();
        builder.append("<node id=\"").append(node.hashCode()).append("\"><data key=\"d0\"><y:ShapeNode><y:NodeLabel>");
        String coordString = "";
        boolean messageAdded = false;
        if (node.getArtifact().getProperties().containsKey("preManagedVersion")) {
            coordString = coordString + " - version managed from " + (String)node.getArtifact().getProperties().get("preManagedVersion");
            messageAdded = true;
        }
        if (node.getArtifact().getProperties().containsKey("preManagedScope")) {
            if (messageAdded) {
                coordString = coordString + "; ";
            } else {
                coordString = coordString + " - ";
                messageAdded = true;
            }
            coordString = coordString + "scope managed from " + (String)node.getArtifact().getProperties().get("preManagedScope");
        }
        builder.append(VerboseGraphGraphmlSerializer.getDependencyCoordinate(node)).append(coordString);
        if (node.getData().containsKey("ContainsModule")) {
            builder.append(" WARNING: this tree contains a submodule. Once it reaches the submodule will print in nonVerbose fashion, to see the actual submodule verbose output refer to the rest of the output");
        }
        if (node.getArtifact().getProperties().containsKey("Cycle")) {
            if (!messageAdded) {
                builder.append(" - ");
            }
            builder.append("omitted due to cycle");
        } else if (nodeErrors.get(node) != null) {
            if (!messageAdded) {
                builder.append(" - ");
            }
            builder.append(nodeErrors.get(node));
        }
        builder.append("</y:NodeLabel></y:ShapeNode></data></node>").append("\n");
        return builder.toString();
    }
}

