/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.dependency.resolvers.AbstractResolveMojo;
import org.apache.maven.plugins.dependency.resolvers.ExcludeReactorProjectsDependencyFilter;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;

@Mojo(name="go-offline", threadSafe=true)
public class GoOfflineMojo
extends AbstractResolveMojo {
    @Override
    protected void doExecute() throws MojoExecutionException {
        try {
            Set<Artifact> plugins = this.resolvePluginArtifacts();
            Set<Artifact> dependencies = this.resolveDependencyArtifacts();
            if (!this.isSilent()) {
                for (Artifact artifact : plugins) {
                    this.getLog().info((CharSequence)("Resolved plugin: " + DependencyUtil.getFormattedFileName(artifact, false)));
                }
                for (Artifact artifact : dependencies) {
                    this.getLog().info((CharSequence)("Resolved dependency: " + DependencyUtil.getFormattedFileName(artifact, false)));
                }
            }
        }
        catch (DependencyResolverException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected Set<Artifact> resolveDependencyArtifacts() throws DependencyResolverException {
        List dependencies = this.getProject().getDependencies();
        HashSet<DependableCoordinate> dependableCoordinates = new HashSet<DependableCoordinate>();
        ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest();
        for (Dependency dependency : dependencies) {
            dependableCoordinates.add(this.createDependendableCoordinateFromDependency(dependency));
        }
        return this.resolveDependableCoordinate(buildingRequest, dependableCoordinates, "dependencies");
    }

    private Set<Artifact> resolveDependableCoordinate(ProjectBuildingRequest buildingRequest, Collection<DependableCoordinate> dependableCoordinates, String type) throws DependencyResolverException {
        TransformableFilter filter = this.getTransformableFilter();
        HashSet<Artifact> results = new HashSet<Artifact>();
        this.getLog().debug((CharSequence)("Resolving '" + type + "' with following repositories:"));
        for (ArtifactRepository repo : buildingRequest.getRemoteRepositories()) {
            this.getLog().debug((CharSequence)(repo.getId() + " (" + repo.getUrl() + ")"));
        }
        for (DependableCoordinate dependableCoordinate : dependableCoordinates) {
            Iterable artifactResults = this.getDependencyResolver().resolveDependencies(buildingRequest, dependableCoordinate, filter);
            for (ArtifactResult artifactResult : artifactResults) {
                results.add(artifactResult.getArtifact());
            }
        }
        return results;
    }

    private TransformableFilter getTransformableFilter() {
        if (this.excludeReactor) {
            return new ExcludeReactorProjectsDependencyFilter(this.reactorProjects, this.getLog());
        }
        return null;
    }

    protected Set<Artifact> resolvePluginArtifacts() throws DependencyResolverException {
        HashSet<DependableCoordinate> dependableCoordinates = new HashSet<DependableCoordinate>();
        Set plugins = this.getProject().getPluginArtifacts();
        Set reports = this.getProject().getReportArtifacts();
        LinkedHashSet artifacts = new LinkedHashSet();
        artifacts.addAll(reports);
        artifacts.addAll(plugins);
        ProjectBuildingRequest buildingRequest = this.newResolvePluginProjectBuildingRequest();
        for (Artifact artifact : artifacts) {
            dependableCoordinates.add(this.createDependendableCoordinateFromArtifact(artifact));
        }
        return this.resolveDependableCoordinate(buildingRequest, dependableCoordinates, "plugins");
    }

    private DependableCoordinate createDependendableCoordinateFromArtifact(Artifact artifact) {
        DefaultDependableCoordinate result = new DefaultDependableCoordinate();
        result.setGroupId(artifact.getGroupId());
        result.setArtifactId(artifact.getArtifactId());
        result.setVersion(artifact.getVersion());
        result.setType(artifact.getType());
        result.setClassifier(artifact.getClassifier());
        return result;
    }

    private DependableCoordinate createDependendableCoordinateFromDependency(Dependency dependency) {
        DefaultDependableCoordinate result = new DefaultDependableCoordinate();
        result.setGroupId(dependency.getGroupId());
        result.setArtifactId(dependency.getArtifactId());
        result.setVersion(dependency.getVersion());
        result.setType(dependency.getType());
        result.setClassifier(dependency.getClassifier());
        return result;
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }
}

