/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromDependencies;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.fromDependencies.AbstractDependencyFilterMojo;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.dependency.utils.ResolverUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="build-classpath", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class BuildClasspathMojo
extends AbstractDependencyFilterMojo
implements Comparator<Artifact> {
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Parameter(property="mdep.stripVersion", defaultValue="false")
    private boolean stripVersion = false;
    @Parameter(property="mdep.stripClassifier", defaultValue="false")
    private boolean stripClassifier = false;
    @Parameter(property="mdep.prefix")
    private String prefix;
    @Parameter(property="mdep.outputProperty")
    private String outputProperty;
    @Parameter(property="mdep.outputFile")
    private File outputFile;
    @Parameter(property="mdep.regenerateFile", defaultValue="false")
    private boolean regenerateFile;
    @Parameter(property="mdep.fileSeparator", defaultValue="")
    private String fileSeparator;
    @Parameter(property="mdep.pathSeparator", defaultValue="")
    private String pathSeparator;
    @Parameter(property="mdep.localRepoProperty", defaultValue="")
    private String localRepoProperty;
    @Parameter(defaultValue="false")
    private boolean attach;
    @Parameter(property="mdep.outputFilterFile", defaultValue="false")
    private boolean outputFilterFile;
    @Parameter(property="mdep.useBaseVersion", defaultValue="true")
    private boolean useBaseVersion = true;
    private final MavenProjectHelper projectHelper;

    @Inject
    protected BuildClasspathMojo(MavenSession session, BuildContext buildContext, MavenProject project, ResolverUtil resolverUtil, ProjectBuilder projectBuilder, ArtifactHandlerManager artifactHandlerManager, MavenProjectHelper projectHelper) {
        super(session, buildContext, project, resolverUtil, projectBuilder, artifactHandlerManager);
        this.projectHelper = projectHelper;
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        Set<Artifact> artifacts;
        boolean isPathSepSet;
        boolean isFileSepSet = this.fileSeparator != null && !this.fileSeparator.isEmpty();
        boolean bl = isPathSepSet = this.pathSeparator != null && !this.pathSeparator.isEmpty();
        if (this.attach && (this.localRepoProperty == null || this.localRepoProperty.isEmpty())) {
            this.localRepoProperty = "${M2_REPO}";
        }
        if ((artifacts = this.getResolvedDependencies(true)) == null || artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"No dependencies found.");
        }
        ArrayList<Artifact> artList = new ArrayList<Artifact>(artifacts);
        StringBuilder sb = new StringBuilder();
        Iterator i = artList.iterator();
        if (i.hasNext()) {
            this.appendArtifactPath((Artifact)i.next(), sb);
            while (i.hasNext()) {
                sb.append(isPathSepSet ? this.pathSeparator : File.pathSeparator);
                this.appendArtifactPath((Artifact)i.next(), sb);
            }
        }
        String cpString = sb.toString();
        if (isFileSepSet) {
            String pattern = Pattern.quote(File.separator);
            String replacement = Matcher.quoteReplacement(this.fileSeparator);
            cpString = cpString.replaceAll(pattern, replacement);
        }
        if (this.outputFilterFile) {
            cpString = "classpath=" + cpString;
        }
        if (this.outputProperty != null) {
            this.getProject().getProperties().setProperty(this.outputProperty, cpString);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(this.outputProperty + " = " + cpString));
            }
        }
        if (this.outputFile != null) {
            if (this.regenerateFile || !this.isUpToDate(cpString)) {
                this.storeClasspathFile(cpString, this.outputFile);
            } else {
                this.getLog().info((CharSequence)("Skipped writing classpath file '" + this.outputFile + "'.  No changes found."));
            }
        }
        if (this.outputProperty == null && this.outputFile == null) {
            this.getLog().info((CharSequence)("Dependencies classpath:" + System.lineSeparator() + cpString));
        }
        if (this.attach) {
            this.attachFile(cpString);
        }
    }

    protected void attachFile(String cpString) throws MojoExecutionException {
        File attachedFile = new File(this.getProject().getBuild().getDirectory(), "classpath");
        this.storeClasspathFile(cpString, attachedFile);
        this.projectHelper.attachArtifact(this.getProject(), attachedFile, "classpath");
    }

    protected void appendArtifactPath(Artifact art, StringBuilder sb) {
        if (this.prefix == null) {
            String file = art.getFile().getPath();
            if (this.localRepoProperty != null && !this.localRepoProperty.isEmpty()) {
                File localBasedir = this.session.getRepositorySession().getLocalRepository().getBasedir();
                file = StringUtils.replace((String)file, (String)localBasedir.getAbsolutePath(), (String)this.localRepoProperty);
            }
            sb.append(file);
        } else {
            sb.append(this.prefix);
            sb.append(File.separator);
            sb.append(DependencyUtil.getFormattedFileName(art, this.stripVersion, this.prependGroupId, this.useBaseVersion, this.stripClassifier));
        }
    }

    private boolean isUpToDate(String cpString) {
        try {
            String oldCp = this.readClasspathFile();
            return Objects.equals(cpString, oldCp);
        }
        catch (IOException ex) {
            this.getLog().warn((CharSequence)("Error while reading old classpath file '" + this.outputFile + "' for up-to-date check: " + ex));
            return false;
        }
    }

    private void storeClasspathFile(String cpString, File out) throws MojoExecutionException {
        out.getParentFile().mkdirs();
        String encoding = Objects.toString(this.outputEncoding, StandardCharsets.UTF_8.name());
        try (BufferedWriter w = Files.newBufferedWriter(out.toPath(), Charset.forName(encoding), new OpenOption[0]);){
            w.write(cpString);
            this.getLog().info((CharSequence)("Wrote classpath file '" + out + "'."));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error while writing to classpath file '" + out, (Exception)ex);
        }
    }

    protected String readClasspathFile() throws IOException {
        if (this.outputFile == null) {
            throw new IllegalArgumentException("The outputFile parameter cannot be null if the file is intended to be read.");
        }
        if (!this.outputFile.isFile()) {
            return null;
        }
        String encoding = Objects.toString(this.outputEncoding, StandardCharsets.UTF_8.name());
        try (Stream<String> lines = Files.lines(this.outputFile.toPath(), Charset.forName(encoding));){
            String string = lines.collect(Collectors.joining());
            return string;
        }
    }

    @Override
    public int compare(Artifact art1, Artifact art2) {
        if (art1 == art2) {
            return 0;
        }
        if (art1 == null) {
            return -1;
        }
        if (art2 == null) {
            return 1;
        }
        String s1 = art1.getGroupId() + art1.getArtifactId() + art1.getVersion();
        String s2 = art2.getGroupId() + art2.getArtifactId() + art2.getVersion();
        return s1.compareTo(s2);
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setOutputProperty(String theOutputProperty) {
        this.outputProperty = theOutputProperty;
    }

    public void setFileSeparator(String theFileSeparator) {
        this.fileSeparator = theFileSeparator;
    }

    public void setPathSeparator(String thePathSeparator) {
        this.pathSeparator = thePathSeparator;
    }

    public void setPrefix(String thePrefix) {
        this.prefix = thePrefix;
    }

    public void setRegenerateFile(boolean theRegenerateFile) {
        this.regenerateFile = theRegenerateFile;
    }

    public boolean isStripVersion() {
        return this.stripVersion;
    }

    public void setStripVersion(boolean theStripVersion) {
        this.stripVersion = theStripVersion;
    }

    public void setLocalRepoProperty(String localRepoProperty) {
        this.localRepoProperty = localRepoProperty;
    }
}

