/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;

public class GetMojo
extends AbstractMojo {
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactRepositoryLayout repositoryLayout;
    private ArtifactMetadataSource source;
    private ArtifactRepository localRepository;
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String packaging = "jar";
    private String repositoryId = "temp";
    private String repositoryUrl;
    private String remoteRepositories;
    private String artifact;
    private List pomRemoteRepositories;
    private boolean transitive = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.artifactId == null && this.artifact == null) {
            throw new MojoFailureException("You must specify an artifact, e.g. -Dartifact=org.apache.maven.plugins:maven-downloader-plugin:1.0");
        }
        if (this.artifactId == null) {
            String[] tokens = StringUtils.split((String)this.artifact, (String)":");
            if (tokens.length < 3 && tokens.length > 5) {
                throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging][:classifier] " + this.artifact);
            }
            this.groupId = tokens[0];
            this.artifactId = tokens[1];
            this.version = tokens[2];
            if (tokens.length >= 4) {
                this.packaging = tokens[3];
            }
            this.classifier = tokens.length == 5 ? tokens[4] : null;
        }
        Artifact toDownload = this.classifier == null ? this.artifactFactory.createBuildArtifact(this.groupId, this.artifactId, this.version, this.packaging) : this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        Artifact dummyOriginatingArtifact = this.artifactFactory.createBuildArtifact("org.apache.maven.plugins", "maven-downloader-plugin", "1.0", "jar");
        ArtifactRepositoryPolicy always = new ArtifactRepositoryPolicy(true, "always", "warn");
        ArtifactRepository remoteRepo = this.artifactRepositoryFactory.createArtifactRepository(this.repositoryId, this.repositoryUrl, this.repositoryLayout, always, always);
        if (this.pomRemoteRepositories == null) {
            this.pomRemoteRepositories = new ArrayList();
        }
        ArrayList<String> repoList = new ArrayList<String>(this.pomRemoteRepositories);
        if (this.remoteRepositories != null) {
            repoList.addAll(Arrays.asList(StringUtils.split((String)this.remoteRepositories, (String)",")));
        }
        repoList.add((String)remoteRepo);
        try {
            if (this.transitive) {
                this.artifactResolver.resolveTransitively(Collections.singleton(toDownload), dummyOriginatingArtifact, repoList, this.localRepository, this.source);
            } else {
                this.artifactResolver.resolve(toDownload, repoList, this.localRepository);
            }
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

