/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.utils.SilentLog;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReflectionUtils;

public abstract class AbstractDependencyMojo
extends AbstractMojo {
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected ArtifactCollector artifactCollector;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactRepository local;
    protected List remoteRepos;
    protected ArchiverManager archiverManager;
    protected MavenProject project;
    protected List reactorProjects;
    public boolean silent;
    protected boolean outputAbsoluteArtifactFilename;
    private Log log;

    public Log getLog() {
        this.log = this.silent ? new SilentLog() : super.getLog();
        return this.log;
    }

    public ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }

    protected void copyFile(File artifact, File destFile) throws MojoExecutionException {
        Log theLog = this.getLog();
        try {
            theLog.info((CharSequence)("Copying " + (this.outputAbsoluteArtifactFilename ? artifact.getAbsolutePath() : artifact.getName()) + " to " + destFile));
            FileUtils.copyFile((File)artifact, (File)destFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying artifact from " + artifact + " to " + destFile, e);
        }
    }

    protected void unpack(File file, File location) throws MojoExecutionException {
        try {
            location.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(file);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            if (this.silent) {
                this.silenceUnarchiver(unArchiver);
            }
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error unpacking file: " + (this.outputAbsoluteArtifactFilename ? file.getAbsolutePath() : file.getName()) + " to: " + location + "\r\n" + e.toString(), (Exception)e);
        }
        catch (ArchiverException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + location + "\r\n" + e.toString(), (Exception)((Object)e));
        }
    }

    private void silenceUnarchiver(UnArchiver unArchiver) {
        try {
            Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)"logger", unArchiver.getClass());
            ((AccessibleObject)field).setAccessible(true);
            field.set(unArchiver, this.getLog());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ArtifactFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ArtifactFactory factory) {
        this.factory = factory;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public ArtifactRepository getLocal() {
        return this.local;
    }

    public void setLocal(ArtifactRepository local) {
        this.local = local;
    }

    public List getRemoteRepos() {
        return this.remoteRepos;
    }

    public void setRemoteRepos(List remoteRepos) {
        this.remoteRepos = remoteRepos;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    public void setArchiverManager(ArchiverManager archiverManager) {
        this.archiverManager = archiverManager;
    }

    public ArtifactCollector getArtifactCollector() {
        return this.artifactCollector;
    }

    public void setArtifactCollector(ArtifactCollector theArtifactCollector) {
        this.artifactCollector = theArtifactCollector;
    }

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public void setArtifactMetadataSource(ArtifactMetadataSource theArtifactMetadataSource) {
        this.artifactMetadataSource = theArtifactMetadataSource;
    }
}

