/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils.filters;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.dependency.utils.filters.AbstractArtifactsFilter;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractArtifactFeatureFilter
extends AbstractArtifactsFilter {
    private List includes;
    private List excludes;
    private String includeString;
    private String excludeString;
    private String featureName;

    public AbstractArtifactFeatureFilter(String include, String exclude, String theFeatureName) {
        this.setExcludes(exclude);
        this.setIncludes(include);
        this.featureName = theFeatureName;
    }

    public Set filter(Set artifacts, Log log) {
        Set results = artifacts;
        if (this.includes != null && !this.includes.isEmpty()) {
            log.debug((CharSequence)("Including only " + this.featureName + ": " + this.includeString));
            results = this.filterIncludes(artifacts, this.includes);
        } else if (this.excludes != null && !this.excludes.isEmpty()) {
            log.debug((CharSequence)("Excluding " + this.featureName + ": " + this.excludeString));
            results = this.filterExcludes(artifacts, this.excludes);
        }
        return results;
    }

    private Set filterIncludes(Set artifacts, List theIncludes) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Iterator includeIter = theIncludes.iterator();
        while (includeIter.hasNext()) {
            String include = (String)includeIter.next();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                if (!this.getArtifactFeature(artifact).equals(include)) continue;
                result.add(artifact);
            }
        }
        return result;
    }

    private Set filterExcludes(Set artifacts, List theExcludes) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            boolean exclude = false;
            Artifact artifact = (Artifact)iter.next();
            String artifactFeature = this.getArtifactFeature(artifact);
            Iterator excludeIter = theExcludes.iterator();
            while (excludeIter.hasNext()) {
                String excludeFeature = (String)excludeIter.next();
                if (!artifactFeature.equals(excludeFeature)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            result.add(artifact);
        }
        return result;
    }

    protected abstract String getArtifactFeature(Artifact var1);

    public void setExcludes(String excludeString) {
        this.excludeString = excludeString;
        if (StringUtils.isNotEmpty((String)excludeString)) {
            this.excludes = Arrays.asList(StringUtils.split((String)excludeString, (String)","));
        }
    }

    public void setIncludes(String includeString) {
        this.includeString = includeString;
        if (StringUtils.isNotEmpty((String)includeString)) {
            this.includes = Arrays.asList(StringUtils.split((String)includeString, (String)","));
        }
    }

    public List getExcludes() {
        return this.excludes;
    }

    public List getIncludes() {
        return this.includes;
    }
}

