/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.fromConfiguration;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.fromConfiguration.AbstractFromConfigurationMojo;
import org.apache.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.plugin.dependency.utils.filters.MarkerFileFilter;
import org.apache.maven.plugin.dependency.utils.markers.DefaultFileMarkerHandler;

public final class UnpackMojo
extends AbstractFromConfigurationMojo {
    private File markersDirectory;

    public void execute() throws MojoExecutionException {
        ArrayList processedItems = this.getProcessedArtifactItems(false);
        Iterator iter = ((AbstractList)processedItems).iterator();
        while (iter.hasNext()) {
            ArtifactItem artifactItem = (ArtifactItem)iter.next();
            if (artifactItem.isNeedsProcessing()) {
                this.unpackArtifact(artifactItem);
                continue;
            }
            this.getLog().info((CharSequence)(artifactItem.getArtifact().getFile().getName() + " already unpacked."));
        }
    }

    private void unpackArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        Artifact artifact = artifactItem.getArtifact();
        DefaultFileMarkerHandler handler = new DefaultFileMarkerHandler(artifact, this.markersDirectory);
        this.unpack(artifact.getFile(), artifactItem.getOutputDirectory());
        handler.setMarker();
    }

    ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem item) {
        DefaultFileMarkerHandler handler = new DefaultFileMarkerHandler(item.getArtifact(), this.markersDirectory);
        return new MarkerFileFilter(this.isOverWriteReleases(), this.isOverWriteSnapshots(), this.isOverWriteIfNewer(), handler);
    }

    public File getMarkersDirectory() {
        return this.markersDirectory;
    }

    public void setMarkersDirectory(File theMarkersDirectory) {
        this.markersDirectory = theMarkersDirectory;
    }
}

