/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.apache.maven.api.PathType;
import org.apache.maven.plugin.compiler.ModuleInfoOverwrite;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.SourceFile;

final class SourcesForRelease
implements Closeable {
    final SourceVersion release;
    final List<Path> files;
    final Map<String, Set<Path>> roots;
    private final Map<SourceDirectory, ModuleInfoOverwrite> moduleInfos;
    private SourceDirectory lastDirectoryAdded;
    Map<PathType, Collection<Path>> dependencySnapshot;
    Path outputForRelease;

    SourcesForRelease(SourceVersion release) {
        this.release = release;
        this.files = new ArrayList<Path>();
        this.roots = new LinkedHashMap<String, Set<Path>>();
        this.moduleInfos = new LinkedHashMap<SourceDirectory, ModuleInfoOverwrite>();
    }

    String getReleaseString() {
        if (this.release == null) {
            return null;
        }
        String version = this.release.name();
        return version.substring(version.lastIndexOf(95) + 1);
    }

    void add(SourceFile source) {
        SourceDirectory directory = source.directory;
        if (this.lastDirectoryAdded != directory) {
            this.lastDirectoryAdded = directory;
            String moduleName = directory.moduleName;
            if (moduleName == null || moduleName.isBlank()) {
                moduleName = "";
            }
            this.roots.get(moduleName).add(directory.root);
            directory.getModuleInfo().ifPresent(path -> this.moduleInfos.put(directory, null));
        }
        this.files.add(source.file);
    }

    @Override
    public void close() throws IOException {
        IOException error = null;
        for (Map.Entry<SourceDirectory, ModuleInfoOverwrite> entry : this.moduleInfos.entrySet()) {
            ModuleInfoOverwrite mo = entry.getValue();
            if (mo == null) continue;
            entry.setValue(null);
            try {
                mo.restore();
            }
            catch (IOException e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        if (error != null) {
            throw error;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        if (this.release != null) {
            sb.append((Object)this.release).append(": ");
        }
        return sb.append(this.files.size()).append(" files]").toString();
    }
}

