/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.nio.file.Path;
import java.util.Locale;
import javax.lang.model.SourceVersion;

public enum DirectoryHierarchy {
    PACKAGE("versions"),
    PACKAGE_WITH_MODULE("versions"),
    MODULE_SOURCE("versions-modular");

    static final String META_INF = "META-INF";
    private final String versionDirectory;

    private DirectoryHierarchy(String versionDirectory) {
        this.versionDirectory = versionDirectory;
    }

    public Path outputDirectoryForReleases(Path outputDirectory) {
        return outputDirectory.resolve(META_INF).resolve(this.versionDirectory);
    }

    public Path outputDirectoryForReleases(Path outputDirectory, SourceVersion release) {
        if (release == null) {
            release = SourceVersion.latestSupported();
        }
        String version = release.name();
        version = version.substring(version.lastIndexOf(95) + 1);
        return this.outputDirectoryForReleases(outputDirectory).resolve(version);
    }

    public String toString() {
        return this.name().replace('_', ' ').toLowerCase(Locale.US);
    }
}

