/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.maven.api.plugin.Log;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ModuleVisitor;

final class ByteCodeTransformer {
    private ByteCodeTransformer() {
    }

    static byte[] patchJdkModuleVersion(byte[] originalBytecode, final String javaVersion, Log log) {
        final ArrayList modulesModified = new ArrayList();
        final HashSet foundVersions = new HashSet();
        ClassReader reader = new ClassReader(originalBytecode);
        ClassWriter writer = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(589824, (ClassVisitor)writer){

            public ModuleVisitor visitModule(String name, int access, String version) {
                ModuleVisitor originalModuleVisitor = super.visitModule(name, access, version);
                return new ModuleVisitor(this, 589824, originalModuleVisitor){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0, arg1);
                    }

                    public void visitRequire(String module, int access, String version) {
                        if (version != null && (module.startsWith("java.") || module.startsWith("jdk."))) {
                            super.visitRequire(module, access, javaVersion);
                            foundVersions.add(version);
                            modulesModified.add(module);
                        } else {
                            super.visitRequire(module, access, version);
                        }
                    }
                };
            }
        };
        reader.accept(classVisitor, 0);
        if (modulesModified.isEmpty()) {
            return null;
        }
        log.info((CharSequence)String.format("JDK-8318913 workaround: patched module-info.class requires version from %s to [%s] on %d JDK modules %s", foundVersions, javaVersion, modulesModified.size(), modulesModified));
        return writer.toByteArray();
    }
}

