/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.apache.maven.plugin.compiler.ModuleInfoOverwrite;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.SourceFile;

final class SourcesForRelease
implements Closeable {
    final SourceVersion release;
    final List<Path> files;
    final Map<String, Set<Path>> roots;
    private final Map<SourceDirectory, ModuleInfoOverwrite> moduleInfos;
    private SourceDirectory lastDirectoryAdded;

    private SourcesForRelease(SourceVersion release) {
        this.release = release;
        this.roots = new LinkedHashMap<String, Set<Path>>();
        this.files = new ArrayList<Path>(256);
        this.moduleInfos = new LinkedHashMap<SourceDirectory, ModuleInfoOverwrite>();
    }

    private void add(SourceFile source) {
        SourceDirectory directory = source.directory;
        if (this.lastDirectoryAdded != directory) {
            this.lastDirectoryAdded = directory;
            String moduleName = directory.moduleName;
            if (moduleName == null) {
                moduleName = "";
            }
            this.roots.computeIfAbsent(moduleName, key -> new LinkedHashSet()).add(directory.root);
            directory.getModuleInfo().ifPresent(path -> this.moduleInfos.put(directory, null));
        }
        this.files.add(source.file);
    }

    public static Collection<SourcesForRelease> groupByReleaseAndModule(List<SourceFile> sources) {
        EnumMap<SourceVersion, SourcesForRelease> result = new EnumMap<SourceVersion, SourcesForRelease>(SourceVersion.class);
        for (SourceFile source : sources) {
            SourceVersion release = source.directory.release;
            if (release == null) {
                release = SourceVersion.RELEASE_0;
            }
            result.computeIfAbsent(release, SourcesForRelease::new).add(source);
        }
        return result.values();
    }

    void substituteModuleInfos(Path mainOutputDirectory, Path testOutputDirectory) throws IOException {
        for (Map.Entry<SourceDirectory, ModuleInfoOverwrite> entry : this.moduleInfos.entrySet()) {
            Path main = mainOutputDirectory;
            Path test = testOutputDirectory;
            SourceDirectory directory = entry.getKey();
            String moduleName = directory.moduleName;
            if (moduleName != null) {
                if (!Files.isDirectory(main = main.resolve(moduleName), new LinkOption[0])) {
                    main = mainOutputDirectory;
                }
                if (!Files.isDirectory(test = test.resolve(moduleName), new LinkOption[0])) {
                    test = testOutputDirectory;
                }
            }
            Path source = directory.getModuleInfo().orElseThrow();
            entry.setValue(ModuleInfoOverwrite.create(source, main, test));
        }
    }

    @Override
    public void close() throws IOException {
        IOException error = null;
        for (Map.Entry<SourceDirectory, ModuleInfoOverwrite> entry : this.moduleInfos.entrySet()) {
            ModuleInfoOverwrite mo = entry.getValue();
            if (mo == null) continue;
            entry.setValue(null);
            try {
                mo.restore();
            }
            catch (IOException e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        if (error != null) {
            throw error;
        }
    }
}

