/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler.module;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Set;
import org.apache.maven.plugin.compiler.module.JavaModuleDescriptor;
import org.apache.maven.plugin.compiler.module.ModuleInfoParser;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ModuleInfoParser.class, hint="reflect")
public class ReflectModuleInfoParser
implements ModuleInfoParser {
    @Override
    public ModuleInfoParser.Type getType() {
        return ModuleInfoParser.Type.CLASS;
    }

    @Override
    public JavaModuleDescriptor getModuleDescriptor(File modulePath) throws IOException {
        JavaModuleDescriptor moduleDescriptor = null;
        try {
            Class<?> moduleFinderClass = Class.forName("java.lang.module.ModuleFinder");
            Path path = modulePath.toPath();
            Method ofMethod = moduleFinderClass.getMethod("of", Path[].class);
            Object moduleFinderInstance = ofMethod.invoke(null, new Object[]{new Path[]{path}});
            Method findAllMethod = moduleFinderClass.getMethod("findAll", new Class[0]);
            Set moduleReferences = (Set)findAllMethod.invoke(moduleFinderInstance, new Object[0]);
            Object moduleReference = moduleReferences.iterator().next();
            Method descriptorMethod = moduleReference.getClass().getMethod("descriptor", new Class[0]);
            Object moduleDescriptorInstance = descriptorMethod.invoke(moduleReference, new Object[0]);
            JavaModuleDescriptor.Builder builder = this.getBuilder(moduleDescriptorInstance);
            Method requiresMethod = moduleDescriptorInstance.getClass().getMethod("requires", new Class[0]);
            Set requires = (Set)requiresMethod.invoke(moduleDescriptorInstance, new Object[0]);
            for (Object requiresInstance : requires) {
                Method nameMethod = requiresInstance.getClass().getMethod("name", new Class[0]);
                String name = (String)nameMethod.invoke(requiresInstance, new Object[0]);
                builder.requires(name);
            }
            moduleDescriptor = builder.build();
        }
        catch (ClassNotFoundException moduleFinderClass) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return moduleDescriptor;
    }

    private JavaModuleDescriptor.Builder getBuilder(Object moduleDescriptorInstance) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method nameMethod = moduleDescriptorInstance.getClass().getMethod("name", new Class[0]);
        String name = (String)nameMethod.invoke(moduleDescriptorInstance, new Object[0]);
        Method isAutomaticMethod = moduleDescriptorInstance.getClass().getMethod("isAutomatic", new Class[0]);
        boolean automatic = (Boolean)isAutomaticMethod.invoke(moduleDescriptorInstance, new Object[0]);
        JavaModuleDescriptor.Builder builder = automatic ? JavaModuleDescriptor.newAutomaticModule(name) : JavaModuleDescriptor.newModule(name);
        return builder;
    }
}

