/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;
    private static final String PLUGIN_HELP_PATH = "/META-INF/maven/org.apache.maven.plugins/maven-compiler-plugin/plugin-help.xml";

    private Xpp3Dom build() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"load plugin-help.xml: /META-INF/maven/org.apache.maven.plugins/maven-compiler-plugin/plugin-help.xml");
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(PLUGIN_HELP_PATH);
        try {
            return Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((InputStream)is));
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        Xpp3Dom pluginElement = this.build();
        StringBuilder sb = new StringBuilder();
        String name = pluginElement.getChild("name").getValue();
        String version = pluginElement.getChild("version").getValue();
        String id = pluginElement.getChild("groupId").getValue() + ":" + pluginElement.getChild("artifactId").getValue() + ":" + version;
        if (StringUtils.isNotEmpty((String)name) && !name.contains(id)) {
            this.append(sb, name + " " + version, 0);
        } else if (StringUtils.isNotEmpty((String)name)) {
            this.append(sb, name, 0);
        } else {
            this.append(sb, id, 0);
        }
        this.append(sb, pluginElement.getChild("description").getValue(), 1);
        this.append(sb, "", 0);
        String goalPrefix = pluginElement.getChild("goalPrefix").getValue();
        Xpp3Dom[] mojos = pluginElement.getChild("mojos").getChildren("mojo");
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has " + mojos.length + (mojos.length > 1 ? " goals:" : " goal:"), 0);
            this.append(sb, "", 0);
        }
        for (Xpp3Dom mojo : mojos) {
            this.writeGoal(sb, goalPrefix, mojo);
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private String getValue(Xpp3Dom mojo, String child) {
        Xpp3Dom elt = mojo.getChild(child);
        return elt == null ? "" : elt.getValue();
    }

    private void writeGoal(StringBuilder sb, String goalPrefix, Xpp3Dom mojo) {
        String mojoGoal = mojo.getChild("goal").getValue();
        Xpp3Dom configurationElement = mojo.getChild("configuration");
        if (this.goal == null || this.goal.length() <= 0 || mojoGoal.equals(this.goal)) {
            this.append(sb, goalPrefix + ":" + mojoGoal, 0);
            Xpp3Dom deprecated = mojo.getChild("deprecated");
            if (deprecated != null && StringUtils.isNotEmpty((String)deprecated.getValue())) {
                this.append(sb, "Deprecated. " + deprecated, 1);
                if (this.detail) {
                    this.append(sb, "", 0);
                    this.append(sb, this.getValue(mojo, "description"), 1);
                }
            } else {
                this.append(sb, this.getValue(mojo, "description"), 1);
            }
            this.append(sb, "", 0);
            if (this.detail) {
                Xpp3Dom[] parameters = mojo.getChild("parameters").getChildren("parameter");
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                for (Xpp3Dom parameter : parameters) {
                    this.writeParameter(sb, parameter, configurationElement);
                }
            }
        }
    }

    private void writeParameter(StringBuilder sb, Xpp3Dom parameter, Xpp3Dom configurationElement) {
        Xpp3Dom expression;
        String parameterName = parameter.getChild("name").getValue();
        String parameterDescription = parameter.getChild("description").getValue();
        Xpp3Dom fieldConfigurationElement = configurationElement.getChild(parameterName);
        String parameterDefaultValue = "";
        if (fieldConfigurationElement != null && fieldConfigurationElement.getValue() != null) {
            parameterDefaultValue = " (Default: " + fieldConfigurationElement.getAttribute("default-value") + ")";
        }
        this.append(sb, parameterName + parameterDefaultValue, 2);
        Xpp3Dom deprecated = parameter.getChild("deprecated");
        if (deprecated != null && StringUtils.isNotEmpty((String)deprecated.getValue())) {
            this.append(sb, "Deprecated. " + deprecated.getValue(), 3);
            this.append(sb, "", 0);
        }
        this.append(sb, parameterDescription, 3);
        if ("true".equals(parameter.getChild("required").getValue())) {
            this.append(sb, "Required: Yes", 3);
        }
        if ((expression = parameter.getChild("expression")) != null && StringUtils.isNotEmpty((String)expression.getValue())) {
            this.append(sb, "Expression: " + expression.getValue(), 3);
        }
        this.append(sb, "", 0);
    }

    private static String repeat(String str, int repeat) {
        StringBuilder buffer = new StringBuilder(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuilder sb, String description, int indent) {
        for (String line : HelpMojo.toLines(description, indent, this.indentSize, this.lineLength)) {
            sb.append(line).append('\n');
        }
    }

    private static List<String> toLines(String text, int indent, int indentSize, int lineLength) {
        String[] plainLines;
        ArrayList<String> lines = new ArrayList<String>();
        String ind = HelpMojo.repeat("\t", indent);
        for (String plainLine : plainLines = text.split("(\r\n)|(\r)|(\n)")) {
            HelpMojo.toLines(lines, ind + plainLine, indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List<String> lines, String line, int indentSize, int lineLength) {
        String[] tokens;
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuilder buf = new StringBuilder(256);
        for (String token : tokens = line.split(" +")) {
            if (buf.length() > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

