/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.plugins.checkstyle.RuleUtil;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleResults;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;

public class CheckstyleReportRenderer
extends AbstractMavenReportRenderer {
    private static final int NO_TEXT = 0;
    private static final int TEXT_SIMPLE = 1;
    private static final int TEXT_TITLE = 2;
    private static final int TEXT_ABBREV = 3;
    private final I18N i18n;
    private final Locale locale;
    private final MavenProject project;
    private final Configuration checkstyleConfig;
    private final boolean enableRulesSummary;
    private final boolean enableSeveritySummary;
    private final boolean enableFilesSummary;
    private final SiteTool siteTool;
    private String xrefLocation;
    private String xrefTestLocation;
    private List<File> testSourceDirectories = new ArrayList<File>();
    private List<String> treeWalkerNames = Collections.singletonList("TreeWalker");
    private final String ruleset;
    private final CheckstyleResults results;

    public CheckstyleReportRenderer(Sink sink, I18N i18n, Locale locale, MavenProject project, SiteTool siteTool, String ruleset, boolean enableRulesSummary, boolean enableSeveritySummary, boolean enableFilesSummary, CheckstyleResults results) {
        super(sink);
        this.i18n = i18n;
        this.locale = locale;
        this.project = project;
        this.siteTool = siteTool;
        this.ruleset = ruleset;
        this.enableRulesSummary = enableRulesSummary;
        this.enableSeveritySummary = enableSeveritySummary;
        this.enableFilesSummary = enableFilesSummary;
        this.results = results;
        this.checkstyleConfig = results.getConfiguration();
    }

    public String getTitle() {
        return this.getI18nString("title");
    }

    private String getI18nString(String key) {
        return this.i18n.getString("checkstyle-report", this.locale, "report.checkstyle." + key);
    }

    protected void renderBody() {
        this.startSection(this.getTitle());
        this.sink.paragraph();
        this.sink.text(this.getI18nString("checkstylelink") + " ");
        this.sink.link("https://checkstyle.org/");
        this.sink.text("Checkstyle");
        this.sink.link_();
        String version = this.getCheckstyleVersion();
        if (version != null) {
            this.sink.text(" ");
            this.sink.text(version);
        }
        this.sink.text(" ");
        this.sink.text(String.format(this.getI18nString("ruleset"), this.ruleset));
        this.sink.text(".");
        this.sink.paragraph_();
        this.renderSeveritySummarySection();
        this.renderFilesSummarySection();
        this.renderRulesSummarySection();
        this.renderDetailsSection();
        this.endSection();
    }

    private String getConfigAttribute(Configuration config, ChainedItem<Configuration> parentConfiguration, String attributeName, String defaultValue) {
        String ret;
        try {
            ret = config.getAttribute(attributeName);
        }
        catch (CheckstyleException e) {
            ret = parentConfiguration != null ? this.getConfigAttribute((Configuration)((ChainedItem)parentConfiguration).value, ((ChainedItem)parentConfiguration).parent, attributeName, defaultValue) : defaultValue;
        }
        return ret;
    }

    private void renderRulesSummarySection() {
        if (!this.enableRulesSummary) {
            return;
        }
        if (this.checkstyleConfig == null) {
            return;
        }
        this.startSection(this.getI18nString("rules"));
        this.startTable();
        this.tableHeader(new String[]{this.getI18nString("rule.category"), this.getI18nString("rule"), this.getI18nString("violations"), this.getI18nString("column.severity")});
        if ("checker".equalsIgnoreCase(this.checkstyleConfig.getName())) {
            String category = null;
            for (ConfReference ref : this.sortConfiguration(this.results)) {
                this.renderRuleRow(ref, this.results, category);
                category = ref.category;
            }
        } else {
            this.tableRow(new String[]{this.getI18nString("norule")});
        }
        this.endTable();
        this.endSection();
    }

    private void renderRuleRow(ConfReference ref, CheckstyleResults results, String previousCategory) {
        Configuration checkerConfig = ref.configuration;
        ChainedItem parentConfiguration = ref.parentConfiguration;
        String ruleName = checkerConfig.getName();
        this.sink.tableRow();
        this.sink.tableCell();
        String category = ref.category;
        if (!category.equals(previousCategory)) {
            this.sink.text(category);
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (!"extension".equals(category)) {
            this.sink.link("https://checkstyle.org/config_" + category + ".html#" + ruleName);
            this.sink.text(ruleName);
            this.sink.link_();
        } else {
            this.sink.text(ruleName);
        }
        ArrayList<String> attribnames = new ArrayList<String>(Arrays.asList(checkerConfig.getAttributeNames()));
        attribnames.remove("severity");
        if (!attribnames.isEmpty()) {
            this.sink.list();
            for (String name : attribnames) {
                this.sink.listItem();
                this.sink.text(name);
                String value = this.getConfigAttribute(checkerConfig, null, name, "");
                if ("header".equals(name) && ("Header".equals(ruleName) || "RegexpHeader".equals(ruleName))) {
                    String[] lines = StringUtils.split((String)value, (String)"\\n");
                    int linenum = 1;
                    for (String line : lines) {
                        this.sink.lineBreak();
                        this.sink.rawText("<span style=\"color: gray\">");
                        this.sink.text(linenum + ":");
                        this.sink.rawText("</span>");
                        this.sink.nonBreakingSpace();
                        this.sink.monospaced();
                        this.sink.text(line);
                        this.sink.monospaced_();
                        ++linenum;
                    }
                } else if ("headerFile".equals(name) && "RegexpHeader".equals(ruleName)) {
                    this.sink.text(": ");
                    this.sink.monospaced();
                    this.sink.text("\"");
                    String path = this.siteTool.getRelativePath(value, this.project.getBasedir().getAbsolutePath());
                    this.sink.text(path.replace('\\', '/'));
                    this.sink.text(value);
                    this.sink.text("\"");
                    this.sink.monospaced_();
                } else {
                    this.sink.text(": ");
                    this.sink.monospaced();
                    this.sink.text("\"");
                    this.sink.text(value);
                    this.sink.text("\"");
                    this.sink.monospaced_();
                }
                this.sink.listItem_();
            }
            this.sink.list_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(String.valueOf(ref.violations));
        this.sink.tableCell_();
        this.sink.tableCell();
        String severity = this.getConfigAttribute(checkerConfig, parentConfiguration, "severity", "error");
        this.iconSeverity(severity, 1);
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    public boolean matchRule(AuditEvent event, String ruleName, String expectedMessage, String expectedSeverity) {
        if (!ruleName.equals(RuleUtil.getName(event))) {
            return false;
        }
        if (expectedMessage != null) {
            String msgWithoutSingleQuote = StringUtils.replace((String)expectedMessage, (String)"'", (String)"");
            if (!expectedMessage.equals(event.getMessage()) && !msgWithoutSingleQuote.equals(event.getMessage())) {
                return false;
            }
        }
        return expectedSeverity == null || expectedSeverity.equals(event.getSeverityLevel().getName());
    }

    private void renderSeveritySummarySection() {
        if (!this.enableSeveritySummary) {
            return;
        }
        this.startSection(this.getI18nString("summary"));
        this.startTable();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.getI18nString("files"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconSeverity("info", 2);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconSeverity("warning", 2);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconSeverity("error", 2);
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        this.tableRow(new String[]{String.valueOf(this.results.getFileCount()), String.valueOf(this.results.getSeverityCount(SeverityLevel.INFO)), String.valueOf(this.results.getSeverityCount(SeverityLevel.WARNING)), String.valueOf(this.results.getSeverityCount(SeverityLevel.ERROR))});
        this.endTable();
        this.endSection();
    }

    private void renderFilesSummarySection() {
        if (!this.enableFilesSummary) {
            return;
        }
        this.startSection(this.getI18nString("files"));
        this.startTable();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.getI18nString("file"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconSeverity("info", 3);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconSeverity("warning", 3);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconSeverity("error", 3);
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        ArrayList<String> fileList = new ArrayList<String>(this.results.getFiles().keySet());
        Collections.sort(fileList);
        for (String filename : fileList) {
            List<AuditEvent> violations = this.results.getFileViolations(filename);
            if (violations.isEmpty()) continue;
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.link("#" + DoxiaUtils.encodeId((String)filename));
            this.sink.text(filename);
            this.sink.link_();
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(String.valueOf(this.results.getSeverityCount(violations, SeverityLevel.INFO)));
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(String.valueOf(this.results.getSeverityCount(violations, SeverityLevel.WARNING)));
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(String.valueOf(this.results.getSeverityCount(violations, SeverityLevel.ERROR)));
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.endTable();
        this.endSection();
    }

    private void renderDetailsSection() {
        this.startSection(this.getI18nString("details"));
        ArrayList<String> fileList = new ArrayList<String>(this.results.getFiles().keySet());
        Collections.sort(fileList);
        for (String file : fileList) {
            List<AuditEvent> violations = this.results.getFileViolations(file);
            if (violations.isEmpty()) continue;
            this.startSection(file);
            this.startTable();
            this.tableHeader(new String[]{this.getI18nString("column.severity"), this.getI18nString("rule.category"), this.getI18nString("rule"), this.getI18nString("column.message"), this.getI18nString("column.line")});
            this.renderFileEvents(violations, file);
            this.endTable();
            this.endSection();
        }
        this.endSection();
    }

    private void renderFileEvents(List<AuditEvent> eventList, String filename) {
        for (AuditEvent event : eventList) {
            SeverityLevel level = event.getSeverityLevel();
            this.sink.tableRow();
            this.sink.tableCell();
            this.iconSeverity(level.getName(), 1);
            this.sink.tableCell_();
            this.sink.tableCell();
            String category = RuleUtil.getCategory(event);
            if (category != null) {
                this.sink.text(category);
            }
            this.sink.tableCell_();
            this.sink.tableCell();
            String ruleName = RuleUtil.getName(event);
            if (ruleName != null) {
                this.sink.text(ruleName);
            }
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(event.getMessage());
            this.sink.tableCell_();
            this.sink.tableCell();
            int line = event.getLine();
            String effectiveXrefLocation = this.getEffectiveXrefLocation(eventList);
            if (effectiveXrefLocation != null && line != 0) {
                this.sink.link(effectiveXrefLocation + "/" + filename.replaceAll("\\.java$", ".html") + "#L" + line);
                this.sink.text(String.valueOf(line));
                this.sink.link_();
            } else if (line != 0) {
                this.sink.text(String.valueOf(line));
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
    }

    private String getEffectiveXrefLocation(List<AuditEvent> eventList) {
        String absoluteFilename = eventList.get(0).getFileName();
        if (this.isTestSource(absoluteFilename)) {
            return this.getXrefTestLocation();
        }
        return this.getXrefLocation();
    }

    private boolean isTestSource(String absoluteFilename) {
        for (File testSourceDirectory : this.testSourceDirectories) {
            if (!absoluteFilename.startsWith(testSourceDirectory.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public String getXrefLocation() {
        return this.xrefLocation;
    }

    public void setXrefLocation(String xrefLocation) {
        this.xrefLocation = xrefLocation;
    }

    public String getXrefTestLocation() {
        return this.xrefTestLocation;
    }

    public void setXrefTestLocation(String xrefTestLocation) {
        this.xrefTestLocation = xrefTestLocation;
    }

    public void setTestSourceDirectories(List<File> testSourceDirectories) {
        this.testSourceDirectories = testSourceDirectories;
    }

    public void setTreeWalkerNames(List<String> treeWalkerNames) {
        this.treeWalkerNames = treeWalkerNames;
    }

    private void iconSeverity(String level, int textType) {
        this.sink.figureGraphics("images/icon_" + level + "_sml.gif");
        if (textType > 0) {
            String suffix;
            this.sink.nonBreakingSpace();
            switch (textType) {
                case 2: {
                    suffix = "s";
                    break;
                }
                case 3: {
                    suffix = "s.abbrev";
                    break;
                }
                default: {
                    suffix = "";
                }
            }
            this.sink.text(this.getI18nString(level + suffix));
        }
    }

    private String getCheckstyleVersion() {
        Package checkstyleApiPackage = Configuration.class.getPackage();
        return checkstyleApiPackage == null ? null : checkstyleApiPackage.getImplementationVersion();
    }

    public List<ConfReference> sortConfiguration(CheckstyleResults results) {
        ArrayList<ConfReference> result = new ArrayList<ConfReference>();
        this.sortConfiguration(result, this.checkstyleConfig, null, results);
        Collections.sort(result);
        return result;
    }

    private void sortConfiguration(List<ConfReference> result, Configuration config, ChainedItem<Configuration> parent, CheckstyleResults results) {
        for (Configuration childConfig : config.getChildren()) {
            String ruleName = childConfig.getName();
            if (this.treeWalkerNames.contains(ruleName)) {
                this.sortConfiguration(result, childConfig, new ChainedItem<Configuration>(config, parent), results);
                continue;
            }
            String fixedmessage = this.getConfigAttribute(childConfig, null, "message", null);
            String configSeverity = this.getConfigAttribute(childConfig, null, "severity", null);
            long violations = 0L;
            AuditEvent lastMatchedEvent = null;
            for (List<AuditEvent> errors : results.getFiles().values()) {
                for (AuditEvent event : errors) {
                    if (!this.matchRule(event, ruleName, fixedmessage, configSeverity)) continue;
                    lastMatchedEvent = event;
                    ++violations;
                }
            }
            if (violations <= 0L) continue;
            String category = RuleUtil.getCategory(lastMatchedEvent);
            result.add(new ConfReference(category, childConfig, parent, violations, result.size()));
        }
    }

    private static class ChainedItem<T> {
        private final ChainedItem<T> parent;
        private final T value;

        ChainedItem(T value, ChainedItem<T> parent) {
            this.parent = parent;
            this.value = value;
        }
    }

    private static class ConfReference
    implements Comparable<ConfReference> {
        private final String category;
        private final Configuration configuration;
        private final ChainedItem<Configuration> parentConfiguration;
        private final long violations;
        private final int count;

        ConfReference(String category, Configuration configuration, ChainedItem<Configuration> parentConfiguration, long violations, int count) {
            this.category = category;
            this.configuration = configuration;
            this.parentConfiguration = parentConfiguration;
            this.violations = violations;
            this.count = count;
        }

        @Override
        public int compareTo(ConfReference o) {
            int compare = this.category.compareTo(o.category);
            if (compare == 0) {
                compare = this.configuration.getName().compareTo(o.configuration.getName());
            }
            return compare == 0 ? o.count - this.count : compare;
        }
    }
}

