/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle.rss;

import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.checkstyle.exec.CheckstyleResults;
import org.apache.maven.plugin.checkstyle.rss.CheckstyleRssGenerator;
import org.apache.maven.plugin.checkstyle.rss.CheckstyleRssGeneratorRequest;
import org.apache.maven.plugin.checkstyle.rss.VelocityTemplate;
import org.apache.maven.reporting.MavenReportException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;

@Component(role=CheckstyleRssGenerator.class, hint="default")
public class DefaultCheckstyleRssGenerator
implements CheckstyleRssGenerator {
    @Requirement
    private VelocityComponent velocityComponent;

    @Override
    public void generateRSS(CheckstyleResults results, CheckstyleRssGeneratorRequest checkstyleRssGeneratorRequest) throws MavenReportException {
        VelocityTemplate vtemplate = new VelocityTemplate(this.velocityComponent, "org/apache/maven/plugin/checkstyle");
        vtemplate.setLog(checkstyleRssGeneratorRequest.getLog());
        VelocityContext context = new VelocityContext();
        context.put("results", (Object)results);
        context.put("project", (Object)checkstyleRssGeneratorRequest.getMavenProject());
        context.put("copyright", (Object)checkstyleRssGeneratorRequest.getCopyright());
        context.put("levelInfo", (Object)SeverityLevel.INFO);
        context.put("levelWarning", (Object)SeverityLevel.WARNING);
        context.put("levelError", (Object)SeverityLevel.ERROR);
        context.put("stringutils", (Object)new StringUtils());
        try {
            vtemplate.generate(checkstyleRssGeneratorRequest.getOutputDirectory().getPath() + "/checkstyle.rss", "checkstyle-rss.vm", (Context)context);
        }
        catch (ResourceNotFoundException e) {
            throw new MavenReportException("Unable to find checkstyle-rss.vm resource.", (Exception)((Object)e));
        }
        catch (IOException | MojoExecutionException | VelocityException e) {
            throw new MavenReportException("Unable to generate checkstyle.rss.", (Exception)e);
        }
    }
}

