/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.trac;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.changes.AbstractChangesReport;
import org.apache.maven.plugins.changes.ProjectUtils;
import org.apache.maven.plugins.changes.issues.Issue;
import org.apache.maven.plugins.changes.issues.IssuesReportHelper;
import org.apache.maven.plugins.changes.issues.IssuesReportRenderer;
import org.apache.maven.plugins.changes.trac.TracDownloader;
import org.apache.maven.reporting.MavenReportException;
import org.apache.xmlrpc.XmlRpcException;

@Deprecated
@Mojo(name="trac-changes", threadSafe=true)
public class TracChangesReport
extends AbstractChangesReport {
    private static final Map<String, Integer> TRAC_COLUMNS = new HashMap<String, Integer>();
    @Parameter(defaultValue="Id,Type,Summary,Assignee,Reporter,Priority,Status,Resolution,Created,Updated")
    private String columnNames;
    @Parameter(defaultValue="order=id")
    private String query;
    @Parameter
    private String tracPassword;
    @Parameter
    private String tracUser;

    public boolean canGenerateReport() {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the Trac Report in this project because it's not the Execution Root");
            return false;
        }
        String message = ProjectUtils.validateIssueManagement(this.project, "Trac", "Trac Report");
        if (message != null) {
            this.getLog().warn((CharSequence)message);
        }
        return message == null;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        List<Integer> columnIds = IssuesReportHelper.getColumnIds(this.columnNames, TRAC_COLUMNS);
        if (columnIds.isEmpty()) {
            throw new MavenReportException("maven-changes-plugin: None of the configured columnNames '" + this.columnNames + "' are valid.");
        }
        try {
            TracDownloader issueDownloader = new TracDownloader();
            this.configureIssueDownloader(issueDownloader);
            List<Issue> issueList = issueDownloader.getIssueList();
            IssuesReportRenderer report = new IssuesReportRenderer(this.getSink(), this.getBundle(locale), columnIds, issueList);
            report.render();
        }
        catch (MalformedURLException e) {
            throw new MavenReportException("The Trac URL is incorrect.");
        }
        catch (XmlRpcException e) {
            throw new MavenReportException("XmlRpc Error.", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.issues.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.issues.name");
    }

    @Deprecated
    public String getOutputName() {
        return "trac-changes";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("trac-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void configureIssueDownloader(TracDownloader issueDownloader) {
        issueDownloader.setProject(this.project);
        issueDownloader.setQuery(this.query);
        issueDownloader.setTracPassword(this.tracPassword);
        issueDownloader.setTracUser(this.tracUser);
    }

    static {
        TRAC_COLUMNS.put("Assignee", 0);
        TRAC_COLUMNS.put("Component", 1);
        TRAC_COLUMNS.put("Created", 2);
        TRAC_COLUMNS.put("Fix Version", 3);
        TRAC_COLUMNS.put("Id", 4);
        TRAC_COLUMNS.put("Priority", 6);
        TRAC_COLUMNS.put("Reporter", 7);
        TRAC_COLUMNS.put("Resolution", 8);
        TRAC_COLUMNS.put("Status", 9);
        TRAC_COLUMNS.put("Summary", 10);
        TRAC_COLUMNS.put("Type", 11);
        TRAC_COLUMNS.put("Updated", 12);
    }
}

