/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Author;
import org.apache.maven.plugins.changes.model.Body;
import org.apache.maven.plugins.changes.model.ChangesDocument;
import org.apache.maven.plugins.changes.model.Component;
import org.apache.maven.plugins.changes.model.DueTo;
import org.apache.maven.plugins.changes.model.Properties;
import org.apache.maven.plugins.changes.model.Release;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ChangesXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public ChangesXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public ChangesXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set<String> parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public ChangesDocument read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ChangesDocument changesDocument = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"document".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'document' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'document'", parser, null);
                }
                changesDocument = this.parseChangesDocument(parser, strict);
                changesDocument.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return changesDocument;
        }
        throw new XmlPullParserException("Expected root element 'document' but found no element at all: invalid XML document", parser, null);
    }

    public ChangesDocument read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public ChangesDocument read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public ChangesDocument read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)new XmlStreamReader(in), strict);
    }

    public ChangesDocument read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)new XmlStreamReader(in));
    }

    private Action parseAction(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Action action = new Action();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("dev".equals(name)) {
                action.setDev(this.interpolatedTrimmed(value, "dev"));
                continue;
            }
            if ("due-to".equals(name)) {
                action.setDueTo(this.interpolatedTrimmed(value, "due-to"));
                continue;
            }
            if ("due-to-email".equals(name)) {
                action.setDueToEmail(this.interpolatedTrimmed(value, "due-to-email"));
                continue;
            }
            if ("issue".equals(name)) {
                action.setIssue(this.interpolatedTrimmed(value, "issue"));
                continue;
            }
            if ("type".equals(name)) {
                action.setType(this.interpolatedTrimmed(value, "type"));
                continue;
            }
            if ("system".equals(name)) {
                action.setSystem(this.interpolatedTrimmed(value, "system"));
                continue;
            }
            if ("date".equals(name)) {
                action.setDate(this.interpolatedTrimmed(value, "date"));
                continue;
            }
            if ("fixed-issues".equals(name)) {
                action.setFixedIssuesString(this.interpolatedTrimmed(value, "fixed-issues"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        action.setAction(this.interpolatedTrimmed(parser.nextText(), "action"));
        return action;
    }

    private Author parseAuthor(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Author author = new Author();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("email".equals(name)) {
                author.setAuthorEmail(this.interpolatedTrimmed(value, "email"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        author.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
        return author;
    }

    private Body parseBody(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Body body = new Body();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("release".equals(parser.getName())) {
                List<Release> releases = body.getReleases();
                if (releases == null) {
                    releases = new ArrayList<Release>();
                }
                releases.add(this.parseRelease(parser, strict));
                body.setReleases(releases);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return body;
    }

    private ChangesDocument parseChangesDocument(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ChangesDocument changesDocument = new ChangesDocument();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                changesDocument.setProperties(this.parseProperties(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "body", null, parsed)) {
                changesDocument.setBody(this.parseBody(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return changesDocument;
    }

    private Component parseComponent(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Component component = new Component();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                component.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                component.setDescription(this.interpolatedTrimmed(parser.nextText(), "description"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "actions", null, parsed)) {
                ArrayList<Action> actions = new ArrayList<Action>();
                while (parser.nextTag() == 2) {
                    if ("action".equals(parser.getName())) {
                        actions.add(this.parseAction(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                component.setActions(actions);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return component;
    }

    private DueTo parseDueTo(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DueTo dueTo = new DueTo();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                dueTo.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("email".equals(name)) {
                dueTo.setEmail(this.interpolatedTrimmed(value, "email"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return dueTo;
    }

    private Properties parseProperties(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Properties properties = new Properties();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "title", null, parsed)) {
                properties.setTitle(this.interpolatedTrimmed(parser.nextText(), "title"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "author", null, parsed)) {
                properties.setAuthor(this.parseAuthor(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return properties;
    }

    private Release parseRelease(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Release release = new Release();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("version".equals(name)) {
                release.setVersion(this.interpolatedTrimmed(value, "version"));
                continue;
            }
            if ("date".equals(name)) {
                release.setDateRelease(this.interpolatedTrimmed(value, "date"));
                continue;
            }
            if ("description".equals(name)) {
                release.setDescription(this.interpolatedTrimmed(value, "description"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("action".equals(parser.getName())) {
                List<Action> actions = release.getActions();
                if (actions == null) {
                    actions = new ArrayList<Action>();
                }
                actions.add(this.parseAction(parser, strict));
                release.setActions(actions);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return release;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

