/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.issues;

import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.reporting.AbstractMavenReportRenderer;

public abstract class AbstractIssuesReportRenderer
extends AbstractMavenReportRenderer {
    protected final ResourceBundle bundle;

    protected AbstractIssuesReportRenderer(Sink sink, ResourceBundle bundle) {
        super(sink);
        this.bundle = bundle;
    }

    public String getAuthor() {
        return null;
    }

    public String getTitle() {
        return this.bundle.getString("report.issues.header");
    }

    public void render() {
        String title = this.getTitle();
        this.sink.head();
        this.sink.title();
        this.text(title);
        this.sink.title_();
        String author = this.getAuthor();
        if (author != null) {
            this.sink.author();
            this.text(author);
            this.sink.author_();
        }
        this.sink.head_();
        this.sink.body();
        this.startSection(title);
        this.renderBody();
        this.endSection();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    protected void sinkCell(String text) {
        this.sink.tableCell();
        if (text != null) {
            this.text(text);
        } else {
            this.sink.nonBreakingSpace();
        }
        this.sink.tableCell_();
    }

    protected void sinkCellLink(String text, String link) {
        this.sink.tableCell();
        this.link(link, text);
        this.sink.tableCell_();
    }

    protected void sinkFigure(String image, String altText) {
        SinkEventAttributeSet attributes = new SinkEventAttributeSet();
        attributes.addAttribute((Object)"alt", (Object)altText);
        attributes.addAttribute((Object)"title", (Object)altText);
        this.sink.figureGraphics(image, (SinkEventAttributes)attributes);
    }

    protected void sinkShowTypeIcon(String type) {
        String image = "";
        String altText = "";
        if (type == null) {
            image = "images/icon_help_sml.gif";
            altText = "Unknown";
        } else if (type.equals("fix")) {
            image = "images/fix.gif";
            altText = "Fix";
        } else if (type.equals("update")) {
            image = "images/update.gif";
            altText = "Update";
        } else if (type.equals("add")) {
            image = "images/add.gif";
            altText = "Add";
        } else if (type.equals("remove")) {
            image = "images/remove.gif";
            altText = "Remove";
        }
        this.sink.tableCell();
        this.sinkFigure(image, altText);
        this.sink.tableCell_();
    }
}

