/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes.schema;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.maven.plugin.changes.schema.ChangesSchemaValidator;
import org.apache.maven.plugin.changes.schema.SchemaValidatorException;
import org.apache.maven.plugin.changes.schema.XmlValidationHandler;
import org.codehaus.plexus.util.FastMap;
import org.xml.sax.SAXException;

public class DefaultChangesSchemaValidator
implements ChangesSchemaValidator {
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String CHANGES_SCHEMA_PATH = "META-INF/changes/xsd/";
    private Map compiledSchemas = new FastMap();

    public XmlValidationHandler validateXmlWithSchema(File file, String schemaVersion, boolean failOnValidationError) throws SchemaValidatorException {
        try {
            String schemaPath = "META-INF/changes/xsd/changes-" + schemaVersion + ".xsd";
            Schema schema = this.getSchema(schemaPath);
            Validator validator = schema.newValidator();
            XmlValidationHandler baseHandler = new XmlValidationHandler(failOnValidationError);
            validator.setErrorHandler(baseHandler);
            validator.validate(new StreamSource(new FileReader(file)));
            return baseHandler;
        }
        catch (IOException e) {
            throw new SchemaValidatorException("IOException : " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new SchemaValidatorException("SAXException : " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SchemaValidatorException("Exception : " + e.getMessage(), e);
        }
    }

    public Schema getSchema(String schemaPath) throws SAXException {
        if (this.compiledSchemas.containsKey(schemaPath)) {
            return (Schema)this.compiledSchemas.get(schemaPath);
        }
        Schema schema = this.compileJAXPSchema(schemaPath);
        this.compiledSchemas.put(schemaPath, schema);
        return schema;
    }

    private Schema compileJAXPSchema(String uriSchema) throws SAXException, NullPointerException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(uriSchema);
        if (is == null) {
            throw new NullPointerException(" impossible to load schema with path " + uriSchema);
        }
        return SchemaFactory.newInstance(W3C_XML_SCHEMA).newSchema(new StreamSource(is));
    }

    public void loadSchema(String uriSchema) throws SchemaValidatorException {
        try {
            this.getSchema(uriSchema);
        }
        catch (SAXException e) {
            throw new SchemaValidatorException("SAXException : " + e.getMessage(), e);
        }
    }
}

