/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changelog;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.changelog.ChangeLogReport;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.command.changelog.ChangeLogSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="dev-activity")
public class DeveloperActivityReport
extends ChangeLogReport {
    private Map<String, List<ChangeSet>> commits;
    private Map<String, Map<String, ChangeFile>> files;

    @Override
    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.dev-activity.description");
    }

    @Override
    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.dev-activity.name");
    }

    @Override
    public String getOutputName() {
        return "dev-activity";
    }

    @Override
    protected void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.dev-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.dev-activity.mainTitle"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text("No sources found to create a report.");
        sink.paragraph_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    @Override
    protected void doGenerateReport(List<ChangeLogSet> changeLogSets, ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.dev-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.dev-activity.mainTitle"));
        sink.sectionTitle1_();
        if (this.developers.isEmpty()) {
            sink.paragraph();
            sink.text(bundle.getString("report.dev-activity.noDevelopers"));
            sink.paragraph_();
        } else {
            for (ChangeLogSet set : changeLogSets) {
                this.doChangedSets(set, bundle, sink);
            }
        }
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void doChangedSets(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.section2();
        this.doChangeSetTitle(set, bundle, sink);
        this.doSummary(set, bundle, sink);
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.dev-activity.developer"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.TotalCommits"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.dev-activity.filesChanged"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        this.doDeveloperRows(set, sink);
        sink.table_();
        sink.section2_();
    }

    private void doDeveloperRows(ChangeLogSet set, Sink sink) {
        this.initDeveloperDetails(set);
        for (Map.Entry<String, List<ChangeSet>> commit : this.commits.entrySet()) {
            String author = commit.getKey();
            List<ChangeSet> devCommits = commit.getValue();
            Map<String, ChangeFile> devFiles = this.files.get(author);
            sink.tableRow();
            sink.tableCell();
            this.sinkAuthorDetails(sink, author);
            sink.tableCell_();
            sink.tableCell();
            sink.text(String.valueOf(devCommits.size()));
            sink.tableCell_();
            sink.tableCell();
            sink.text(String.valueOf(devFiles.size()));
            sink.tableCell_();
            sink.tableRow_();
        }
    }

    private void initDeveloperDetails(ChangeLogSet set) {
        this.commits = new HashMap<String, List<ChangeSet>>();
        this.files = new HashMap<String, Map<String, ChangeFile>>();
        this.countDevCommits(set.getChangeSets());
        this.countDevFiles(set.getChangeSets());
    }

    private void countDevCommits(Collection<ChangeSet> entries) {
        for (ChangeSet entry : entries) {
            String developer = entry.getAuthor();
            List<ChangeSet> list = this.commits.get(developer);
            if (list == null) {
                list = new LinkedList<ChangeSet>();
                this.commits.put(developer, list);
            }
            list.add(entry);
        }
    }

    private void countDevFiles(Collection<ChangeSet> entries) {
        for (ChangeSet entry : entries) {
            String developer = entry.getAuthor();
            Map<String, ChangeFile> filesMap = this.files.get(developer);
            if (filesMap == null) {
                filesMap = new HashMap<String, ChangeFile>();
                this.files.put(developer, filesMap);
            }
            for (ChangeFile file : entry.getFiles()) {
                filesMap.put(file.getName(), file);
            }
        }
    }
}

