// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.1.2,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.plugins.assembly.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugins.assembly.model.Component;
import org.apache.maven.plugins.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileItem;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.ModuleBinaries;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.plugins.assembly.model.ModuleSources;
import org.apache.maven.plugins.assembly.model.UnpackOptions;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class ComponentXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class ComponentXpp3Writer
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private static final String NAMESPACE = null;

    /**
     * Field fileComment.
     */
    private String fileComment = null;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method setFileComment.
     * 
     * @param fileComment a fileComment object.
     */
    public void setFileComment( String fileComment )
    {
        this.fileComment = fileComment;
    } //-- void setFileComment( String )

    /**
     * Method write.
     * 
     * @param writer a writer object.
     * @param component a component object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    public void write( Writer writer, Component component )
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( component.getModelEncoding(), null );
        writeComponent( component, "component", serializer );
        serializer.endDocument();
    } //-- void write( Writer, Component )

    /**
     * Method write.
     * 
     * @param stream a stream object.
     * @param component a component object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    public void write( OutputStream stream, Component component )
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( stream, component.getModelEncoding() );
        serializer.startDocument( component.getModelEncoding(), null );
        writeComponent( component, "component", serializer );
        serializer.endDocument();
    } //-- void write( OutputStream, Component )

    /**
     * Method writeComponent.
     * 
     * @param component a component object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeComponent( Component component, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( this.fileComment != null )
        {
        serializer.comment(this.fileComment);
        }
        serializer.setPrefix( "", "http://maven.apache.org/ASSEMBLY-COMPONENT/2.2.0" );
        serializer.setPrefix( "xsi", "http://www.w3.org/2001/XMLSchema-instance" );
        serializer.startTag( NAMESPACE, tagName );
        serializer.attribute( "", "xsi:schemaLocation", "http://maven.apache.org/ASSEMBLY-COMPONENT/2.2.0 https://maven.apache.org/xsd/assembly-component-2.2.0.xsd" );
        if ( ( component.getModuleSets() != null ) && ( component.getModuleSets().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "moduleSets" );
            for ( Iterator iter = component.getModuleSets().iterator(); iter.hasNext(); )
            {
                ModuleSet o = (ModuleSet) iter.next();
                writeModuleSet( o, "moduleSet", serializer );
            }
            serializer.endTag( NAMESPACE, "moduleSets" );
        }
        if ( ( component.getFileSets() != null ) && ( component.getFileSets().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "fileSets" );
            for ( Iterator iter = component.getFileSets().iterator(); iter.hasNext(); )
            {
                FileSet o = (FileSet) iter.next();
                writeFileSet( o, "fileSet", serializer );
            }
            serializer.endTag( NAMESPACE, "fileSets" );
        }
        if ( ( component.getFiles() != null ) && ( component.getFiles().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "files" );
            for ( Iterator iter = component.getFiles().iterator(); iter.hasNext(); )
            {
                FileItem o = (FileItem) iter.next();
                writeFileItem( o, "file", serializer );
            }
            serializer.endTag( NAMESPACE, "files" );
        }
        if ( ( component.getDependencySets() != null ) && ( component.getDependencySets().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "dependencySets" );
            for ( Iterator iter = component.getDependencySets().iterator(); iter.hasNext(); )
            {
                DependencySet o = (DependencySet) iter.next();
                writeDependencySet( o, "dependencySet", serializer );
            }
            serializer.endTag( NAMESPACE, "dependencySets" );
        }
        if ( ( component.getContainerDescriptorHandlers() != null ) && ( component.getContainerDescriptorHandlers().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "containerDescriptorHandlers" );
            for ( Iterator iter = component.getContainerDescriptorHandlers().iterator(); iter.hasNext(); )
            {
                ContainerDescriptorHandlerConfig o = (ContainerDescriptorHandlerConfig) iter.next();
                writeContainerDescriptorHandlerConfig( o, "containerDescriptorHandler", serializer );
            }
            serializer.endTag( NAMESPACE, "containerDescriptorHandlers" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeComponent( Component, String, XmlSerializer )

    /**
     * Method writeContainerDescriptorHandlerConfig.
     * 
     * @param containerDescriptorHandlerConfig a
     * containerDescriptorHandlerConfig object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeContainerDescriptorHandlerConfig( ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( containerDescriptorHandlerConfig.getHandlerName() != null )
        {
            serializer.startTag( NAMESPACE, "handlerName" ).text( containerDescriptorHandlerConfig.getHandlerName() ).endTag( NAMESPACE, "handlerName" );
        }
        if ( containerDescriptorHandlerConfig.getConfiguration() != null )
        {
            ((Xpp3Dom) containerDescriptorHandlerConfig.getConfiguration()).writeToSerializer( NAMESPACE, serializer );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeContainerDescriptorHandlerConfig( ContainerDescriptorHandlerConfig, String, XmlSerializer )

    /**
     * Method writeDependencySet.
     * 
     * @param dependencySet a dependencySet object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeDependencySet( DependencySet dependencySet, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( dependencySet.getOutputDirectory() != null )
        {
            serializer.startTag( NAMESPACE, "outputDirectory" ).text( dependencySet.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
        }
        if ( ( dependencySet.getIncludes() != null ) && ( dependencySet.getIncludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "includes" );
            for ( Iterator iter = dependencySet.getIncludes().iterator(); iter.hasNext(); )
            {
                String include = (String) iter.next();
                serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
            }
            serializer.endTag( NAMESPACE, "includes" );
        }
        if ( ( dependencySet.getExcludes() != null ) && ( dependencySet.getExcludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "excludes" );
            for ( Iterator iter = dependencySet.getExcludes().iterator(); iter.hasNext(); )
            {
                String exclude = (String) iter.next();
                serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
            }
            serializer.endTag( NAMESPACE, "excludes" );
        }
        if ( dependencySet.getFileMode() != null )
        {
            serializer.startTag( NAMESPACE, "fileMode" ).text( dependencySet.getFileMode() ).endTag( NAMESPACE, "fileMode" );
        }
        if ( dependencySet.getDirectoryMode() != null )
        {
            serializer.startTag( NAMESPACE, "directoryMode" ).text( dependencySet.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
        }
        if ( dependencySet.isUseStrictFiltering() != false )
        {
            serializer.startTag( NAMESPACE, "useStrictFiltering" ).text( String.valueOf( dependencySet.isUseStrictFiltering() ) ).endTag( NAMESPACE, "useStrictFiltering" );
        }
        if ( ( dependencySet.getOutputFileNameMapping() != null ) && !dependencySet.getOutputFileNameMapping().equals( "${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}" ) )
        {
            serializer.startTag( NAMESPACE, "outputFileNameMapping" ).text( dependencySet.getOutputFileNameMapping() ).endTag( NAMESPACE, "outputFileNameMapping" );
        }
        if ( dependencySet.isUnpack() != false )
        {
            serializer.startTag( NAMESPACE, "unpack" ).text( String.valueOf( dependencySet.isUnpack() ) ).endTag( NAMESPACE, "unpack" );
        }
        if ( dependencySet.getUnpackOptions() != null )
        {
            writeUnpackOptions( (UnpackOptions) dependencySet.getUnpackOptions(), "unpackOptions", serializer );
        }
        if ( ( dependencySet.getScope() != null ) && !dependencySet.getScope().equals( "runtime" ) )
        {
            serializer.startTag( NAMESPACE, "scope" ).text( dependencySet.getScope() ).endTag( NAMESPACE, "scope" );
        }
        if ( dependencySet.isUseProjectArtifact() != true )
        {
            serializer.startTag( NAMESPACE, "useProjectArtifact" ).text( String.valueOf( dependencySet.isUseProjectArtifact() ) ).endTag( NAMESPACE, "useProjectArtifact" );
        }
        if ( dependencySet.isUseProjectAttachments() != false )
        {
            serializer.startTag( NAMESPACE, "useProjectAttachments" ).text( String.valueOf( dependencySet.isUseProjectAttachments() ) ).endTag( NAMESPACE, "useProjectAttachments" );
        }
        if ( dependencySet.isUseTransitiveDependencies() != true )
        {
            serializer.startTag( NAMESPACE, "useTransitiveDependencies" ).text( String.valueOf( dependencySet.isUseTransitiveDependencies() ) ).endTag( NAMESPACE, "useTransitiveDependencies" );
        }
        if ( dependencySet.isUseTransitiveFiltering() != false )
        {
            serializer.startTag( NAMESPACE, "useTransitiveFiltering" ).text( String.valueOf( dependencySet.isUseTransitiveFiltering() ) ).endTag( NAMESPACE, "useTransitiveFiltering" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeDependencySet( DependencySet, String, XmlSerializer )

    /**
     * Method writeFileItem.
     * 
     * @param fileItem a fileItem object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeFileItem( FileItem fileItem, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( fileItem.getSource() != null )
        {
            serializer.startTag( NAMESPACE, "source" ).text( fileItem.getSource() ).endTag( NAMESPACE, "source" );
        }
        if ( ( fileItem.getSources() != null ) && ( fileItem.getSources().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "sources" );
            for ( Iterator iter = fileItem.getSources().iterator(); iter.hasNext(); )
            {
                String source = (String) iter.next();
                serializer.startTag( NAMESPACE, "source" ).text( source ).endTag( NAMESPACE, "source" );
            }
            serializer.endTag( NAMESPACE, "sources" );
        }
        if ( fileItem.getOutputDirectory() != null )
        {
            serializer.startTag( NAMESPACE, "outputDirectory" ).text( fileItem.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
        }
        if ( fileItem.getDestName() != null )
        {
            serializer.startTag( NAMESPACE, "destName" ).text( fileItem.getDestName() ).endTag( NAMESPACE, "destName" );
        }
        if ( fileItem.getFileMode() != null )
        {
            serializer.startTag( NAMESPACE, "fileMode" ).text( fileItem.getFileMode() ).endTag( NAMESPACE, "fileMode" );
        }
        if ( fileItem.getLineEnding() != null )
        {
            serializer.startTag( NAMESPACE, "lineEnding" ).text( fileItem.getLineEnding() ).endTag( NAMESPACE, "lineEnding" );
        }
        if ( fileItem.isFiltered() != false )
        {
            serializer.startTag( NAMESPACE, "filtered" ).text( String.valueOf( fileItem.isFiltered() ) ).endTag( NAMESPACE, "filtered" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeFileItem( FileItem, String, XmlSerializer )

    /**
     * Method writeFileSet.
     * 
     * @param fileSet a fileSet object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeFileSet( FileSet fileSet, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( fileSet.isUseDefaultExcludes() != true )
        {
            serializer.startTag( NAMESPACE, "useDefaultExcludes" ).text( String.valueOf( fileSet.isUseDefaultExcludes() ) ).endTag( NAMESPACE, "useDefaultExcludes" );
        }
        if ( fileSet.getOutputDirectory() != null )
        {
            serializer.startTag( NAMESPACE, "outputDirectory" ).text( fileSet.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
        }
        if ( ( fileSet.getIncludes() != null ) && ( fileSet.getIncludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "includes" );
            for ( Iterator iter = fileSet.getIncludes().iterator(); iter.hasNext(); )
            {
                String include = (String) iter.next();
                serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
            }
            serializer.endTag( NAMESPACE, "includes" );
        }
        if ( ( fileSet.getExcludes() != null ) && ( fileSet.getExcludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "excludes" );
            for ( Iterator iter = fileSet.getExcludes().iterator(); iter.hasNext(); )
            {
                String exclude = (String) iter.next();
                serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
            }
            serializer.endTag( NAMESPACE, "excludes" );
        }
        if ( fileSet.getFileMode() != null )
        {
            serializer.startTag( NAMESPACE, "fileMode" ).text( fileSet.getFileMode() ).endTag( NAMESPACE, "fileMode" );
        }
        if ( fileSet.getDirectoryMode() != null )
        {
            serializer.startTag( NAMESPACE, "directoryMode" ).text( fileSet.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
        }
        if ( fileSet.getDirectory() != null )
        {
            serializer.startTag( NAMESPACE, "directory" ).text( fileSet.getDirectory() ).endTag( NAMESPACE, "directory" );
        }
        if ( fileSet.getLineEnding() != null )
        {
            serializer.startTag( NAMESPACE, "lineEnding" ).text( fileSet.getLineEnding() ).endTag( NAMESPACE, "lineEnding" );
        }
        if ( fileSet.isFiltered() != false )
        {
            serializer.startTag( NAMESPACE, "filtered" ).text( String.valueOf( fileSet.isFiltered() ) ).endTag( NAMESPACE, "filtered" );
        }
        if ( ( fileSet.getNonFilteredFileExtensions() != null ) && ( fileSet.getNonFilteredFileExtensions().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "nonFilteredFileExtensions" );
            for ( Iterator iter = fileSet.getNonFilteredFileExtensions().iterator(); iter.hasNext(); )
            {
                String nonFilteredFileExtension = (String) iter.next();
                serializer.startTag( NAMESPACE, "nonFilteredFileExtension" ).text( nonFilteredFileExtension ).endTag( NAMESPACE, "nonFilteredFileExtension" );
            }
            serializer.endTag( NAMESPACE, "nonFilteredFileExtensions" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeFileSet( FileSet, String, XmlSerializer )

    /**
     * Method writeModuleBinaries.
     * 
     * @param moduleBinaries a moduleBinaries object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeModuleBinaries( ModuleBinaries moduleBinaries, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( moduleBinaries.getOutputDirectory() != null )
        {
            serializer.startTag( NAMESPACE, "outputDirectory" ).text( moduleBinaries.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
        }
        if ( ( moduleBinaries.getIncludes() != null ) && ( moduleBinaries.getIncludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "includes" );
            for ( Iterator iter = moduleBinaries.getIncludes().iterator(); iter.hasNext(); )
            {
                String include = (String) iter.next();
                serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
            }
            serializer.endTag( NAMESPACE, "includes" );
        }
        if ( ( moduleBinaries.getExcludes() != null ) && ( moduleBinaries.getExcludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "excludes" );
            for ( Iterator iter = moduleBinaries.getExcludes().iterator(); iter.hasNext(); )
            {
                String exclude = (String) iter.next();
                serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
            }
            serializer.endTag( NAMESPACE, "excludes" );
        }
        if ( moduleBinaries.getFileMode() != null )
        {
            serializer.startTag( NAMESPACE, "fileMode" ).text( moduleBinaries.getFileMode() ).endTag( NAMESPACE, "fileMode" );
        }
        if ( moduleBinaries.getDirectoryMode() != null )
        {
            serializer.startTag( NAMESPACE, "directoryMode" ).text( moduleBinaries.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
        }
        if ( moduleBinaries.getAttachmentClassifier() != null )
        {
            serializer.startTag( NAMESPACE, "attachmentClassifier" ).text( moduleBinaries.getAttachmentClassifier() ).endTag( NAMESPACE, "attachmentClassifier" );
        }
        if ( moduleBinaries.isIncludeDependencies() != true )
        {
            serializer.startTag( NAMESPACE, "includeDependencies" ).text( String.valueOf( moduleBinaries.isIncludeDependencies() ) ).endTag( NAMESPACE, "includeDependencies" );
        }
        if ( ( moduleBinaries.getDependencySets() != null ) && ( moduleBinaries.getDependencySets().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "dependencySets" );
            for ( Iterator iter = moduleBinaries.getDependencySets().iterator(); iter.hasNext(); )
            {
                DependencySet o = (DependencySet) iter.next();
                writeDependencySet( o, "dependencySet", serializer );
            }
            serializer.endTag( NAMESPACE, "dependencySets" );
        }
        if ( moduleBinaries.isUnpack() != true )
        {
            serializer.startTag( NAMESPACE, "unpack" ).text( String.valueOf( moduleBinaries.isUnpack() ) ).endTag( NAMESPACE, "unpack" );
        }
        if ( moduleBinaries.getUnpackOptions() != null )
        {
            writeUnpackOptions( (UnpackOptions) moduleBinaries.getUnpackOptions(), "unpackOptions", serializer );
        }
        if ( ( moduleBinaries.getOutputFileNameMapping() != null ) && !moduleBinaries.getOutputFileNameMapping().equals( "${module.artifactId}-${module.version}${dashClassifier?}.${module.extension}" ) )
        {
            serializer.startTag( NAMESPACE, "outputFileNameMapping" ).text( moduleBinaries.getOutputFileNameMapping() ).endTag( NAMESPACE, "outputFileNameMapping" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeModuleBinaries( ModuleBinaries, String, XmlSerializer )

    /**
     * Method writeModuleSet.
     * 
     * @param moduleSet a moduleSet object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeModuleSet( ModuleSet moduleSet, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( moduleSet.isUseAllReactorProjects() != false )
        {
            serializer.startTag( NAMESPACE, "useAllReactorProjects" ).text( String.valueOf( moduleSet.isUseAllReactorProjects() ) ).endTag( NAMESPACE, "useAllReactorProjects" );
        }
        if ( moduleSet.isIncludeSubModules() != true )
        {
            serializer.startTag( NAMESPACE, "includeSubModules" ).text( String.valueOf( moduleSet.isIncludeSubModules() ) ).endTag( NAMESPACE, "includeSubModules" );
        }
        if ( ( moduleSet.getIncludes() != null ) && ( moduleSet.getIncludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "includes" );
            for ( Iterator iter = moduleSet.getIncludes().iterator(); iter.hasNext(); )
            {
                String include = (String) iter.next();
                serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
            }
            serializer.endTag( NAMESPACE, "includes" );
        }
        if ( ( moduleSet.getExcludes() != null ) && ( moduleSet.getExcludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "excludes" );
            for ( Iterator iter = moduleSet.getExcludes().iterator(); iter.hasNext(); )
            {
                String exclude = (String) iter.next();
                serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
            }
            serializer.endTag( NAMESPACE, "excludes" );
        }
        if ( moduleSet.getSources() != null )
        {
            writeModuleSources( (ModuleSources) moduleSet.getSources(), "sources", serializer );
        }
        if ( moduleSet.getBinaries() != null )
        {
            writeModuleBinaries( (ModuleBinaries) moduleSet.getBinaries(), "binaries", serializer );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeModuleSet( ModuleSet, String, XmlSerializer )

    /**
     * Method writeModuleSources.
     * 
     * @param moduleSources a moduleSources object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeModuleSources( ModuleSources moduleSources, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( moduleSources.isUseDefaultExcludes() != true )
        {
            serializer.startTag( NAMESPACE, "useDefaultExcludes" ).text( String.valueOf( moduleSources.isUseDefaultExcludes() ) ).endTag( NAMESPACE, "useDefaultExcludes" );
        }
        if ( moduleSources.getOutputDirectory() != null )
        {
            serializer.startTag( NAMESPACE, "outputDirectory" ).text( moduleSources.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
        }
        if ( ( moduleSources.getIncludes() != null ) && ( moduleSources.getIncludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "includes" );
            for ( Iterator iter = moduleSources.getIncludes().iterator(); iter.hasNext(); )
            {
                String include = (String) iter.next();
                serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
            }
            serializer.endTag( NAMESPACE, "includes" );
        }
        if ( ( moduleSources.getExcludes() != null ) && ( moduleSources.getExcludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "excludes" );
            for ( Iterator iter = moduleSources.getExcludes().iterator(); iter.hasNext(); )
            {
                String exclude = (String) iter.next();
                serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
            }
            serializer.endTag( NAMESPACE, "excludes" );
        }
        if ( moduleSources.getFileMode() != null )
        {
            serializer.startTag( NAMESPACE, "fileMode" ).text( moduleSources.getFileMode() ).endTag( NAMESPACE, "fileMode" );
        }
        if ( moduleSources.getDirectoryMode() != null )
        {
            serializer.startTag( NAMESPACE, "directoryMode" ).text( moduleSources.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
        }
        if ( ( moduleSources.getFileSets() != null ) && ( moduleSources.getFileSets().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "fileSets" );
            for ( Iterator iter = moduleSources.getFileSets().iterator(); iter.hasNext(); )
            {
                FileSet o = (FileSet) iter.next();
                writeFileSet( o, "fileSet", serializer );
            }
            serializer.endTag( NAMESPACE, "fileSets" );
        }
        if ( moduleSources.isIncludeModuleDirectory() != true )
        {
            serializer.startTag( NAMESPACE, "includeModuleDirectory" ).text( String.valueOf( moduleSources.isIncludeModuleDirectory() ) ).endTag( NAMESPACE, "includeModuleDirectory" );
        }
        if ( moduleSources.isExcludeSubModuleDirectories() != true )
        {
            serializer.startTag( NAMESPACE, "excludeSubModuleDirectories" ).text( String.valueOf( moduleSources.isExcludeSubModuleDirectories() ) ).endTag( NAMESPACE, "excludeSubModuleDirectories" );
        }
        if ( ( moduleSources.getOutputDirectoryMapping() != null ) && !moduleSources.getOutputDirectoryMapping().equals( "${module.artifactId}" ) )
        {
            serializer.startTag( NAMESPACE, "outputDirectoryMapping" ).text( moduleSources.getOutputDirectoryMapping() ).endTag( NAMESPACE, "outputDirectoryMapping" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeModuleSources( ModuleSources, String, XmlSerializer )

    /**
     * Method writeUnpackOptions.
     * 
     * @param unpackOptions a unpackOptions object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeUnpackOptions( UnpackOptions unpackOptions, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( ( unpackOptions.getIncludes() != null ) && ( unpackOptions.getIncludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "includes" );
            for ( Iterator iter = unpackOptions.getIncludes().iterator(); iter.hasNext(); )
            {
                String include = (String) iter.next();
                serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
            }
            serializer.endTag( NAMESPACE, "includes" );
        }
        if ( ( unpackOptions.getExcludes() != null ) && ( unpackOptions.getExcludes().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "excludes" );
            for ( Iterator iter = unpackOptions.getExcludes().iterator(); iter.hasNext(); )
            {
                String exclude = (String) iter.next();
                serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
            }
            serializer.endTag( NAMESPACE, "excludes" );
        }
        if ( unpackOptions.isFiltered() != false )
        {
            serializer.startTag( NAMESPACE, "filtered" ).text( String.valueOf( unpackOptions.isFiltered() ) ).endTag( NAMESPACE, "filtered" );
        }
        if ( ( unpackOptions.getNonFilteredFileExtensions() != null ) && ( unpackOptions.getNonFilteredFileExtensions().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "nonFilteredFileExtensions" );
            for ( Iterator iter = unpackOptions.getNonFilteredFileExtensions().iterator(); iter.hasNext(); )
            {
                String nonFilteredFileExtension = (String) iter.next();
                serializer.startTag( NAMESPACE, "nonFilteredFileExtension" ).text( nonFilteredFileExtension ).endTag( NAMESPACE, "nonFilteredFileExtension" );
            }
            serializer.endTag( NAMESPACE, "nonFilteredFileExtensions" );
        }
        if ( unpackOptions.getLineEnding() != null )
        {
            serializer.startTag( NAMESPACE, "lineEnding" ).text( unpackOptions.getLineEnding() ).endTag( NAMESPACE, "lineEnding" );
        }
        if ( unpackOptions.isUseDefaultExcludes() != true )
        {
            serializer.startTag( NAMESPACE, "useDefaultExcludes" ).text( String.valueOf( unpackOptions.isUseDefaultExcludes() ) ).endTag( NAMESPACE, "useDefaultExcludes" );
        }
        if ( unpackOptions.getEncoding() != null )
        {
            serializer.startTag( NAMESPACE, "encoding" ).text( unpackOptions.getEncoding() ).endTag( NAMESPACE, "encoding" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeUnpackOptions( UnpackOptions, String, XmlSerializer )

}
