/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugins.assembly.archive.ManifestCreationFinalizer;
import org.apache.maven.plugins.assembly.archive.archiver.AssemblyProxyArchiver;
import org.apache.maven.plugins.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugins.assembly.archive.phase.AssemblyArchiverPhaseComparator;
import org.apache.maven.plugins.assembly.artifact.DependencyResolutionException;
import org.apache.maven.plugins.assembly.filter.ComponentsXmlArchiverFileFilter;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.internal.DebugConfigurationListener;
import org.apache.maven.plugins.assembly.interpolation.AssemblyExpressionEvaluator;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugins.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugins.assembly.utils.AssemblyFormatUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.diags.DryRunArchiver;
import org.codehaus.plexus.archiver.filters.JarSecurityFileSelector;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.archiver.zip.AbstractZipArchiver;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultAssemblyArchiver
implements AssemblyArchiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAssemblyArchiver.class);
    private final ArchiverManager archiverManager;
    private final List<AssemblyArchiverPhase> assemblyPhases;
    private final Map<String, ContainerDescriptorHandler> containerDescriptorHandlers;
    private final PlexusContainer container;

    @Inject
    public DefaultAssemblyArchiver(ArchiverManager archiverManager, List<AssemblyArchiverPhase> assemblyPhases, Map<String, ContainerDescriptorHandler> containerDescriptorHandlers, PlexusContainer container) {
        this.archiverManager = Objects.requireNonNull(archiverManager);
        this.assemblyPhases = Objects.requireNonNull(assemblyPhases);
        this.containerDescriptorHandlers = Objects.requireNonNull(containerDescriptorHandlers);
        this.container = Objects.requireNonNull(container);
    }

    private List<AssemblyArchiverPhase> sortedPhases() {
        ArrayList<AssemblyArchiverPhase> sorted = new ArrayList<AssemblyArchiverPhase>(this.assemblyPhases);
        Collections.sort(sorted, new AssemblyArchiverPhaseComparator());
        return sorted;
    }

    @Override
    public File createArchive(Assembly assembly, String fullName, String format, AssemblerConfigurationSource configSource, boolean recompressZippedFiles, String mergeManifestMode, FileTime outputTimestamp) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        this.validate(assembly);
        String filename = fullName;
        if (!configSource.isIgnoreDirFormatExtensions() || !format.startsWith("dir")) {
            filename = filename + "." + format;
        }
        AssemblyFileUtils.verifyTempDirectoryAvailability(configSource.getTemporaryRootDirectory());
        File outputDirectory = configSource.getOutputDirectory();
        File destFile = new File(outputDirectory, filename);
        try {
            String finalName = configSource.getFinalName();
            String specifiedBasedir = assembly.getBaseDirectory();
            String basedir = finalName;
            if (specifiedBasedir != null) {
                basedir = AssemblyFormatUtils.getOutputDirectory(specifiedBasedir, finalName, configSource, AssemblyFormatUtils.moduleProjectInterpolator(configSource.getProject()), AssemblyFormatUtils.artifactProjectInterpolator(null));
            }
            List<ContainerDescriptorHandler> containerHandlers = this.selectContainerDescriptorHandlers(assembly.getContainerDescriptorHandlers(), configSource);
            Archiver archiver = this.createArchiver(format, assembly.isIncludeBaseDirectory(), basedir, configSource, containerHandlers, recompressZippedFiles, mergeManifestMode, outputTimestamp);
            archiver.setDestFile(destFile);
            for (AssemblyArchiverPhase phase : this.sortedPhases()) {
                phase.execute(assembly, archiver, configSource);
            }
            archiver.createArchive();
        }
        catch (IOException | ArchiverException e) {
            throw new ArchiveCreationException("Error creating assembly archive " + assembly.getId() + ": " + e.getMessage(), e);
        }
        catch (NoSuchArchiverException e) {
            throw new ArchiveCreationException("Unable to obtain archiver for extension '" + format + "', for assembly: '" + assembly.getId() + "'", e);
        }
        catch (DependencyResolutionException e) {
            throw new ArchiveCreationException("Unable to resolve dependencies for assembly '" + assembly.getId() + "'", e);
        }
        return destFile;
    }

    private void validate(Assembly assembly) throws InvalidAssemblerConfigurationException {
        if (assembly.getId() == null || assembly.getId().trim().length() < 1) {
            throw new InvalidAssemblerConfigurationException("Assembly ID must be present and non-empty.");
        }
    }

    private List<ContainerDescriptorHandler> selectContainerDescriptorHandlers(List<ContainerDescriptorHandlerConfig> requestedContainerDescriptorHandlers, AssemblerConfigurationSource configSource) throws InvalidAssemblerConfigurationException {
        LOGGER.debug("All known ContainerDescriptorHandler components: " + (this.containerDescriptorHandlers == null ? "none; map is null." : "" + this.containerDescriptorHandlers.keySet()));
        if (requestedContainerDescriptorHandlers == null) {
            requestedContainerDescriptorHandlers = new ArrayList<ContainerDescriptorHandlerConfig>();
        }
        ArrayList<ContainerDescriptorHandler> handlers = new ArrayList<ContainerDescriptorHandler>();
        ArrayList<String> hints = new ArrayList<String>();
        if (!requestedContainerDescriptorHandlers.isEmpty()) {
            for (ContainerDescriptorHandlerConfig config : requestedContainerDescriptorHandlers) {
                String hint = config.getHandlerName();
                ContainerDescriptorHandler handler = this.containerDescriptorHandlers.get(hint);
                if (handler == null) {
                    throw new InvalidAssemblerConfigurationException("Cannot find ContainerDescriptorHandler with hint: " + hint);
                }
                LOGGER.debug("Found container descriptor handler with hint: " + hint + " (component: " + handler + ")");
                if (config.getConfiguration() != null) {
                    LOGGER.debug("Configuring handler with:\n\n" + config.getConfiguration() + "\n\n");
                    this.configureContainerDescriptorHandler(handler, (Xpp3Dom)config.getConfiguration(), configSource);
                }
                handlers.add(handler);
                hints.add(hint);
            }
        }
        if (!hints.contains("plexus")) {
            handlers.add(new ComponentsXmlArchiverFileFilter());
        }
        return handlers;
    }

    protected Archiver createArchiver(String format, boolean includeBaseDir, String finalName, AssemblerConfigurationSource configSource, List<ContainerDescriptorHandler> containerHandlers, boolean recompressZippedFiles, String mergeManifestMode, FileTime outputTimestamp) throws NoSuchArchiverException {
        Archiver archiver = "tzst".equals(format) ? this.createTarZstArchiver() : this.archiverManager.getArchiver(format);
        if (archiver instanceof TarArchiver) {
            ((TarArchiver)archiver).setLongfile(TarLongFileMode.valueOf((String)configSource.getTarLongFileMode()));
        }
        if (archiver instanceof WarArchiver) {
            ((WarArchiver)archiver).setExpectWebXml(false);
        }
        if (archiver instanceof AbstractZipArchiver) {
            ((AbstractZipArchiver)archiver).setRecompressAddedZips(recompressZippedFiles);
        }
        ArrayList<FileSelector> extraSelectors = new ArrayList<FileSelector>();
        ArrayList<ArchiveFinalizer> extraFinalizers = new ArrayList<ArchiveFinalizer>();
        if (archiver instanceof JarArchiver) {
            this.configureJarArchiver((JarArchiver)archiver, mergeManifestMode);
            extraSelectors.add((FileSelector)new JarSecurityFileSelector());
            extraFinalizers.add((ArchiveFinalizer)new ManifestCreationFinalizer(configSource.getMavenSession(), configSource.getProject(), configSource.getJarArchiveConfiguration()));
        }
        if (configSource.getArchiverConfig() != null) {
            this.configureArchiver(archiver, configSource);
        }
        String prefix = "";
        if (includeBaseDir) {
            prefix = finalName;
        }
        archiver = new AssemblyProxyArchiver(prefix, archiver, containerHandlers, extraSelectors, extraFinalizers, configSource.getWorkingDirectory());
        if (configSource.isDryRun()) {
            archiver = new DryRunArchiver(archiver, LOGGER);
        }
        archiver.setIgnorePermissions(configSource.isIgnorePermissions());
        archiver.setForced(!configSource.isUpdateOnly());
        if (outputTimestamp != null) {
            archiver.configureReproducibleBuild(outputTimestamp);
        }
        if (configSource.getOverrideUid() != null) {
            archiver.setOverrideUid(configSource.getOverrideUid().intValue());
        }
        if (StringUtils.isNotBlank((String)configSource.getOverrideUserName())) {
            archiver.setOverrideUserName(StringUtils.trim((String)configSource.getOverrideUserName()));
        }
        if (configSource.getOverrideGid() != null) {
            archiver.setOverrideGid(configSource.getOverrideGid().intValue());
        }
        if (StringUtils.isNotBlank((String)configSource.getOverrideGroupName())) {
            archiver.setOverrideGroupName(StringUtils.trim((String)configSource.getOverrideGroupName()));
        }
        return archiver;
    }

    private void configureJarArchiver(JarArchiver archiver, String mergeManifestMode) {
        if (mergeManifestMode != null) {
            archiver.setFilesetmanifest(JarArchiver.FilesetManifestConfig.valueOf((String)mergeManifestMode));
        }
        archiver.setMinimalDefaultManifest(true);
    }

    private void configureContainerDescriptorHandler(ContainerDescriptorHandler handler, Xpp3Dom config, AssemblerConfigurationSource configSource) throws InvalidAssemblerConfigurationException {
        LOGGER.debug("Configuring handler: '" + handler.getClass().getName() + "' -->");
        try {
            this.configureComponent(handler, config, configSource);
        }
        catch (ComponentConfigurationException e) {
            throw new InvalidAssemblerConfigurationException("Failed to configure handler: " + handler.getClass().getName(), e);
        }
        catch (ComponentLookupException e) {
            throw new InvalidAssemblerConfigurationException("Failed to lookup configurator for setup of handler: " + handler.getClass().getName(), e);
        }
        LOGGER.debug("-- end configuration --");
    }

    private void configureArchiver(Archiver archiver, AssemblerConfigurationSource configSource) {
        Xpp3Dom config;
        try {
            config = Xpp3DomBuilder.build((Reader)new StringReader(configSource.getArchiverConfig()));
        }
        catch (IOException | XmlPullParserException e) {
            throw new ArchiverException("Failed to parse archiver configuration for: " + archiver.getClass().getName(), e);
        }
        LOGGER.debug("Configuring archiver: '" + archiver.getClass().getName() + "' -->");
        try {
            this.configureComponent(archiver, config, configSource);
        }
        catch (ComponentConfigurationException e) {
            throw new ArchiverException("Failed to configure archiver: " + archiver.getClass().getName(), (Throwable)e);
        }
        catch (ComponentLookupException e) {
            throw new ArchiverException("Failed to lookup configurator for setup of archiver: " + archiver.getClass().getName(), (Throwable)e);
        }
        LOGGER.debug("-- end configuration --");
    }

    private void configureComponent(Object component, Xpp3Dom config, AssemblerConfigurationSource configSource) throws ComponentLookupException, ComponentConfigurationException {
        ComponentConfigurator configurator = (ComponentConfigurator)this.container.lookup(ComponentConfigurator.class, "basic");
        DebugConfigurationListener listener = new DebugConfigurationListener(LOGGER);
        AssemblyExpressionEvaluator expressionEvaluator = new AssemblyExpressionEvaluator(configSource);
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(config);
        Object[] containerRealm = this.getContainerRealm();
        try {
            Method configureComponent = ComponentConfigurator.class.getMethod("configureComponent", Object.class, PlexusConfiguration.class, ExpressionEvaluator.class, (Class)containerRealm[1], ConfigurationListener.class);
            configureComponent.invoke((Object)configurator, component, configuration, expressionEvaluator, containerRealm[0], listener);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ComponentConfigurationException) {
                throw (ComponentConfigurationException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private Object[] getContainerRealm() {
        try {
            Method getContainerRealm = this.container.getClass().getMethod("getContainerRealm", new Class[0]);
            return new Object[]{getContainerRealm.invoke((Object)this.container, new Object[0]), getContainerRealm.getReturnType()};
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected Archiver createTarZstArchiver() throws NoSuchArchiverException {
        TarArchiver tarArchiver = (TarArchiver)this.archiverManager.getArchiver("tar");
        tarArchiver.setCompression(TarArchiver.TarCompressionMethod.zstd);
        return tarArchiver;
    }
}

